package fr.ifremer.adagio.core.service.technical.sanity.task;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: DatabaseSanityTask.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/sanity/task/DatabaseSanityTask.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Set;

import org.hibernate.Session;

/**
 * Created on 1/18/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 */
public interface DatabaseSanityTask {

	/**
	 * Sanity the database and return the set of cache id to refresh.
	 * 
	 * @param currentSession
	 *            database session
	 * @return the set of cache ids to clean.
	 */
	Set<String> sanity(Session currentSession);
}
