package fr.ifremer.adagio.core.service.referential.location;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: LocationServiceImpl.java 11870 2013-12-03 10:10:32Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/service/referential/location/LocationServiceImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;

@Service("locationService")
public class LocationServiceImpl implements LocationService {

	@Resource(name = "locationDao")
	private LocationExtendDao locationDao;

	@Override
	public String getLocationLabelByLatLong(Float latitude, Float longitude) {
		if (longitude == null || latitude == null) {
			throw new IllegalArgumentException("Arguments 'latitude' and 'longitude' should not be null.");
		}
		return locationDao.getLocationLabelByLatLong(latitude, longitude);
	}

	@Override
	public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
		String locationLabel = getLocationLabelByLatLong(latitude, longitude);
		if (locationLabel == null) {
			return null;
		}
		Integer locationId = locationDao.getLocationIdByLabelAndLocationLevel(locationLabel,
				new Integer[] { LocationLevelId.RECTANGLE_STATISTIQUE.getValue(), LocationLevelId.RECTANGLE_CGPM_GFCM.getValue(),
						LocationLevelId.FAO_ZONE.getValue() });
		return locationId;
	}

}
