// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.technical.optimization.vessel;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.VesselOwner;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Denormalized table for vessel. Usefull to retrieve information on vessel, such as name, owner,
 * registration country...
 * This table is NOT syncrhonized between Harmonie and Allegro databases.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class DenormalizedVessel
    implements Serializable, Comparable<DenormalizedVessel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 527722783686874609L;

    // Generate 9 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date registrationStartDate;

    /**
     * 
     * @return this.registrationStartDate Date
     */
    public Date getRegistrationStartDate()
    {
        return this.registrationStartDate;
    }

    /**
     * 
     * @param registrationStartDateIn Date
     */
    public void setRegistrationStartDate(Date registrationStartDateIn)
    {
        this.registrationStartDate = registrationStartDateIn;
    }

    private Date registrationEndDate;

    /**
     * 
     * @return this.registrationEndDate Date
     */
    public Date getRegistrationEndDate()
    {
        return this.registrationEndDate;
    }

    /**
     * 
     * @param registrationEndDateIn Date
     */
    public void setRegistrationEndDate(Date registrationEndDateIn)
    {
        this.registrationEndDate = registrationEndDateIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String registrationCode;

    /**
     * 
     * @return this.registrationCode String
     */
    public String getRegistrationCode()
    {
        return this.registrationCode;
    }

    /**
     * 
     * @param registrationCodeIn String
     */
    public void setRegistrationCode(String registrationCodeIn)
    {
        this.registrationCode = registrationCodeIn;
    }

    private String internationalRegistrationCode;

    /**
     * 
     * @return this.internationalRegistrationCode String
     */
    public String getInternationalRegistrationCode()
    {
        return this.internationalRegistrationCode;
    }

    /**
     * 
     * @param internationalRegistrationCodeIn String
     */
    public void setInternationalRegistrationCode(String internationalRegistrationCodeIn)
    {
        this.internationalRegistrationCode = internationalRegistrationCodeIn;
    }

    private String exteriorMarking;

    /**
     * 
     * @return this.exteriorMarking String
     */
    public String getExteriorMarking()
    {
        return this.exteriorMarking;
    }

    /**
     * 
     * @param exteriorMarkingIn String
     */
    public void setExteriorMarking(String exteriorMarkingIn)
    {
        this.exteriorMarking = exteriorMarkingIn;
    }

    private Short rankOrder = Short.valueOf("1");

    /**
     * Ajout pour gérer les cas ou  plusieurs infos sont trouvées sur une même période
     * d'immatriculation.
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * Ajout pour gérer les cas ou  plusieurs infos sont trouvées sur une même période
     * d'immatriculation.
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 5 associations
    private Location registrationLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.registrationLocation Location
     */
    public Location getRegistrationLocation()
    {
        return this.registrationLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param registrationLocationIn Location
     */
    public void setRegistrationLocation(Location registrationLocationIn)
    {
        this.registrationLocation = registrationLocationIn;
    }

    private Location registrationCountry;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.registrationCountry Location
     */
    public Location getRegistrationCountry()
    {
        return this.registrationCountry;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param registrationCountryIn Location
     */
    public void setRegistrationCountry(Location registrationCountryIn)
    {
        this.registrationCountry = registrationCountryIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private VesselOwner vesselOwner;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Armateur (ou propri&#233;taire) de navire(s). Personne physique ou morale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans le cas de pecheur &#224; pied ou groupement de navires, <i>VesselOwner</i>
     * permet aussi de porter les informations sur le pecheur &#224; pied, ou sur le
     * responsable du groupement de navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Nombre de lignes : 20900
     * </p>
     * </body>
     * </html>
     * @return this.vesselOwner VesselOwner
     */
    public VesselOwner getVesselOwner()
    {
        return this.vesselOwner;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Armateur (ou propri&#233;taire) de navire(s). Personne physique ou morale.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans le cas de pecheur &#224; pied ou groupement de navires, <i>VesselOwner</i>
     * permet aussi de porter les informations sur le pecheur &#224; pied, ou sur le
     * responsable du groupement de navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Nombre de lignes : 20900
     * </p>
     * </body>
     * </html>
     * @param vesselOwnerIn VesselOwner
     */
    public void setVesselOwner(VesselOwner vesselOwnerIn)
    {
        this.vesselOwner = vesselOwnerIn;
    }

    /**
     * Returns <code>true</code> if the argument is an DenormalizedVessel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof DenormalizedVessel))
        {
            return false;
        }
        final DenormalizedVessel that = (DenormalizedVessel)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link DenormalizedVessel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link DenormalizedVessel}.
         * @return new DenormalizedVesselImpl()
         */
        public static DenormalizedVessel newInstance()
        {
            return new DenormalizedVesselImpl();
        }

        /**
         * Constructs a new instance of {@link DenormalizedVessel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param registrationStartDate Date
         * @param rankOrder Short
         * @param registrationLocation Location
         * @param registrationCountry Location
         * @param vessel Vessel
         * @param program Program
         * @return newInstance
         */
        public static DenormalizedVessel newInstance(Date registrationStartDate, Short rankOrder, Location registrationLocation, Location registrationCountry, Vessel vessel, Program program)
        {
            final DenormalizedVessel entity = new DenormalizedVesselImpl();
            entity.setRegistrationStartDate(registrationStartDate);
            entity.setRankOrder(rankOrder);
            entity.setRegistrationLocation(registrationLocation);
            entity.setRegistrationCountry(registrationCountry);
            entity.setVessel(vessel);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link DenormalizedVessel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param registrationStartDate Date
         * @param registrationEndDate Date
         * @param name String
         * @param registrationCode String
         * @param internationalRegistrationCode String
         * @param exteriorMarking String
         * @param rankOrder Short
         * @param updateDate Timestamp
         * @param registrationLocation Location
         * @param registrationCountry Location
         * @param vessel Vessel
         * @param program Program
         * @param vesselOwner VesselOwner
         * @return newInstance DenormalizedVessel
         */
        public static DenormalizedVessel newInstance(Date registrationStartDate, Date registrationEndDate, String name, String registrationCode, String internationalRegistrationCode, String exteriorMarking, Short rankOrder, Timestamp updateDate, Location registrationLocation, Location registrationCountry, Vessel vessel, Program program, VesselOwner vesselOwner)
        {
            final DenormalizedVessel entity = new DenormalizedVesselImpl();
            entity.setRegistrationStartDate(registrationStartDate);
            entity.setRegistrationEndDate(registrationEndDate);
            entity.setName(name);
            entity.setRegistrationCode(registrationCode);
            entity.setInternationalRegistrationCode(internationalRegistrationCode);
            entity.setExteriorMarking(exteriorMarking);
            entity.setRankOrder(rankOrder);
            entity.setUpdateDate(updateDate);
            entity.setRegistrationLocation(registrationLocation);
            entity.setRegistrationCountry(registrationCountry);
            entity.setVessel(vessel);
            entity.setProgram(program);
            entity.setVesselOwner(vesselOwner);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(DenormalizedVessel o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRegistrationStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRegistrationStartDate().compareTo(o.getRegistrationStartDate()));
            }
            if (this.getRegistrationEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRegistrationEndDate().compareTo(o.getRegistrationEndDate()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getRegistrationCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRegistrationCode().compareTo(o.getRegistrationCode()));
            }
            if (this.getInternationalRegistrationCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getInternationalRegistrationCode().compareTo(o.getInternationalRegistrationCode()));
            }
            if (this.getExteriorMarking() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getExteriorMarking().compareTo(o.getExteriorMarking()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// DenormalizedVessel.java merge-point
}