// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Liste des rangs taxinomiques possibles.
 * C’est le nom du rang dans la classification systématique ; les niveaux systématiques sont
 * désignés par des termes consacrés (ex. : espèce, genre, famille, etc.). Le niveau systématique
 * d’un taxon peut changer avec l’évolution de la classification ; dans ce cas, son libellé est
 * susceptible de changer également car les suffixes notamment obéissent à des règles strictes de
 * nomenclature (règle [R0018]).
 * Les niveaux systématiques pris en compte dans le référentiel taxinomique Quadrige² sont (par
 * ordre de rang) (le nom anglais de chaque niveau est indiqué entre parenthèses) :
 * -	Règne (kingdom)
 * -	Sous-règne (subkingdom)
 * -	Division (division) / Embranchement (phylum)
 * -	Subdivision (subdivision) / Sous-embranchement (subphylum)
 * -	Super-classe (superclass)
 * -	Classe (class)
 * -	Sous-classe (subclass)
 * -	Infra-classe (infraclass)
 * -	Super-ordre (superordo)
 * -	Ordre (ordo)
 * -	Sous-ordre (subordo)
 * -	Infra-ordre (infraordo)
 * -	Section (section)
 * -	Sous-section (subsection)
 * -	Super-famille (superfamily)
 * -	Famille (family)
 * -	Sous-famille (subfamily)
 * -	Tribu (tribe)
 * -	Sous-tribu (subtribe)
 * -	Genre (genus)
 * -	Sous-genre (subgenus)
 * -	Espèce (species)
 * -	Sous-espèce (subspecies)
 * -	Variété (variety)
 * -	Sous-variété (subvariety)
 * -	Forme (forma)
 * -	Sous-forme (subforma)
 * -	Incertae sedis (dummy = taxons inclassables)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class TaxonomicLevel
    implements Serializable, Comparable<TaxonomicLevel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5844665311921377024L;

    // Generate 7 attributes
    private String code;

    /**
     * Code unique identifiant le rang taxinomique.
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * Code unique identifiant le rang taxinomique.
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private Integer rank;

    /**
     * Numéro du rang taxinomique.
     * Croissant du règne vers l'espèce
     * Ceci permet de limiter le choix des niveaux fils aux numéros supérieurs
     * @return this.rank Integer
     */
    public Integer getRank()
    {
        return this.rank;
    }

    /**
     * Numéro du rang taxinomique.
     * Croissant du règne vers l'espèce
     * Ceci permet de limiter le choix des niveaux fils aux numéros supérieurs
     * @param rankIn Integer
     */
    public void setRank(Integer rankIn)
    {
        this.rank = rankIn;
    }

    private String name;

    /**
     * Libellé du rang taxinomique
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé du rang taxinomique
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String label;

    /**
     * Mnémonique du rang taxinomique
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Mnémonique du rang taxinomique
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private String comments;

    /**
     * Commentaire décrivant le rang taxinomique
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire décrivant le rang taxinomique
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création système du niveau. Renseigné automatiquement par le système.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création système du niveau. Renseigné automatiquement par le système.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour système du niveau. Renseigné automatiquement par le système.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour système du niveau. Renseigné automatiquement par le système.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    private Collection<TaxonName> taxonNames = new HashSet<TaxonName>();

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @return this.taxonNames Collection<TaxonName>
     */
    public Collection<TaxonName> getTaxonNames()
    {
        return this.taxonNames;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param taxonNamesIn Collection<TaxonName>
     */
    public void setTaxonNames(Collection<TaxonName> taxonNamesIn)
    {
        this.taxonNames = taxonNamesIn;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param elementToAdd TaxonName
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonNames(TaxonName elementToAdd)
    {
        return this.taxonNames.add(elementToAdd);
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param elementToRemove TaxonName
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonNames(TaxonName elementToRemove)
    {
        return this.taxonNames.remove(elementToRemove);
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an TaxonomicLevel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonomicLevel))
        {
            return false;
        }
        final TaxonomicLevel that = (TaxonomicLevel)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link TaxonomicLevel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link TaxonomicLevel}.
         * @return new TaxonomicLevelImpl()
         */
        public static TaxonomicLevel newInstance()
        {
            return new TaxonomicLevelImpl();
        }

        /**
         * Constructs a new instance of {@link TaxonomicLevel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param rank Integer
         * @param name String
         * @param creationDate Date
         * @param status Status
         * @return newInstance
         */
        public static TaxonomicLevel newInstance(Integer rank, String name, Date creationDate, Status status)
        {
            final TaxonomicLevel entity = new TaxonomicLevelImpl();
            entity.setRank(rank);
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link TaxonomicLevel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param rank Integer
         * @param name String
         * @param label String
         * @param comments String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param taxonNames Collection<TaxonName>
         * @param status Status
         * @return newInstance TaxonomicLevel
         */
        public static TaxonomicLevel newInstance(Integer rank, String name, String label, String comments, Date creationDate, Timestamp updateDate, Collection<TaxonName> taxonNames, Status status)
        {
            final TaxonomicLevel entity = new TaxonomicLevelImpl();
            entity.setRank(rank);
            entity.setName(name);
            entity.setLabel(label);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setTaxonNames(taxonNames);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(TaxonomicLevel o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getRank() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRank().compareTo(o.getRank()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// TaxonomicLevel.java merge-point
}