package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: TaxonNameExtendDao.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/referential/taxon/TaxonNameExtendDao.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

public interface TaxonNameExtendDao extends TaxonNameDao {

	/**
	 * Get all taxon names, but obsolete taxon names are skipped.
	 * 
	 * @param withSynonyms
	 *            if {@code true}, return all taxon names, otherwise
	 *            only reference taxon name are returned.
	 * @return
	 */
	TaxonRefVO[] getAllTaxonNames(boolean withSynonyms);

	TaxonRefVO[] getAllTaxonNames(boolean withSynonyms, Integer transcribingId);

	/**
	 * Get a taxon name by his referenceTaxonId.
	 * Only the reference taxon name is return, but it could be obsolete or temporary.
	 * 
	 * @param referenceTaxonId
	 *            the reference taxon Id
	 * @return the refrence taxon name
	 */
	TaxonRefVO getTaxonNameReferent(Integer referenceTaxonId);

	/**
	 * Get a taxon name by his referenceTaxonId.
	 * Only the reference taxon name is return, but it could be obsolete or temporary.
	 * 
	 * @param referenceTaxonId
	 *            the reference taxon Id
	 * @return the refrence taxon name
	 */
	TaxonRefVO getTaxonNameReferent(Integer referenceTaxonId, Integer transcribingId);

	/**
	 * Create a new taxon name, as temporary (used for HSQLDB database only).
	 * 
	 * @param taxonNameVO
	 *            the taxon to Id
	 * @param comments
	 *            an optional comments to store in the taxon name
	 * @return the updated taxon name (with referenceTaxonId and taxonNameId)
	 */
	TaxonRefVO createAsTemporary(TaxonRefVO taxonNameVO, String comments);
}
