// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Cette classe contient le type d'informations relatives au taxon qui sont contenues dans le
 * document lié. Exemple: le document le désigne comme synonyme ou le document le désigne comme
 * référent.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class TaxonInformation
    implements Serializable, Comparable<TaxonInformation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -7636814457180596993L;

    private TaxonInformationPK taxonInformationPk;

    /**
     * Get the composite primary key identifier class
     * @return taxonInformationPk
     */
    public TaxonInformationPK getTaxonInformationPk()
    {
        return this.taxonInformationPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param taxonInformationPkIn
     */
    public void setTaxonInformationPk(TaxonInformationPK taxonInformationPkIn) {
        this.taxonInformationPk = taxonInformationPkIn;
    }

    // Generate 2 attributes
    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    private ReferenceDocument referenceDocument;

    /**
     * Les documents de référence sont tous les documents qui peuvent apporter des informations
     * relatives à
     * la classification systématique des taxons (nomenclature, description, synonymie) ou à la
     * définition
     * des groupes de taxons. Ces documents peuvent être des publications officielles (articles de
     * revues
     * ou ouvrage), ou bien des notes de laboratoire, rapports internes, etc.
     * Dans le cas des publications, la référence du document permet de retrouver les sources. En
     * revanche,
     * pour les notes de labo, documents internes, et autres, il faudra préciser dans la référence
     * la
     * localisation de la source (quel service ou quel labo, quelle personne de référence pour se le
     * procurer).
     * Les références des publications doivent respecter les règles d'édition des bibliographies
     * (Auteurs,
     * date. Titre. Editeur...).
     * @return this.referenceDocument ReferenceDocument
     */
    public ReferenceDocument getReferenceDocument()
    {
        return this.referenceDocument;
    }

    /**
     * Les documents de référence sont tous les documents qui peuvent apporter des informations
     * relatives à
     * la classification systématique des taxons (nomenclature, description, synonymie) ou à la
     * définition
     * des groupes de taxons. Ces documents peuvent être des publications officielles (articles de
     * revues
     * ou ouvrage), ou bien des notes de laboratoire, rapports internes, etc.
     * Dans le cas des publications, la référence du document permet de retrouver les sources. En
     * revanche,
     * pour les notes de labo, documents internes, et autres, il faudra préciser dans la référence
     * la
     * localisation de la source (quel service ou quel labo, quelle personne de référence pour se le
     * procurer).
     * Les références des publications doivent respecter les règles d'édition des bibliographies
     * (Auteurs,
     * date. Titre. Editeur...).
     * @param referenceDocumentIn ReferenceDocument
     */
    public void setReferenceDocument(ReferenceDocument referenceDocumentIn)
    {
        this.referenceDocument = referenceDocumentIn;
    }

    private TaxonName taxonName;

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @return this.taxonName TaxonName
     */
    public TaxonName getTaxonName()
    {
        return this.taxonName;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param taxonNameIn TaxonName
     */
    public void setTaxonName(TaxonName taxonNameIn)
    {
        this.taxonName = taxonNameIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link TaxonInformation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link TaxonInformation}.
         * @return new TaxonInformationImpl()
         */
        public static TaxonInformation newInstance()
        {
            return new TaxonInformationImpl();
        }

        /**
         * Constructs a new instance of {@link TaxonInformation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param referenceDocument ReferenceDocument
         * @param taxonName TaxonName
         * @return newInstance
         */
        public static TaxonInformation newInstance(ReferenceDocument referenceDocument, TaxonName taxonName)
        {
            final TaxonInformation entity = new TaxonInformationImpl();
            entity.setReferenceDocument(referenceDocument);
            entity.setTaxonName(taxonName);
            return entity;
        }

        /**
         * Constructs a new instance of {@link TaxonInformation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param description String
         * @param updateDate Timestamp
         * @param referenceDocument ReferenceDocument
         * @param taxonName TaxonName
         * @return newInstance TaxonInformation
         */
        public static TaxonInformation newInstance(String description, Timestamp updateDate, ReferenceDocument referenceDocument, TaxonName taxonName)
        {
            final TaxonInformation entity = new TaxonInformationImpl();
            entity.setDescription(description);
            entity.setUpdateDate(updateDate);
            entity.setReferenceDocument(referenceDocument);
            entity.setTaxonName(taxonName);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(TaxonInformation o)
    {
        int cmp = 0;
        if (this.getTaxonInformationPk() != null)
        {
            cmp = this.getTaxonInformationPk().compareTo(o.getTaxonInformationPk());
        }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// TaxonInformation.java merge-point
}