// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant les
 * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par exemple
 * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
 * trophiques ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
 * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
 * benthiques). Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement
 * appelé groupe de taxons père.
 * Les groupes de taxons sont de deux catégories :
 * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements de
 * taxons sont effectués en aval de la mesure effectuée.
 * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de taxons
 * sur le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
 * lorsque celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
 * s'effectue alors en amont de la mesure.
 * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour toute
 * dans un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
 * jour, et encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit
 * pas être une règle générale)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class TaxonGroup
    implements Serializable, Comparable<TaxonGroup>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -8545358162349439616L;

    // Generate 8 attributes
    private Integer id;

    /**
     * Identifiant unique du groupe de taxons.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique du groupe de taxons.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * Code (ou mnénomique) du groupe de taxons. Ceci peut être un code de quelques caractères
     * identifiant le groupe. (exemple: Ca pour carnivores)
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Code (ou mnénomique) du groupe de taxons. Ceci peut être un code de quelques caractères
     * identifiant le groupe. (exemple: Ca pour carnivores)
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private String name;

    /**
     * Nom du groupe de taxons.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Nom du groupe de taxons.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String comments;

    /**
     * Commentaire long associé au groupe de taxons.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire long associé au groupe de taxons.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Boolean isChildGroupExclusive;

    /**
     * Ce champ permet de renseigner si les groupes de taxons fils sont exclusifs ou pas. Par
     * défaut, les fils ne sont pas exclusifs. S'ils sont exclusifs, un même taxon ne pourra pas
     * faire parti de plusieurs groupes du même taxon père.
     * @return this.isChildGroupExclusive Boolean
     */
    public Boolean isIsChildGroupExclusive()
    {
        return this.isChildGroupExclusive;
    }

    /**
     * Ce champ permet de renseigner si les groupes de taxons fils sont exclusifs ou pas. Par
     * défaut, les fils ne sont pas exclusifs. S'ils sont exclusifs, un même taxon ne pourra pas
     * faire parti de plusieurs groupes du même taxon père.
     * @param isChildGroupExclusiveIn Boolean
     */
    public void setIsChildGroupExclusive(Boolean isChildGroupExclusiveIn)
    {
        this.isChildGroupExclusive = isChildGroupExclusiveIn;
    }

    private Boolean isUpdatable;

    /**
     * Cette information permet de savoir si un groupe de taxons est modifiable ou pas dans
     * l'interface de mise à jour.
     * @return this.isUpdatable Boolean
     */
    public Boolean isIsUpdatable()
    {
        return this.isUpdatable;
    }

    /**
     * Cette information permet de savoir si un groupe de taxons est modifiable ou pas dans
     * l'interface de mise à jour.
     * @param isUpdatableIn Boolean
     */
    public void setIsUpdatable(Boolean isUpdatableIn)
    {
        this.isUpdatable = isUpdatableIn;
    }

    private Date creationDate;

    /**
     * Date de création système du groupe. Renseigné automatiquement par le système.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création système du groupe. Renseigné automatiquement par le système.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour système du groupe. Renseigné automatiquement par le système.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour système du groupe. Renseigné automatiquement par le système.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 21 associations
    private Collection<TaxonGroupInformation> taxonGroupInformations = new HashSet<TaxonGroupInformation>();

    /**
     * 
     * @return this.taxonGroupInformations Collection<TaxonGroupInformation>
     */
    public Collection<TaxonGroupInformation> getTaxonGroupInformations()
    {
        return this.taxonGroupInformations;
    }

    /**
     * 
     * @param taxonGroupInformationsIn Collection<TaxonGroupInformation>
     */
    public void setTaxonGroupInformations(Collection<TaxonGroupInformation> taxonGroupInformationsIn)
    {
        this.taxonGroupInformations = taxonGroupInformationsIn;
    }

    /**
     * 
     * @param elementToAdd TaxonGroupInformation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonGroupInformations(TaxonGroupInformation elementToAdd)
    {
        return this.taxonGroupInformations.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove TaxonGroupInformation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonGroupInformations(TaxonGroupInformation elementToRemove)
    {
        return this.taxonGroupInformations.remove(elementToRemove);
    }

    private TaxonGroup parentTaxonGroup;

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @return this.parentTaxonGroup TaxonGroup
     */
    public TaxonGroup getParentTaxonGroup()
    {
        return this.parentTaxonGroup;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param parentTaxonGroupIn TaxonGroup
     */
    public void setParentTaxonGroup(TaxonGroup parentTaxonGroupIn)
    {
        this.parentTaxonGroup = parentTaxonGroupIn;
    }

    private Collection<TaxonGroup> childTaxonGroups = new HashSet<TaxonGroup>();

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @return this.childTaxonGroups Collection<TaxonGroup>
     */
    public Collection<TaxonGroup> getChildTaxonGroups()
    {
        return this.childTaxonGroups;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param childTaxonGroupsIn Collection<TaxonGroup>
     */
    public void setChildTaxonGroups(Collection<TaxonGroup> childTaxonGroupsIn)
    {
        this.childTaxonGroups = childTaxonGroupsIn;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param elementToAdd TaxonGroup
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addChildTaxonGroups(TaxonGroup elementToAdd)
    {
        return this.childTaxonGroups.add(elementToAdd);
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param elementToRemove TaxonGroup
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeChildTaxonGroups(TaxonGroup elementToRemove)
    {
        return this.childTaxonGroups.remove(elementToRemove);
    }

    private TaxonGroupType taxonGroupType;

    /**
     * Type de groupe de taxon.
     * On distingue plusieurs types de regroupements de taxons :
     * - les groupes descriptifs des taxons, et utilisés à l'extraction des données (groupes
     * écologiques
     * par exemple)
     * - les groupes utilisés pour l'identification sur les navires de pêche ou dans les criées :
     * espèce
     * commerciale, ou espèce communes (nom vernaculaire)
     * -  ...
     * @return this.taxonGroupType TaxonGroupType
     */
    public TaxonGroupType getTaxonGroupType()
    {
        return this.taxonGroupType;
    }

    /**
     * Type de groupe de taxon.
     * On distingue plusieurs types de regroupements de taxons :
     * - les groupes descriptifs des taxons, et utilisés à l'extraction des données (groupes
     * écologiques
     * par exemple)
     * - les groupes utilisés pour l'identification sur les navires de pêche ou dans les criées :
     * espèce
     * commerciale, ou espèce communes (nom vernaculaire)
     * -  ...
     * @param taxonGroupTypeIn TaxonGroupType
     */
    public void setTaxonGroupType(TaxonGroupType taxonGroupTypeIn)
    {
        this.taxonGroupType = taxonGroupTypeIn;
    }

    private Collection<TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords = new HashSet<TaxonGroupHistoricalRecord>();

    /**
     * Date de début d'appartenance du taxon au groupe. Cette date est renseignée automatiquemnt par
     * le
     * système.
     * @return this.taxonGroupHistoricalRecords Collection<TaxonGroupHistoricalRecord>
     */
    public Collection<TaxonGroupHistoricalRecord> getTaxonGroupHistoricalRecords()
    {
        return this.taxonGroupHistoricalRecords;
    }

    /**
     * Date de début d'appartenance du taxon au groupe. Cette date est renseignée automatiquemnt par
     * le
     * système.
     * @param taxonGroupHistoricalRecordsIn Collection<TaxonGroupHistoricalRecord>
     */
    public void setTaxonGroupHistoricalRecords(Collection<TaxonGroupHistoricalRecord> taxonGroupHistoricalRecordsIn)
    {
        this.taxonGroupHistoricalRecords = taxonGroupHistoricalRecordsIn;
    }

    /**
     * Date de début d'appartenance du taxon au groupe. Cette date est renseignée automatiquemnt par
     * le
     * système.
     * @param elementToAdd TaxonGroupHistoricalRecord
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonGroupHistoricalRecords(TaxonGroupHistoricalRecord elementToAdd)
    {
        return this.taxonGroupHistoricalRecords.add(elementToAdd);
    }

    /**
     * Date de début d'appartenance du taxon au groupe. Cette date est renseignée automatiquemnt par
     * le
     * système.
     * @param elementToRemove TaxonGroupHistoricalRecord
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonGroupHistoricalRecords(TaxonGroupHistoricalRecord elementToRemove)
    {
        return this.taxonGroupHistoricalRecords.remove(elementToRemove);
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an TaxonGroup instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonGroup))
        {
            return false;
        }
        final TaxonGroup that = (TaxonGroup)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link TaxonGroup}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link TaxonGroup}.
         * @return new TaxonGroupImpl()
         */
        public static TaxonGroup newInstance()
        {
            return new TaxonGroupImpl();
        }

        /**
         * Constructs a new instance of {@link TaxonGroup}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param isChildGroupExclusive Boolean
         * @param isUpdatable Boolean
         * @param creationDate Date
         * @param taxonGroupType TaxonGroupType
         * @param status Status
         * @return newInstance
         */
        public static TaxonGroup newInstance(String name, Boolean isChildGroupExclusive, Boolean isUpdatable, Date creationDate, TaxonGroupType taxonGroupType, Status status)
        {
            final TaxonGroup entity = new TaxonGroupImpl();
            entity.setName(name);
            entity.setIsChildGroupExclusive(isChildGroupExclusive);
            entity.setIsUpdatable(isUpdatable);
            entity.setCreationDate(creationDate);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link TaxonGroup}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param name String
         * @param comments String
         * @param isChildGroupExclusive Boolean
         * @param isUpdatable Boolean
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param taxonGroupInformations Collection<TaxonGroupInformation>
         * @param parentTaxonGroup TaxonGroup
         * @param childTaxonGroups Collection<TaxonGroup>
         * @param taxonGroupType TaxonGroupType
         * @param taxonGroupHistoricalRecords Collection<TaxonGroupHistoricalRecord>
         * @param status Status
         * @return newInstance TaxonGroup
         */
        public static TaxonGroup newInstance(String label, String name, String comments, Boolean isChildGroupExclusive, Boolean isUpdatable, Date creationDate, Timestamp updateDate, Collection<TaxonGroupInformation> taxonGroupInformations, TaxonGroup parentTaxonGroup, Collection<TaxonGroup> childTaxonGroups, TaxonGroupType taxonGroupType, Collection<TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords, Status status)
        {
            final TaxonGroup entity = new TaxonGroupImpl();
            entity.setLabel(label);
            entity.setName(name);
            entity.setComments(comments);
            entity.setIsChildGroupExclusive(isChildGroupExclusive);
            entity.setIsUpdatable(isUpdatable);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setTaxonGroupInformations(taxonGroupInformations);
            entity.setParentTaxonGroup(parentTaxonGroup);
            entity.setChildTaxonGroups(childTaxonGroups);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setTaxonGroupHistoricalRecords(taxonGroupHistoricalRecords);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(TaxonGroup o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.isIsChildGroupExclusive() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsChildGroupExclusive().compareTo(o.isIsChildGroupExclusive()));
            }
            if (this.isIsUpdatable() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsUpdatable().compareTo(o.isIsUpdatable()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// TaxonGroup.java merge-point
}