// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Les documents de référence sont tous les documents qui peuvent apporter des informations
 * relatives à la classification systématique des taxons (nomenclature, description, synonymie) ou à
 * la définition des groupes de taxons. Ces documents peuvent être des publications officielles
 * (articles de revues ou ouvrage), ou bien des notes de laboratoire, rapports internes, etc.
 * Dans le cas des publications, la référence du document permet de retrouver les sources. En
 * revanche, pour les notes de labo, documents internes, et autres, il faudra préciser dans la
 * référence la localisation de la source (quel service ou quel labo, quelle personne de référence
 * pour se le procurer).
 * Les références des publications doivent respecter les règles d'édition des bibliographies
 * (Auteurs, date. Titre. Editeur...).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class ReferenceDocument
    implements Serializable, Comparable<ReferenceDocument>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -1529010323374173007L;

    // Generate 6 attributes
    private Integer id;

    /**
     * Identifiant unique du document. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique du document. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String reference;

    /**
     * Libellé stockant la référence du document. Ceci peut être le nom, l'édition etc.
     * @return this.reference String
     */
    public String getReference()
    {
        return this.reference;
    }

    /**
     * Libellé stockant la référence du document. Ceci peut être le nom, l'édition etc.
     * @param referenceIn String
     */
    public void setReference(String referenceIn)
    {
        this.reference = referenceIn;
    }

    private Date publicationDate;

    /**
     * Date de parution du document.
     * @return this.publicationDate Date
     */
    public Date getPublicationDate()
    {
        return this.publicationDate;
    }

    /**
     * Date de parution du document.
     * @param publicationDateIn Date
     */
    public void setPublicationDate(Date publicationDateIn)
    {
        this.publicationDate = publicationDateIn;
    }

    private String comments;

    /**
     * Commentaires divers associés au document de référence.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaires divers associés au document de référence.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création système du document de référence. Renseigné automatiquement par le système.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création système du document de référence. Renseigné automatiquement par le système.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour système de la référence. Renseigné automatiquement par le système.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour système de la référence. Renseigné automatiquement par le système.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 5 associations
    private Collection<Author> authors = new HashSet<Author>();

    /**
     * Sont considérés comme auteurs les scientifiques qui sont à l'origine de la description (et
     * par là
     * même de la nomenclature et de la position systématique) des taxons, quel que soit leur niveau
     * (famille, genre, espèce ...).
     * @return this.authors Collection<Author>
     */
    public Collection<Author> getAuthors()
    {
        return this.authors;
    }

    /**
     * Sont considérés comme auteurs les scientifiques qui sont à l'origine de la description (et
     * par là
     * même de la nomenclature et de la position systématique) des taxons, quel que soit leur niveau
     * (famille, genre, espèce ...).
     * @param authorsIn Collection<Author>
     */
    public void setAuthors(Collection<Author> authorsIn)
    {
        this.authors = authorsIn;
    }

    /**
     * Sont considérés comme auteurs les scientifiques qui sont à l'origine de la description (et
     * par là
     * même de la nomenclature et de la position systématique) des taxons, quel que soit leur niveau
     * (famille, genre, espèce ...).
     * @param elementToAdd Author
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addAuthors(Author elementToAdd)
    {
        return this.authors.add(elementToAdd);
    }

    /**
     * Sont considérés comme auteurs les scientifiques qui sont à l'origine de la description (et
     * par là
     * même de la nomenclature et de la position systématique) des taxons, quel que soit leur niveau
     * (famille, genre, espèce ...).
     * @param elementToRemove Author
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeAuthors(Author elementToRemove)
    {
        return this.authors.remove(elementToRemove);
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    private Collection<TaxonInformationHistory> taxonInformationHistories = new HashSet<TaxonInformationHistory>();

    /**
     * 
     * @return this.taxonInformationHistories Collection<TaxonInformationHistory>
     */
    public Collection<TaxonInformationHistory> getTaxonInformationHistories()
    {
        return this.taxonInformationHistories;
    }

    /**
     * 
     * @param taxonInformationHistoriesIn Collection<TaxonInformationHistory>
     */
    public void setTaxonInformationHistories(Collection<TaxonInformationHistory> taxonInformationHistoriesIn)
    {
        this.taxonInformationHistories = taxonInformationHistoriesIn;
    }

    /**
     * 
     * @param elementToAdd TaxonInformationHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonInformationHistories(TaxonInformationHistory elementToAdd)
    {
        return this.taxonInformationHistories.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove TaxonInformationHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonInformationHistories(TaxonInformationHistory elementToRemove)
    {
        return this.taxonInformationHistories.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an ReferenceDocument instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof ReferenceDocument))
        {
            return false;
        }
        final ReferenceDocument that = (ReferenceDocument)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link ReferenceDocument}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link ReferenceDocument}.
         * @return new ReferenceDocumentImpl()
         */
        public static ReferenceDocument newInstance()
        {
            return new ReferenceDocumentImpl();
        }

        /**
         * Constructs a new instance of {@link ReferenceDocument}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param reference String
         * @param creationDate Date
         * @param authors Collection<Author>
         * @param status Status
         * @return newInstance
         */
        public static ReferenceDocument newInstance(String reference, Date creationDate, Collection<Author> authors, Status status)
        {
            final ReferenceDocument entity = new ReferenceDocumentImpl();
            entity.setReference(reference);
            entity.setCreationDate(creationDate);
            entity.setAuthors(authors);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link ReferenceDocument}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param reference String
         * @param publicationDate Date
         * @param comments String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param authors Collection<Author>
         * @param status Status
         * @param taxonInformationHistories Collection<TaxonInformationHistory>
         * @return newInstance ReferenceDocument
         */
        public static ReferenceDocument newInstance(String reference, Date publicationDate, String comments, Date creationDate, Timestamp updateDate, Collection<Author> authors, Status status, Collection<TaxonInformationHistory> taxonInformationHistories)
        {
            final ReferenceDocument entity = new ReferenceDocumentImpl();
            entity.setReference(reference);
            entity.setPublicationDate(publicationDate);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setAuthors(authors);
            entity.setStatus(status);
            entity.setTaxonInformationHistories(taxonInformationHistories);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(ReferenceDocument o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReference().compareTo(o.getReference()));
            }
            if (this.getPublicationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPublicationDate().compareTo(o.getPublicationDate()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// ReferenceDocument.java merge-point
}