// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.spatial;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Type de régionalisation d'une liste du réfétentiel.
 * Il peut y avoir plusieurs type de régionalisation pour une meme liste (pour un meme
 * OBJECT_TYPE_FK).
 * Par exemple :
 * - régionalisation des gradients de profondeur (utile pour les Antilles)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class SpatialItemType
    implements Serializable, Comparable<SpatialItemType>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -6066057939285156925L;

    // Generate 5 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private String label;

    /**
     * 
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * 
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    // Generate 3 associations
    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    private Collection<SpatialItem> spatialItems = new HashSet<SpatialItem>();

    /**
     * Présence d'un élément d'une liste du référentiel sur une ou plusieurs zones géographiques.
     * Une ou plusieurs géométrie (ponctuelle, linéraire ou polygonale) peuvent etre définies afin
     * de
     * géolocaliser un des éléments d'une liste.
     * Une procédure stockée sous Oracle permet la mise à jour d'un lien vers le référentiel des
     * lieux
     * (table SPATIAL_ITEM2LOCATION) à partir des géométries définies.
     * @return this.spatialItems Collection<SpatialItem>
     */
    public Collection<SpatialItem> getSpatialItems()
    {
        return this.spatialItems;
    }

    /**
     * Présence d'un élément d'une liste du référentiel sur une ou plusieurs zones géographiques.
     * Une ou plusieurs géométrie (ponctuelle, linéraire ou polygonale) peuvent etre définies afin
     * de
     * géolocaliser un des éléments d'une liste.
     * Une procédure stockée sous Oracle permet la mise à jour d'un lien vers le référentiel des
     * lieux
     * (table SPATIAL_ITEM2LOCATION) à partir des géométries définies.
     * @param spatialItemsIn Collection<SpatialItem>
     */
    public void setSpatialItems(Collection<SpatialItem> spatialItemsIn)
    {
        this.spatialItems = spatialItemsIn;
    }

    /**
     * Présence d'un élément d'une liste du référentiel sur une ou plusieurs zones géographiques.
     * Une ou plusieurs géométrie (ponctuelle, linéraire ou polygonale) peuvent etre définies afin
     * de
     * géolocaliser un des éléments d'une liste.
     * Une procédure stockée sous Oracle permet la mise à jour d'un lien vers le référentiel des
     * lieux
     * (table SPATIAL_ITEM2LOCATION) à partir des géométries définies.
     * @param elementToAdd SpatialItem
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSpatialItems(SpatialItem elementToAdd)
    {
        return this.spatialItems.add(elementToAdd);
    }

    /**
     * Présence d'un élément d'une liste du référentiel sur une ou plusieurs zones géographiques.
     * Une ou plusieurs géométrie (ponctuelle, linéraire ou polygonale) peuvent etre définies afin
     * de
     * géolocaliser un des éléments d'une liste.
     * Une procédure stockée sous Oracle permet la mise à jour d'un lien vers le référentiel des
     * lieux
     * (table SPATIAL_ITEM2LOCATION) à partir des géométries définies.
     * @param elementToRemove SpatialItem
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSpatialItems(SpatialItem elementToRemove)
    {
        return this.spatialItems.remove(elementToRemove);
    }

    private ObjectType objectType;

    /**
     * Liste des types d'objets qui peuvent etre associés à la photo ou à un fichier attaché. Cette
     * liste
     * ne peut pas etre modifiée par l'utilisateur.
     * généralement, il s'agit des noms des tables (en majuscule + underscore)
     * @return this.objectType ObjectType
     */
    public ObjectType getObjectType()
    {
        return this.objectType;
    }

    /**
     * Liste des types d'objets qui peuvent etre associés à la photo ou à un fichier attaché. Cette
     * liste
     * ne peut pas etre modifiée par l'utilisateur.
     * généralement, il s'agit des noms des tables (en majuscule + underscore)
     * @param objectTypeIn ObjectType
     */
    public void setObjectType(ObjectType objectTypeIn)
    {
        this.objectType = objectTypeIn;
    }

    /**
     * Returns <code>true</code> if the argument is an SpatialItemType instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof SpatialItemType))
        {
            return false;
        }
        final SpatialItemType that = (SpatialItemType)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link SpatialItemType}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link SpatialItemType}.
         * @return new SpatialItemTypeImpl()
         */
        public static SpatialItemType newInstance()
        {
            return new SpatialItemTypeImpl();
        }

        /**
         * Constructs a new instance of {@link SpatialItemType}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param label String
         * @param status Status
         * @param objectType ObjectType
         * @return newInstance
         */
        public static SpatialItemType newInstance(String name, String label, Status status, ObjectType objectType)
        {
            final SpatialItemType entity = new SpatialItemTypeImpl();
            entity.setName(name);
            entity.setLabel(label);
            entity.setStatus(status);
            entity.setObjectType(objectType);
            return entity;
        }

        /**
         * Constructs a new instance of {@link SpatialItemType}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param updateDate Timestamp
         * @param label String
         * @param status Status
         * @param spatialItems Collection<SpatialItem>
         * @param objectType ObjectType
         * @return newInstance SpatialItemType
         */
        public static SpatialItemType newInstance(String name, String description, Timestamp updateDate, String label, Status status, Collection<SpatialItem> spatialItems, ObjectType objectType)
        {
            final SpatialItemType entity = new SpatialItemTypeImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setUpdateDate(updateDate);
            entity.setLabel(label);
            entity.setStatus(status);
            entity.setSpatialItems(spatialItems);
            entity.setObjectType(objectType);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(SpatialItemType o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// SpatialItemType.java merge-point
}