// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.samplingScheme.denormalized;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Denormalisation des ligne du plan d'échantillonnage. Pour utilisation dans Allegro (table
 * synchronisée - cf mantis #12901).
 * Calculé à partir de SamplingStrata, SamplingScheme, Grouping, etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class DenormalizedSamplingStrata
    implements Serializable, Comparable<DenormalizedSamplingStrata>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 132419748282316274L;

    // Generate 18 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * 
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * 
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private Date startDate;

    /**
     * Date de début de validité de la ligne du plan.
     * Pour savoir si la ligne affectable à une marée ou une vente (suivant la date de début), avec
     * une précision au mois/annee et non au jour.
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * Date de début de validité de la ligne du plan.
     * Pour savoir si la ligne affectable à une marée ou une vente (suivant la date de début), avec
     * une précision au mois/annee et non au jour.
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * Date de fin de validité
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * Date de fin de validité
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private String observationLocationComments;

    /**
     * 
     * @return this.observationLocationComments String
     */
    public String getObservationLocationComments()
    {
        return this.observationLocationComments;
    }

    /**
     * 
     * @param observationLocationCommentsIn String
     */
    public void setObservationLocationComments(String observationLocationCommentsIn)
    {
        this.observationLocationComments = observationLocationCommentsIn;
    }

    private String samplingStrategy;

    /**
     * 
     * @return this.samplingStrategy String
     */
    public String getSamplingStrategy()
    {
        return this.samplingStrategy;
    }

    /**
     * 
     * @param samplingStrategyIn String
     */
    public void setSamplingStrategy(String samplingStrategyIn)
    {
        this.samplingStrategy = samplingStrategyIn;
    }

    private String taxonGroupName;

    /**
     * 
     * @return this.taxonGroupName String
     */
    public String getTaxonGroupName()
    {
        return this.taxonGroupName;
    }

    /**
     * 
     * @param taxonGroupNameIn String
     */
    public void setTaxonGroupName(String taxonGroupNameIn)
    {
        this.taxonGroupName = taxonGroupNameIn;
    }

    private String samplingSchemeLabel;

    /**
     * 
     * @return this.samplingSchemeLabel String
     */
    public String getSamplingSchemeLabel()
    {
        return this.samplingSchemeLabel;
    }

    /**
     * 
     * @param samplingSchemeLabelIn String
     */
    public void setSamplingSchemeLabel(String samplingSchemeLabelIn)
    {
        this.samplingSchemeLabel = samplingSchemeLabelIn;
    }

    private String samplingSchemeName;

    /**
     * 
     * @return this.samplingSchemeName String
     */
    public String getSamplingSchemeName()
    {
        return this.samplingSchemeName;
    }

    /**
     * 
     * @param samplingSchemeNameIn String
     */
    public void setSamplingSchemeName(String samplingSchemeNameIn)
    {
        this.samplingSchemeName = samplingSchemeNameIn;
    }

    private String samplingSchemeDescription;

    /**
     * 
     * @return this.samplingSchemeDescription String
     */
    public String getSamplingSchemeDescription()
    {
        return this.samplingSchemeDescription;
    }

    /**
     * 
     * @param samplingSchemeDescriptionIn String
     */
    public void setSamplingSchemeDescription(String samplingSchemeDescriptionIn)
    {
        this.samplingSchemeDescription = samplingSchemeDescriptionIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private String gearMeshRange;

    /**
     * Calculer à partir de grouping
     * @return this.gearMeshRange String
     */
    public String getGearMeshRange()
    {
        return this.gearMeshRange;
    }

    /**
     * Calculer à partir de grouping
     * @param gearMeshRangeIn String
     */
    public void setGearMeshRange(String gearMeshRangeIn)
    {
        this.gearMeshRange = gearMeshRangeIn;
    }

    private String vesselLengthRange;

    /**
     * Calculer à partir de grouping
     * @return this.vesselLengthRange String
     */
    public String getVesselLengthRange()
    {
        return this.vesselLengthRange;
    }

    /**
     * Calculer à partir de grouping
     * @param vesselLengthRangeIn String
     */
    public void setVesselLengthRange(String vesselLengthRangeIn)
    {
        this.vesselLengthRange = vesselLengthRangeIn;
    }

    private String metier;

    /**
     * Calculer à partir de grouping
     * @return this.metier String
     */
    public String getMetier()
    {
        return this.metier;
    }

    /**
     * Calculer à partir de grouping
     * @param metierIn String
     */
    public void setMetier(String metierIn)
    {
        this.metier = metierIn;
    }

    private String areaName;

    /**
     * Calculer à partir de grouping
     * @return this.areaName String
     */
    public String getAreaName()
    {
        return this.areaName;
    }

    /**
     * Calculer à partir de grouping
     * @param areaNameIn String
     */
    public void setAreaName(String areaNameIn)
    {
        this.areaName = areaNameIn;
    }

    private String subAreaLocationIds;

    /**
     * Calculer à partir de grouping, et grouping_item, puis les "locations" liés
     * @return this.subAreaLocationIds String
     */
    public String getSubAreaLocationIds()
    {
        return this.subAreaLocationIds;
    }

    /**
     * Calculer à partir de grouping, et grouping_item, puis les "locations" liés
     * @param subAreaLocationIdsIn String
     */
    public void setSubAreaLocationIds(String subAreaLocationIdsIn)
    {
        this.subAreaLocationIds = subAreaLocationIdsIn;
    }

    // Generate 6 associations
    private Person person;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.person Person
     */
    public Person getPerson()
    {
        return this.person;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param personIn Person
     */
    public void setPerson(Person personIn)
    {
        this.person = personIn;
    }

    private Location observationLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.observationLocation Location
     */
    public Location getObservationLocation()
    {
        return this.observationLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param observationLocationIn Location
     */
    public void setObservationLocation(Location observationLocationIn)
    {
        this.observationLocation = observationLocationIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Department department;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.department Department
     */
    public Department getDepartment()
    {
        return this.department;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param departmentIn Department
     */
    public void setDepartment(Department departmentIn)
    {
        this.department = departmentIn;
    }

    /**
     * Returns <code>true</code> if the argument is an DenormalizedSamplingStrata instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof DenormalizedSamplingStrata))
        {
            return false;
        }
        final DenormalizedSamplingStrata that = (DenormalizedSamplingStrata)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link DenormalizedSamplingStrata}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link DenormalizedSamplingStrata}.
         * @return new DenormalizedSamplingStrataImpl()
         */
        public static DenormalizedSamplingStrata newInstance()
        {
            return new DenormalizedSamplingStrataImpl();
        }

        /**
         * Constructs a new instance of {@link DenormalizedSamplingStrata}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param label String
         * @param samplingSchemeLabel String
         * @param samplingSchemeName String
         * @param program Program
         * @return newInstance
         */
        public static DenormalizedSamplingStrata newInstance(String label, String samplingSchemeLabel, String samplingSchemeName, Program program)
        {
            final DenormalizedSamplingStrata entity = new DenormalizedSamplingStrataImpl();
            entity.setLabel(label);
            entity.setSamplingSchemeLabel(samplingSchemeLabel);
            entity.setSamplingSchemeName(samplingSchemeName);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link DenormalizedSamplingStrata}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param startDate Date
         * @param endDate Date
         * @param description String
         * @param comments String
         * @param observationLocationComments String
         * @param samplingStrategy String
         * @param taxonGroupName String
         * @param samplingSchemeLabel String
         * @param samplingSchemeName String
         * @param samplingSchemeDescription String
         * @param updateDate Timestamp
         * @param gearMeshRange String
         * @param vesselLengthRange String
         * @param metier String
         * @param areaName String
         * @param subAreaLocationIds String
         * @param person Person
         * @param observationLocation Location
         * @param program Program
         * @param department Department
         * @return newInstance DenormalizedSamplingStrata
         */
        public static DenormalizedSamplingStrata newInstance(String label, Date startDate, Date endDate, String description, String comments, String observationLocationComments, String samplingStrategy, String taxonGroupName, String samplingSchemeLabel, String samplingSchemeName, String samplingSchemeDescription, Timestamp updateDate, String gearMeshRange, String vesselLengthRange, String metier, String areaName, String subAreaLocationIds, Person person, Location observationLocation, Program program, Department department)
        {
            final DenormalizedSamplingStrata entity = new DenormalizedSamplingStrataImpl();
            entity.setLabel(label);
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setDescription(description);
            entity.setComments(comments);
            entity.setObservationLocationComments(observationLocationComments);
            entity.setSamplingStrategy(samplingStrategy);
            entity.setTaxonGroupName(taxonGroupName);
            entity.setSamplingSchemeLabel(samplingSchemeLabel);
            entity.setSamplingSchemeName(samplingSchemeName);
            entity.setSamplingSchemeDescription(samplingSchemeDescription);
            entity.setUpdateDate(updateDate);
            entity.setGearMeshRange(gearMeshRange);
            entity.setVesselLengthRange(vesselLengthRange);
            entity.setMetier(metier);
            entity.setAreaName(areaName);
            entity.setSubAreaLocationIds(subAreaLocationIds);
            entity.setPerson(person);
            entity.setObservationLocation(observationLocation);
            entity.setProgram(program);
            entity.setDepartment(department);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(DenormalizedSamplingStrata o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getObservationLocationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getObservationLocationComments().compareTo(o.getObservationLocationComments()));
            }
            if (this.getSamplingStrategy() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingStrategy().compareTo(o.getSamplingStrategy()));
            }
            if (this.getTaxonGroupName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getTaxonGroupName().compareTo(o.getTaxonGroupName()));
            }
            if (this.getSamplingSchemeLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingSchemeLabel().compareTo(o.getSamplingSchemeLabel()));
            }
            if (this.getSamplingSchemeName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingSchemeName().compareTo(o.getSamplingSchemeName()));
            }
            if (this.getSamplingSchemeDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingSchemeDescription().compareTo(o.getSamplingSchemeDescription()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getGearMeshRange() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getGearMeshRange().compareTo(o.getGearMeshRange()));
            }
            if (this.getVesselLengthRange() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getVesselLengthRange().compareTo(o.getVesselLengthRange()));
            }
            if (this.getMetier() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getMetier().compareTo(o.getMetier()));
            }
            if (this.getAreaName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getAreaName().compareTo(o.getAreaName()));
            }
            if (this.getSubAreaLocationIds() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSubAreaLocationIds().compareTo(o.getSubAreaLocationIds()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// DenormalizedSamplingStrata.java merge-point
}