// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.sale;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Application des catégories commerciales. Permet la régionalisation, par date et lieu, des
 * catégories commerciales (et calibrage) par espèce commerciale.
 * Une catégorie comemrciale est appliquée à une espèce comemrciale et une lieu d'application
 * (terrestre), sur une période.
 * @since 3.5.0
 */
// HibernateEntity.vsl annotations merge-point
public abstract class AppliedSizeCategory
    implements Serializable, Comparable<AppliedSizeCategory>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7464552165959501585L;

    // Generate 6 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDate;

    /**
     * Date de début de validité de l'équivalent poids vif
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * Date de début de validité de l'équivalent poids vif
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * Date de fin de validité de l'équivalent poids vif.
     * Si vide : toujours actif.
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * Date de fin de validité de l'équivalent poids vif.
     * Si vide : toujours actif.
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private String description;

    /**
     * Peut stocker le calibrage associé (exemple : "250g à 500g")
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Peut stocker le calibrage associé (exemple : "250g à 500g")
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private QualitativeValue sizeCategory;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.sizeCategory QualitativeValue
     */
    public QualitativeValue getSizeCategory()
    {
        return this.sizeCategory;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param sizeCategoryIn QualitativeValue
     */
    public void setSizeCategory(QualitativeValue sizeCategoryIn)
    {
        this.sizeCategory = sizeCategoryIn;
    }

    private Location location;

    /**
     * Lieu (terrestre) ou a lieu de débarquement
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Lieu (terrestre) ou a lieu de débarquement
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private QualitativeValue dressing;

    /**
     * Présentation de l'espèce (Obligatoire mais par défaut = "Entier").
     * Uniquement nécessaire pour des cas particuliers comme la Langoustine (vendu entière ou en
     * queue).
     * @return this.dressing QualitativeValue
     */
    public QualitativeValue getDressing()
    {
        return this.dressing;
    }

    /**
     * Présentation de l'espèce (Obligatoire mais par défaut = "Entier").
     * Uniquement nécessaire pour des cas particuliers comme la Langoustine (vendu entière ou en
     * queue).
     * @param dressingIn QualitativeValue
     */
    public void setDressing(QualitativeValue dressingIn)
    {
        this.dressing = dressingIn;
    }

    private TaxonGroup taxonGroup;

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @return this.taxonGroup TaxonGroup
     */
    public TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param taxonGroupIn TaxonGroup
     */
    public void setTaxonGroup(TaxonGroup taxonGroupIn)
    {
        this.taxonGroup = taxonGroupIn;
    }

    /**
     * Returns <code>true</code> if the argument is an AppliedSizeCategory instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof AppliedSizeCategory))
        {
            return false;
        }
        final AppliedSizeCategory that = (AppliedSizeCategory)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link AppliedSizeCategory}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link AppliedSizeCategory}.
         * @return new AppliedSizeCategoryImpl()
         */
        public static AppliedSizeCategory newInstance()
        {
            return new AppliedSizeCategoryImpl();
        }

        /**
         * Constructs a new instance of {@link AppliedSizeCategory}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDate Date
         * @param sizeCategory QualitativeValue
         * @param location Location
         * @param dressing QualitativeValue
         * @param taxonGroup TaxonGroup
         * @return newInstance
         */
        public static AppliedSizeCategory newInstance(Date startDate, QualitativeValue sizeCategory, Location location, QualitativeValue dressing, TaxonGroup taxonGroup)
        {
            final AppliedSizeCategory entity = new AppliedSizeCategoryImpl();
            entity.setStartDate(startDate);
            entity.setSizeCategory(sizeCategory);
            entity.setLocation(location);
            entity.setDressing(dressing);
            entity.setTaxonGroup(taxonGroup);
            return entity;
        }

        /**
         * Constructs a new instance of {@link AppliedSizeCategory}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param description String
         * @param comments String
         * @param updateDate Timestamp
         * @param sizeCategory QualitativeValue
         * @param location Location
         * @param dressing QualitativeValue
         * @param taxonGroup TaxonGroup
         * @return newInstance AppliedSizeCategory
         */
        public static AppliedSizeCategory newInstance(Date startDate, Date endDate, String description, String comments, Timestamp updateDate, QualitativeValue sizeCategory, Location location, QualitativeValue dressing, TaxonGroup taxonGroup)
        {
            final AppliedSizeCategory entity = new AppliedSizeCategoryImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setDescription(description);
            entity.setComments(comments);
            entity.setUpdateDate(updateDate);
            entity.setSizeCategory(sizeCategory);
            entity.setLocation(location);
            entity.setDressing(dressing);
            entity.setTaxonGroup(taxonGroup);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(AppliedSizeCategory o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// AppliedSizeCategory.java merge-point
}