// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Un paramètre est une propriété du milieu ou d'un élément du milieu qui contribue à en apprécier
 * les caractéristiques et/ou la qualité et/ou l'aptitude à des usages.
 * Le paramètre se décline en trois types : quantitatif, qualitatif ou libre.
 * Le type quantitatif se rapporte aux paramètres qui ont une infinité de résultats numériques.
 * Le type qualitatif se rapporte aux paramètres qui ne prennent qu'un nombre limité de valeurs
 * prédéfinies pour chacun d'eux.
 * Le type libre, ou alphanumérique, correspond aux paramètres de valeurs alphanumériques, sans
 * limite de valeurs possibles (hormis la longueur de la chaine : 40 max).
 * Ces trois types sont mutuellement exclusifs.
 * Exemple de paramètre :
 * • Taille (numérique)
 * • Age (numérique)
 * • Sexe (qualitatif)
 * • Catégorie commerciale (qualitatif)
 * • Présentation commerciale (qualitatif)
 * • Vrac / Hors Vrac (qualitatif)
 * • Rejet / Débarquement (qualitatif) (Discard/Landing)
 * • Stade de maturité (qualitatif) (Maturity stage)
 * • Numéro de contrat (libre - alphanumérique)
 * Cette liste n’est pas exhaustive.
 * Nombre de lignes : 130
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Parameter
    implements Serializable, Comparable<Parameter>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 8577752029076465050L;

    // Generate 9 attributes
    private String code;

    /**
     * Code du paramètre
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * Code du paramètre
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private String name;

    /**
     * Libellé du paramètre
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé du paramètre
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * Description du paramètre
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Description du paramètre
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Boolean isQualitative;

    /**
     * Indique si pour le paramètre on saisit des valeurs numérique ou si on choisit dans une liste
     * de valeurs qualitatives
     * @return this.isQualitative Boolean
     */
    public Boolean isIsQualitative()
    {
        return this.isQualitative;
    }

    /**
     * Indique si pour le paramètre on saisit des valeurs numérique ou si on choisit dans une liste
     * de valeurs qualitatives
     * @param isQualitativeIn Boolean
     */
    public void setIsQualitative(Boolean isQualitativeIn)
    {
        this.isQualitative = isQualitativeIn;
    }

    private Boolean isTaxinomic;

    /**
     * Indique si le paramètre est utilisé pour des mesures de dénombrement
     * @return this.isTaxinomic Boolean
     */
    public Boolean isIsTaxinomic()
    {
        return this.isTaxinomic;
    }

    /**
     * Indique si le paramètre est utilisé pour des mesures de dénombrement
     * @param isTaxinomicIn Boolean
     */
    public void setIsTaxinomic(Boolean isTaxinomicIn)
    {
        this.isTaxinomic = isTaxinomicIn;
    }

    private Boolean isCalculated;

    /**
     * Indique si le paramètre est calculé
     * @return this.isCalculated Boolean
     */
    public Boolean isIsCalculated()
    {
        return this.isCalculated;
    }

    /**
     * Indique si le paramètre est calculé
     * @param isCalculatedIn Boolean
     */
    public void setIsCalculated(Boolean isCalculatedIn)
    {
        this.isCalculated = isCalculatedIn;
    }

    private Boolean isAlphanumeric = Boolean.valueOf(false);

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Indique si pour le paramètre on saisit des valeurs alphanumérique
     * (=Vrai) ou si on choisit dans une liste de valeurs qualitatives ou si
     * les valeurs sont numérique (=Faux - cf <i>isQualitative</i>)
     * </p>
     * </body>
     * </html>
     * @return this.isAlphanumeric Boolean
     */
    public Boolean isIsAlphanumeric()
    {
        return this.isAlphanumeric;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Indique si pour le paramètre on saisit des valeurs alphanumérique
     * (=Vrai) ou si on choisit dans une liste de valeurs qualitatives ou si
     * les valeurs sont numérique (=Faux - cf <i>isQualitative</i>)
     * </p>
     * </body>
     * </html>
     * @param isAlphanumericIn Boolean
     */
    public void setIsAlphanumeric(Boolean isAlphanumericIn)
    {
        this.isAlphanumeric = isAlphanumericIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 6 associations
    private ParameterGroup parameterGroup;

    /**
     * Groupe de paramètres.
     * Les groupes permettent le regroupement et la hiérarchisation des paramètres, par thématiques.
     * Par
     * exemple, on aura :
     * - Halieutique
     * |- Individu (paramètres : taille, sexe, ..)
     * |- Engin (paramètres : longueur de bras, ...)
     * |- Condition d'observation (paramètres : état de la mer...)
     * @return this.parameterGroup ParameterGroup
     */
    public ParameterGroup getParameterGroup()
    {
        return this.parameterGroup;
    }

    /**
     * Groupe de paramètres.
     * Les groupes permettent le regroupement et la hiérarchisation des paramètres, par thématiques.
     * Par
     * exemple, on aura :
     * - Halieutique
     * |- Individu (paramètres : taille, sexe, ..)
     * |- Engin (paramètres : longueur de bras, ...)
     * |- Condition d'observation (paramètres : état de la mer...)
     * @param parameterGroupIn ParameterGroup
     */
    public void setParameterGroup(ParameterGroup parameterGroupIn)
    {
        this.parameterGroup = parameterGroupIn;
    }

    private Status status;

    /**
     * état de l'objet (actif ou inactif)
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * état de l'objet (actif ou inactif)
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    private Collection<QualitativeValue> qualitativeValues = new HashSet<QualitativeValue>();

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.qualitativeValues Collection<QualitativeValue>
     */
    public Collection<QualitativeValue> getQualitativeValues()
    {
        return this.qualitativeValues;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param qualitativeValuesIn Collection<QualitativeValue>
     */
    public void setQualitativeValues(Collection<QualitativeValue> qualitativeValuesIn)
    {
        this.qualitativeValues = qualitativeValuesIn;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param elementToAdd QualitativeValue
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addQualitativeValues(QualitativeValue elementToAdd)
    {
        return this.qualitativeValues.add(elementToAdd);
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param elementToRemove QualitativeValue
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeQualitativeValues(QualitativeValue elementToRemove)
    {
        return this.qualitativeValues.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Parameter instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Parameter))
        {
            return false;
        }
        final Parameter that = (Parameter)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Parameter}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Parameter}.
         * @return new ParameterImpl()
         */
        public static Parameter newInstance()
        {
            return new ParameterImpl();
        }

        /**
         * Constructs a new instance of {@link Parameter}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param isQualitative Boolean
         * @param isTaxinomic Boolean
         * @param isCalculated Boolean
         * @param isAlphanumeric Boolean
         * @param creationDate Date
         * @param parameterGroup ParameterGroup
         * @param status Status
         * @return newInstance
         */
        public static Parameter newInstance(String name, Boolean isQualitative, Boolean isTaxinomic, Boolean isCalculated, Boolean isAlphanumeric, Date creationDate, ParameterGroup parameterGroup, Status status)
        {
            final Parameter entity = new ParameterImpl();
            entity.setName(name);
            entity.setIsQualitative(isQualitative);
            entity.setIsTaxinomic(isTaxinomic);
            entity.setIsCalculated(isCalculated);
            entity.setIsAlphanumeric(isAlphanumeric);
            entity.setCreationDate(creationDate);
            entity.setParameterGroup(parameterGroup);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Parameter}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param isQualitative Boolean
         * @param isTaxinomic Boolean
         * @param isCalculated Boolean
         * @param isAlphanumeric Boolean
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param parameterGroup ParameterGroup
         * @param status Status
         * @param qualitativeValues Collection<QualitativeValue>
         * @return newInstance Parameter
         */
        public static Parameter newInstance(String name, String description, Boolean isQualitative, Boolean isTaxinomic, Boolean isCalculated, Boolean isAlphanumeric, Date creationDate, Timestamp updateDate, ParameterGroup parameterGroup, Status status, Collection<QualitativeValue> qualitativeValues)
        {
            final Parameter entity = new ParameterImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setIsQualitative(isQualitative);
            entity.setIsTaxinomic(isTaxinomic);
            entity.setIsCalculated(isCalculated);
            entity.setIsAlphanumeric(isAlphanumeric);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setParameterGroup(parameterGroup);
            entity.setStatus(status);
            entity.setQualitativeValues(qualitativeValues);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Parameter o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.isIsQualitative() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsQualitative().compareTo(o.isIsQualitative()));
            }
            if (this.isIsTaxinomic() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsTaxinomic().compareTo(o.isIsTaxinomic()));
            }
            if (this.isIsCalculated() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsCalculated().compareTo(o.isIsCalculated()));
            }
            if (this.isIsAlphanumeric() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsAlphanumeric().compareTo(o.isIsAlphanumeric()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Parameter.java merge-point
}