// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Les méthodes sont rassemblées dans une liste qui couvre tous les domaines pour lesquels il existe
 * un paramètre.
 * La liste des méthodes est générique et porte sur toutes les phases du processus de mesure des
 * paramètres. Chaque méthode n'est pas non plus systématiquement spécifique à l'une de ces phases
 * ou à une nature particulière de paramètre. En effet, une méthode peut couvrir tout le cycle du
 * processus et/ou être utilisable pour une phase quelle que soit la nature du paramètre.
 * Les méthodes peuvent être référencées par les paramètres à différentes phases de leur processus
 * de mesure que sont :
 * pour les paramètres biologique :
 * - le prélèvement et l'échantillonnage ;
 * - la conservation et le transport ;
 * - le fractionnement ;
 * - l'analyse ;
 * pour les paramètres environnementaux :
 * - l'observation ;
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Method
    implements Serializable, Comparable<Method>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 6161971094760201154L;

    // Generate 11 attributes
    private Integer id;

    /**
     * Identifiant unique de la méthode.Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique de la méthode.Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * Description courte de la méthode.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Description courte de la méthode.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * Description longue de la méthode.
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Description longue de la méthode.
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private String conditioning;

    /**
     * Description du conditionnement des échantillons ou des prélèvements en vue de leur analyse.
     * @return this.conditioning String
     */
    public String getConditioning()
    {
        return this.conditioning;
    }

    /**
     * Description du conditionnement des échantillons ou des prélèvements en vue de leur analyse.
     * @param conditioningIn String
     */
    public void setConditioning(String conditioningIn)
    {
        this.conditioning = conditioningIn;
    }

    private String preparation;

    /**
     * Description de la préparation des échantillons ou des prélèvements en vue de leur analyse.
     * @return this.preparation String
     */
    public String getPreparation()
    {
        return this.preparation;
    }

    /**
     * Description de la préparation des échantillons ou des prélèvements en vue de leur analyse.
     * @param preparationIn String
     */
    public void setPreparation(String preparationIn)
    {
        this.preparation = preparationIn;
    }

    private String conservation;

    /**
     * Description de la méthode de conservation des échantillons ou des prélèvements en vue de leur
     * analyse.
     * @return this.conservation String
     */
    public String getConservation()
    {
        return this.conservation;
    }

    /**
     * Description de la méthode de conservation des échantillons ou des prélèvements en vue de leur
     * analyse.
     * @param conservationIn String
     */
    public void setConservation(String conservationIn)
    {
        this.conservation = conservationIn;
    }

    private String reference;

    /**
     * Référence nationale ou internationale de la méthode.
     * Référence à l'origine de la méthode.
     * Par exemple :
     * - "Bradford M., 1976. A rapid method for quantification of protein utilizing the principle of
     * dye binding. Anal. Biochem. 72 : 248-264"
     * - "Circulaire 1988 Mer/Agriculture"
     * Nombre de lignes : 500
     * @return this.reference String
     */
    public String getReference()
    {
        return this.reference;
    }

    /**
     * Référence nationale ou internationale de la méthode.
     * Référence à l'origine de la méthode.
     * Par exemple :
     * - "Bradford M., 1976. A rapid method for quantification of protein utilizing the principle of
     * dye binding. Anal. Biochem. 72 : 248-264"
     * - "Circulaire 1988 Mer/Agriculture"
     * Nombre de lignes : 500
     * @param referenceIn String
     */
    public void setReference(String referenceIn)
    {
        this.reference = referenceIn;
    }

    private String rank;

    /**
     * Numéro de la méthode pour pouvoir "chainer" les méthodes. Il est saisi par l'administrateur.
     * @return this.rank String
     */
    public String getRank()
    {
        return this.rank;
    }

    /**
     * Numéro de la méthode pour pouvoir "chainer" les méthodes. Il est saisi par l'administrateur.
     * @param rankIn String
     */
    public void setRank(String rankIn)
    {
        this.rank = rankIn;
    }

    private String handbookPath;

    /**
     * Lien vers un fichier PDF décrivant plus précisemment la méthode.
     * @return this.handbookPath String
     */
    public String getHandbookPath()
    {
        return this.handbookPath;
    }

    /**
     * Lien vers un fichier PDF décrivant plus précisemment la méthode.
     * @param handbookPathIn String
     */
    public void setHandbookPath(String handbookPathIn)
    {
        this.handbookPath = handbookPathIn;
    }

    private Date creationDate;

    /**
     * Date système de création de la méthode. Cette date est renseignée automatiquement.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date système de création de la méthode. Cette date est renseignée automatiquement.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour de création de la méthode. Cette date est renseignée automatiquement.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour de création de la méthode. Cette date est renseignée automatiquement.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Method instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Method))
        {
            return false;
        }
        final Method that = (Method)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Method}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Method}.
         * @return new MethodImpl()
         */
        public static Method newInstance()
        {
            return new MethodImpl();
        }

        /**
         * Constructs a new instance of {@link Method}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param rank String
         * @param creationDate Date
         * @param status Status
         * @return newInstance
         */
        public static Method newInstance(String name, String rank, Date creationDate, Status status)
        {
            final Method entity = new MethodImpl();
            entity.setName(name);
            entity.setRank(rank);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Method}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param conditioning String
         * @param preparation String
         * @param conservation String
         * @param reference String
         * @param rank String
         * @param handbookPath String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param status Status
         * @return newInstance Method
         */
        public static Method newInstance(String name, String description, String conditioning, String preparation, String conservation, String reference, String rank, String handbookPath, Date creationDate, Timestamp updateDate, Status status)
        {
            final Method entity = new MethodImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setConditioning(conditioning);
            entity.setPreparation(preparation);
            entity.setConservation(conservation);
            entity.setReference(reference);
            entity.setRank(rank);
            entity.setHandbookPath(handbookPath);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Method o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getConditioning() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getConditioning().compareTo(o.getConditioning()));
            }
            if (this.getPreparation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPreparation().compareTo(o.getPreparation()));
            }
            if (this.getConservation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getConservation().compareTo(o.getConservation()));
            }
            if (this.getReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReference().compareTo(o.getReference()));
            }
            if (this.getRank() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRank().compareTo(o.getRank()));
            }
            if (this.getHandbookPath() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getHandbookPath().compareTo(o.getHandbookPath()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Method.java merge-point
}