// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.metier;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * <html>
 * <head>
 * </head>
 * <body>
 * <p>
 * M&#233;tier, qui peut etre un m&#233;tier de peche ou non.<br><br>Un
 * m&#233;tier de peche a obligatoirement une esp&#232;ce cible (TaxonGroup) de
 * d&#233;fini, et &#233;ventuellement un engin (Gear).
 * </p>
 * <p>
 * Dans ce cas, le nom (name) et le mn&#233;monique (label) pourront etre
 * d&#233;termin&#233; par la concat&#233;nation de l'engin et de l'esp&#232;ce cible.
 * </p>
 * <p>
 * <br>
 * <br>
 * </p>
 * <p>
 * <u>V2.1 </u>: modification de la gestion des m&#233;tiers : suppression des
 * classes FishingMetierGearType et MetierSpecies : un m&#233;tier est
 * maintenant d&#233;fini directement par Gear et TaxonGroup.<br><br>=&gt; Le
 * r&#233;f&#233;rentiel des engin du m&#233;tier (FishingMetierGearType) est maintenent
 * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des engins<br>
 * </p>
 * <p>
 * </p>
 * <p>
 * =&gt; Le r&#233;f&#233;rentiel des esp&#232;ces m&#233;tier (MetierSpecies) est maintenent
 * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des groupes de taxon<br><br>
 * </p>
 * <p>
 * <u>V3 </u>:<br>- Le m&#233;tier de peche n'a pas forc&#233;ment d'engin
 * (optionnel) Ex : AQUNEP
 * </p>
 * <p>
 * (Aquaculture)<br>- le mn&#233;monique et le libell&#233; ne sont plus calcul&#233;s &#224;
 * la vol&#233;e par concat&#233;nation, pour permettre l'utilisation de libell&#233; plus
 * court..
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Metier
    implements Serializable, Comparable<Metier>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -8624392860777187664L;

    // Generate 5 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * Pour un métier de peche, le mnémonique est généralement la concaténation du mnémonique de
     * l'engin et de celui du groupe de taxon (si un le groupe de taxon en a un).
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Pour un métier de peche, le mnémonique est généralement la concaténation du mnémonique de
     * l'engin et de celui du groupe de taxon (si un le groupe de taxon en a un).
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private String name;

    /**
     * Libellé du métier.
     * Pour un métier de peche, déterminé généralement à partir de la concaténation du libellé de
     * l'engin, de la chaine " à ", puis du libellé du groupe de taxon.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé du métier.
     * Pour un métier de peche, déterminé généralement à partir de la concaténation du libellé de
     * l'engin, de la chaine " à ", puis du libellé du groupe de taxon.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * Description longue du métier
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Description longue du métier
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 9 associations
    private TaxonGroup taxonGroup;

    /**
     * Uniquement les groupes de taxon de type "espece commerciale FAO".
     * Obligatoire si le métier est un métier de peche.
     * @return this.taxonGroup TaxonGroup
     */
    public TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    /**
     * Uniquement les groupes de taxon de type "espece commerciale FAO".
     * Obligatoire si le métier est un métier de peche.
     * @param taxonGroupIn TaxonGroup
     */
    public void setTaxonGroup(TaxonGroup taxonGroupIn)
    {
        this.taxonGroup = taxonGroupIn;
    }

    private Gear gear;

    /**
     * Engin du métier.
     * Obligatoire si le métier est un métier de peche.
     * @return this.gear Gear
     */
    public Gear getGear()
    {
        return this.gear;
    }

    /**
     * Engin du métier.
     * Obligatoire si le métier est un métier de peche.
     * @param gearIn Gear
     */
    public void setGear(Gear gearIn)
    {
        this.gear = gearIn;
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Metier instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Metier))
        {
            return false;
        }
        final Metier that = (Metier)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Metier}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Metier}.
         * @return new MetierImpl()
         */
        public static Metier newInstance()
        {
            return new MetierImpl();
        }

        /**
         * Constructs a new instance of {@link Metier}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param status Status
         * @return newInstance
         */
        public static Metier newInstance(String name, Status status)
        {
            final Metier entity = new MetierImpl();
            entity.setName(name);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Metier}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param name String
         * @param description String
         * @param updateDate Timestamp
         * @param taxonGroup TaxonGroup
         * @param gear Gear
         * @param status Status
         * @return newInstance Metier
         */
        public static Metier newInstance(String label, String name, String description, Timestamp updateDate, TaxonGroup taxonGroup, Gear gear, Status status)
        {
            final Metier entity = new MetierImpl();
            entity.setLabel(label);
            entity.setName(name);
            entity.setDescription(description);
            entity.setUpdateDate(updateDate);
            entity.setTaxonGroup(taxonGroup);
            entity.setGear(gear);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Metier o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Metier.java merge-point
}