package fr.ifremer.adagio.core.dao.referential.location;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: LocationExtendDao.java 12005 2014-03-29 00:14:41Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/referential/location/LocationExtendDao.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

public interface LocationExtendDao extends LocationDao {

	/**
	 * Return location label from a longitude and a latitude (in decimal degrees - WG84).
	 * 
	 * @param latitude
	 *            a latitude (in decimal degrees - WG84)
	 * @param longitude
	 *            a longitude (in decimal degrees - WG84)
	 * @return A location label (corresponding to a statistical rectangle), or null if no statistical rectangle exists
	 *         for this position
	 */
	String getLocationLabelByLatLong(Float latitude, Float longitude);

	/**
	 * Return a location Id, from a longitude and a latitude (in decimal degrees - WG84).
	 * This method typically use getLocationLabelByLatLong().
	 * 
	 * @param latitude
	 *            a latitude (in decimal degrees - WG84)
	 * @param longitude
	 *            a longitude (in decimal degrees - WG84)
	 * @return A location Id (corresponding to a statistical rectangle), or null if no statistical rectangle exists for
	 *         this position
	 */
	Integer getLocationIdByLabelAndLocationLevel(String locationLabel, Integer[] locationLevelIds);

	/**
	 * Refresh location hierarchy technical data
	 */
	void refreshLocationHierarchy();

	/**
	 * Retrieve the parent location, of a given level (using LocationHierarchy)
	 * 
	 * @param parentLocationLevelId
	 * @param locationId
	 * @return
	 */
	Location getParentLocationByLebel(int parentLocationLevelId, int locationId);
}
