// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.location;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: LocationDaoImpl.java 12005 2014-03-29 00:14:41Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/referential/location/LocationDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Iterator;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.dao.DataRetrievalFailureException;

import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.service.referential.location.LocationUtils;

/**
 * @see fr.ifremer.adagio.core.dao.referential.location.Location
 */
@org.springframework.stereotype.Repository("locationDao")
public class LocationDaoImpl
		extends fr.ifremer.adagio.core.dao.referential.location.LocationDaoBase
		implements LocationExtendDao {

	private static final String QUERY_LOCATION_ID_BY_LABEL_AND_LOCATION_LEVEL_IDS = "selectLocationIdByLabelAndLocationLevel";

	/**
	 * Constructor used by Spring
	 */
	@org.springframework.beans.factory.annotation.Autowired
	public LocationDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public String getLocationLabelByLatLong(Float latitude, Float longitude) {
		return LocationUtils.computeStatisticalRectangle(latitude, longitude);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Integer getLocationIdByLabelAndLocationLevel(String locationLabel, Integer[] locationLevelIds) {
		logger.debug("call getLocationIdByLabelAndLocationLevel()"); //$NON-NLS-1$
		try {
			Query query = createQuery("selectLocationIdByLabelAndLocationLevel", //$NON-NLS-1$
					"locationLabel", StringType.INSTANCE, locationLabel); //$NON-NLS-1$
			query.setParameterList("locationLevelIds", locationLevelIds); //$NON-NLS-1$ //$NON-NLS-1$
			Iterator<Integer> rows = (Iterator<Integer>) query.iterate();

			List<Integer> locationIds = Lists.newArrayList();
			while (rows.hasNext()) {
				Integer locationId = rows.next();
				locationIds.add(locationId);
			}
			if (locationIds.size() == 0) {
				return null;
			}
			if (locationIds.size() > 1) {
				throw new DataRetrievalFailureException("Too many locations found, for label : " + locationLabel);
			}

			// Return the first element in the list
			return locationIds.get(0);
		} catch (RuntimeException re) {
			logger.error("getLocationIdByLabelAndLocationLevel failed", re); //$NON-NLS-1$
			throw re;
		}
	}

	@Override
	public Location getParentLocationByLebel(int parentLocationLevelId, int locationId) {
		Location result = queryUniqueTyped("selectParentLocationByLevel",
				"locationLevelId", IntegerType.INSTANCE, parentLocationLevelId,
				"locationId", IntegerType.INSTANCE, locationId);

		return result;
	}

	@Override
	public void refreshLocationHierarchy() {
		throw new UnsupportedOperationException("Not implemented yet !");
	}
}