package fr.ifremer.adagio.core.dao.data.vessel.feature.use;

/*
 * #%L
 * Tutti :: Persistence API
 * $Id: VesselUseFeaturesDaoImpl.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/vessel/feature/physical/VesselUseFeaturesDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;

import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.measure.VesselUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;

@Repository("vesselUseFeaturesDao")
@Lazy
public class VesselUseFeaturesDaoImpl
		extends VesselUseFeaturesDaoBase
		implements VesselUseFeaturesExtendDao {

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public VesselUseFeaturesDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public VesselUseFeatures getVesselUseFeatures(FishingTrip fishingTrip,
			boolean createIfNotExists) {

		if (CollectionUtils.isNotEmpty(fishingTrip.getVesselUseFeatures())) {
			if (fishingTrip.getVesselUseFeatures().size() > 1) {
				throw new DataRetrievalFailureException(String.format(
						"Could not load VesseluseFeatures on fishingTrip with id=%, because more than one existing.", fishingTrip.getId()));
			}
			VesselUseFeatures vuf = fishingTrip.getVesselUseFeatures().iterator().next();
			return vuf;
		}

		if (!createIfNotExists) {
			return null;
		}

		// Create a new entity
		VesselUseFeatures vuf = VesselUseFeatures.Factory.newInstance();
		fishingTrip.setVesselUseFeatures(Sets.newHashSet(vuf));
		vuf.setFishingTrip(fishingTrip);

		// Set default attributes (copy from operation)
		vuf.setStartDate(fishingTrip.getDepartureDateTime());
		vuf.setEndDate(fishingTrip.getReturnDateTime());
		vuf.setProgram(fishingTrip.getProgram());
		vuf.setVessel(fishingTrip.getVessel());
		vuf.setCreationDate(new Date());
		vuf.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
		vuf.setIsActive(isActive.ACTIVE.getValue());

		return vuf;
	}

	@Override
	public VesselUseFeatures getVesselUseFeatures(Operation operation,
			boolean createIfNotExists) {

		if (CollectionUtils.isNotEmpty(operation.getVesselUseFeatures())) {
			VesselUseFeatures vuf = CollectionUtils.extractSingleton(operation.getVesselUseFeatures());
			/*
			 * if (operation.getVesselUseFeatures().size() > 1) {
			 * throw new DataRetrievalFailureException(String.format(
			 * "Could not load VesseluseFeatures on fishingTrip with id=%s, because more than one existing.",
			 * operation.getId()));
			 * }
			 * VesselUseFeatures vuf = operation.getVesselUseFeatures().iterator().next();
			 */
			return vuf;
		}

		if (!createIfNotExists) {
			return null;
		}

		// Create a new entity
		VesselUseFeatures vuf = VesselUseFeatures.Factory.newInstance();
		operation.setVesselUseFeatures(Sets.newHashSet(vuf));
		vuf.setOperation(operation);

		// Set default attributes (copy from operation)
		vuf.setStartDate(operation.getStartDateTime());
		vuf.setEndDate(operation.getEndDateTime());
		vuf.setVessel(operation.getVessel());
		vuf.setCreationDate(new Date());
		vuf.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
		vuf.setIsActive(isActive.ACTIVE.getValue());

		return vuf;
	}

	@Override
	public VesselUseMeasurement getVesselUseMeasurement(VesselUseFeatures vesselUseFeatures, Integer pmfmId) {
		return getVesselUseMeasurement(vesselUseFeatures, pmfmId, false);
	}

	protected VesselUseMeasurement getVesselUseMeasurement(VesselUseFeatures vesselUseFeatures,
			Integer pmfmId, boolean createIfNotExists) {
		VesselUseMeasurement vesselUseMeasurement = null;
		if (vesselUseFeatures.getVesselUseMeasurements() != null) {
			for (VesselUseMeasurement vum : vesselUseFeatures.getVesselUseMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					vesselUseMeasurement = vum;
					break;
				}
			}
		}
		if (vesselUseMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			vesselUseMeasurement = VesselUseMeasurement.Factory.newInstance();
			vesselUseMeasurement.setVesselUseFeatures(vesselUseFeatures);
			if (vesselUseFeatures.getVesselUseMeasurements() == null) {
				vesselUseFeatures.setVesselUseMeasurements(Sets.newHashSet(vesselUseMeasurement));
			} else {
				vesselUseFeatures.getVesselUseMeasurements().add(vesselUseMeasurement);
			}
			vesselUseMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			Pmfm pmfm = load(PmfmImpl.class, pmfmId);
			vesselUseMeasurement.setPmfm(pmfm);
		}

		return vesselUseMeasurement;
	}

	@Override
	public void removeVesselUseMeasurement(VesselUseFeatures vesselUseFeatures,
			Integer pmfmId) {
		VesselUseMeasurement vesselUseMeasurement = getVesselUseMeasurement(vesselUseFeatures, pmfmId, false);
		if (vesselUseMeasurement == null) {
			return;
		}
		vesselUseFeatures.getVesselUseMeasurements().remove(vesselUseMeasurement);
		// TOBO BLa : vérifier qu'il ne faut pas dao.delete() en plus
	}

	@Override
	public VesselUseMeasurement setVesselUseMeasurement(FishingTrip fishingTrip, VesselUseFeatures vesselUseFeatures,
			Integer pmfmId,
			Float numericalValue,
			String alphanumericalValue,
			Integer qualitativevalueId) {
		Department recorderDepartment = null;
		if (fishingTrip != null) {
			recorderDepartment = fishingTrip.getRecorderDepartment();
		}
		return setVesselUseMeasurement(vesselUseFeatures, pmfmId, numericalValue, alphanumericalValue, qualitativevalueId, recorderDepartment.getId());
	}

	@Override
	public VesselUseMeasurement setVesselUseMeasurement(VesselUseFeatures vesselUseFeatures,
			Integer pmfmId,
			Float numericalValue,
			String alphanumericalValue,
			Integer qualitativevalueId,
			Integer recorderDepartmentId) {
		VesselUseMeasurement vesselUseMeasurement = getVesselUseMeasurement(vesselUseFeatures, pmfmId, true);

		if (alphanumericalValue != null) {
			vesselUseMeasurement.setAlphanumericalValue(alphanumericalValue);
		} else if (numericalValue != null) {
			vesselUseMeasurement.setNumericalValue(numericalValue);
		} else if (qualitativevalueId != null) {
			QualitativeValue qv = load(QualitativeValueImpl.class, qualitativevalueId);
			vesselUseMeasurement.setQualitativeValue(qv);
		}

		if (recorderDepartmentId != null) {
			vesselUseMeasurement.setDepartment(load(DepartmentImpl.class, recorderDepartmentId));
		}

		return vesselUseMeasurement;
	}

	@Override
	public void remove(Collection<VesselUseFeatures> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"VesselUseFeatures.remove - 'entities' can not be null");
		}
		for (VesselUseFeatures entity : entities) {
			remove(entity);
		}
	}

	@Override
	public void remove(VesselUseFeatures entity) {
		if (CollectionUtils.isNotEmpty(entity.getVesselUseMeasurements())) {
			entity.getVesselUseMeasurements().clear();
		}
		super.remove(entity);
	}

}
