// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.use;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.VesselUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.activity.ActivityCalendar;
import fr.ifremer.adagio.core.dao.data.survey.activity.DailyActivityCalendar;
import fr.ifremer.adagio.core.dao.data.survey.economy.EconomicalSurvey;
import fr.ifremer.adagio.core.dao.data.survey.fishingEffort.FishingEffortCalendar;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de données
 * de déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
 * Par exemple, pour les donénes d'observation :
 * • profondeur de mer au début de l'opération, en mètre,
 * • profondeur de mer à la fin de l'opération, en mètre,
 * • déroulement de l'opération (normal, anormal, etc.)
 * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
 * • trait rectiligne (oui/non)
 * • cout en gazoil,
 * • nombre d'engin perdu,
 * • cout des pertes,
 * • etc.
 * Par exemple, pour les données de déclaration :
 * • temps de pêche,
 * • temps de route (qui peut aussi etre calculé à l'exploitation),
 * • nombre d'opérations,
 * • etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselUseFeatures
    extends UseFeaturesImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 302953470445779139L;

    // Generate 1 attributes
    private Integer isActive;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Le navire est il actif pour la p&#233;riode concern&#233; (Oui/Non).
     * </p>
     * <p>
     * &quot;1&quot; pour actif, &quot;0&quot; pour inactif, et &quot;2&quot; pour inexistant (cas
     * des
     * calendrier d'activit&#233; uniquement)
     * <br>    </p>
     * <p>
     * </p>
     * <p>
     * Cet attribut n'a pas &#233;t&#233; mis en tant que UseMeasurement, car il est tr&#232;s
     * utile pour les diff&#233;rents traitements, et il reste un attribut constant
     * et r&#233;current de toutes les caract&#233;ristiques d'utilisation de navire
     * </p>
     * </body>
     * </html>
     * @return this.isActive Integer
     */
    public Integer getIsActive()
    {
        return this.isActive;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Le navire est il actif pour la p&#233;riode concern&#233; (Oui/Non).
     * </p>
     * <p>
     * &quot;1&quot; pour actif, &quot;0&quot; pour inactif, et &quot;2&quot; pour inexistant (cas
     * des
     * calendrier d'activit&#233; uniquement)
     * <br>    </p>
     * <p>
     * </p>
     * <p>
     * Cet attribut n'a pas &#233;t&#233; mis en tant que UseMeasurement, car il est tr&#232;s
     * utile pour les diff&#233;rents traitements, et il reste un attribut constant
     * et r&#233;current de toutes les caract&#233;ristiques d'utilisation de navire
     * </p>
     * </body>
     * </html>
     * @param isActiveIn Integer
     */
    public void setIsActive(Integer isActiveIn)
    {
        this.isActive = isActiveIn;
    }

    // Generate 10 associations
    private DailyActivityCalendar dailyActivityCalendar;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @return this.dailyActivityCalendar DailyActivityCalendar
     */
    public DailyActivityCalendar getDailyActivityCalendar()
    {
        return this.dailyActivityCalendar;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @param dailyActivityCalendarIn DailyActivityCalendar
     */
    public void setDailyActivityCalendar(DailyActivityCalendar dailyActivityCalendarIn)
    {
        this.dailyActivityCalendar = dailyActivityCalendarIn;
    }

    private Location basePortLocation;

    /**
     * Port d'exploitation, ou port d'attache (si pas d'activité).
     * @return this.basePortLocation Location
     */
    public Location getBasePortLocation()
    {
        return this.basePortLocation;
    }

    /**
     * Port d'exploitation, ou port d'attache (si pas d'activité).
     * @param basePortLocationIn Location
     */
    public void setBasePortLocation(Location basePortLocationIn)
    {
        this.basePortLocation = basePortLocationIn;
    }

    private Operation operation;

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operation Operation
     */
    public Operation getOperation()
    {
        return this.operation;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationIn Operation
     */
    public void setOperation(Operation operationIn)
    {
        this.operation = operationIn;
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private ActivityCalendar activityCalendar;

    /**
     * 
     * @return this.activityCalendar ActivityCalendar
     */
    public ActivityCalendar getActivityCalendar()
    {
        return this.activityCalendar;
    }

    /**
     * 
     * @param activityCalendarIn ActivityCalendar
     */
    public void setActivityCalendar(ActivityCalendar activityCalendarIn)
    {
        this.activityCalendar = activityCalendarIn;
    }

    private EconomicalSurvey economicalSurvey;

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @return this.economicalSurvey EconomicalSurvey
     */
    public EconomicalSurvey getEconomicalSurvey()
    {
        return this.economicalSurvey;
    }

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @param economicalSurveyIn EconomicalSurvey
     */
    public void setEconomicalSurvey(EconomicalSurvey economicalSurveyIn)
    {
        this.economicalSurvey = economicalSurveyIn;
    }

    private FishingEffortCalendar fishingEffortCalendar;

    /**
     * Enquete d'effort de peche (Calendrier d'effort de peche) d'un navire.
     * @return this.fishingEffortCalendar FishingEffortCalendar
     */
    public FishingEffortCalendar getFishingEffortCalendar()
    {
        return this.fishingEffortCalendar;
    }

    /**
     * Enquete d'effort de peche (Calendrier d'effort de peche) d'un navire.
     * @param fishingEffortCalendarIn FishingEffortCalendar
     */
    public void setFishingEffortCalendar(FishingEffortCalendar fishingEffortCalendarIn)
    {
        this.fishingEffortCalendar = fishingEffortCalendarIn;
    }

    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @return this.fishingAreas Collection<FishingArea>
     */
    public Collection<FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param fishingAreasIn Collection<FishingArea>
     */
    public void setFishingAreas(Collection<FishingArea> fishingAreasIn)
    {
        this.fishingAreas = fishingAreasIn;
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param elementToAdd FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingAreas(FishingArea elementToAdd)
    {
        return this.fishingAreas.add(elementToAdd);
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param elementToRemove FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingAreas(FishingArea elementToRemove)
    {
        return this.fishingAreas.remove(elementToRemove);
    }

    private Collection<VesselUseFeaturesOrigin> vesselUseFeaturesOrigins = new HashSet<VesselUseFeaturesOrigin>();

    /**
     * Comment gérer cet attribut dans le cas d'une enquete ?
     * => REVOIR le texte ci-dessous :
     * Exemple pour les enquete d'activité :
     * - Si les informations issues de la prédocumentation électronique ont été collées dans le
     * calendrier sans modification, alors Origine = Flux déclaratif. Si ce sont les informations du
     * calendrier l’année précédente qui sont copiées-collées (Prédocumentation calendrier
     * d’activité n-1) alors Origine = Calendrier (n-1).
     * - Si des informations ont été pré-renseignées à partir des « observations des captures à bord
     * des navires de pêche », alors Origine = Observation en mer, et à partir des «
     * échantillonnages des marées au débarquement », alors Origine = Observation au débarquement.
     * Dès lors qu’une information du bloc métier est modifiée, l’Origine de l’information devra
     * être repositionnée à Enquête.
     * @return this.vesselUseFeaturesOrigins Collection<VesselUseFeaturesOrigin>
     */
    public Collection<VesselUseFeaturesOrigin> getVesselUseFeaturesOrigins()
    {
        return this.vesselUseFeaturesOrigins;
    }

    /**
     * Comment gérer cet attribut dans le cas d'une enquete ?
     * => REVOIR le texte ci-dessous :
     * Exemple pour les enquete d'activité :
     * - Si les informations issues de la prédocumentation électronique ont été collées dans le
     * calendrier sans modification, alors Origine = Flux déclaratif. Si ce sont les informations du
     * calendrier l’année précédente qui sont copiées-collées (Prédocumentation calendrier
     * d’activité n-1) alors Origine = Calendrier (n-1).
     * - Si des informations ont été pré-renseignées à partir des « observations des captures à bord
     * des navires de pêche », alors Origine = Observation en mer, et à partir des «
     * échantillonnages des marées au débarquement », alors Origine = Observation au débarquement.
     * Dès lors qu’une information du bloc métier est modifiée, l’Origine de l’information devra
     * être repositionnée à Enquête.
     * @param vesselUseFeaturesOriginsIn Collection<VesselUseFeaturesOrigin>
     */
    public void setVesselUseFeaturesOrigins(Collection<VesselUseFeaturesOrigin> vesselUseFeaturesOriginsIn)
    {
        this.vesselUseFeaturesOrigins = vesselUseFeaturesOriginsIn;
    }

    /**
     * Comment gérer cet attribut dans le cas d'une enquete ?
     * => REVOIR le texte ci-dessous :
     * Exemple pour les enquete d'activité :
     * - Si les informations issues de la prédocumentation électronique ont été collées dans le
     * calendrier sans modification, alors Origine = Flux déclaratif. Si ce sont les informations du
     * calendrier l’année précédente qui sont copiées-collées (Prédocumentation calendrier
     * d’activité n-1) alors Origine = Calendrier (n-1).
     * - Si des informations ont été pré-renseignées à partir des « observations des captures à bord
     * des navires de pêche », alors Origine = Observation en mer, et à partir des «
     * échantillonnages des marées au débarquement », alors Origine = Observation au débarquement.
     * Dès lors qu’une information du bloc métier est modifiée, l’Origine de l’information devra
     * être repositionnée à Enquête.
     * @param elementToAdd VesselUseFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselUseFeaturesOrigins(VesselUseFeaturesOrigin elementToAdd)
    {
        return this.vesselUseFeaturesOrigins.add(elementToAdd);
    }

    /**
     * Comment gérer cet attribut dans le cas d'une enquete ?
     * => REVOIR le texte ci-dessous :
     * Exemple pour les enquete d'activité :
     * - Si les informations issues de la prédocumentation électronique ont été collées dans le
     * calendrier sans modification, alors Origine = Flux déclaratif. Si ce sont les informations du
     * calendrier l’année précédente qui sont copiées-collées (Prédocumentation calendrier
     * d’activité n-1) alors Origine = Calendrier (n-1).
     * - Si des informations ont été pré-renseignées à partir des « observations des captures à bord
     * des navires de pêche », alors Origine = Observation en mer, et à partir des «
     * échantillonnages des marées au débarquement », alors Origine = Observation au débarquement.
     * Dès lors qu’une information du bloc métier est modifiée, l’Origine de l’information devra
     * être repositionnée à Enquête.
     * @param elementToRemove VesselUseFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselUseFeaturesOrigins(VesselUseFeaturesOrigin elementToRemove)
    {
        return this.vesselUseFeaturesOrigins.remove(elementToRemove);
    }

    private Collection<VesselUseMeasurement> vesselUseMeasurements = new HashSet<VesselUseMeasurement>();

    /**
     * 
     * @return this.vesselUseMeasurements Collection<VesselUseMeasurement>
     */
    public Collection<VesselUseMeasurement> getVesselUseMeasurements()
    {
        return this.vesselUseMeasurements;
    }

    /**
     * 
     * @param vesselUseMeasurementsIn Collection<VesselUseMeasurement>
     */
    public void setVesselUseMeasurements(Collection<VesselUseMeasurement> vesselUseMeasurementsIn)
    {
        this.vesselUseMeasurements = vesselUseMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd VesselUseMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselUseMeasurements(VesselUseMeasurement elementToAdd)
    {
        return this.vesselUseMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove VesselUseMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselUseMeasurements(VesselUseMeasurement elementToRemove)
    {
        return this.vesselUseMeasurements.remove(elementToRemove);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>UseFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.use.UseFeatures#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>UseFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.use.UseFeatures#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link VesselUseFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselUseFeatures}.
         * @return new VesselUseFeaturesImpl()
         */
        public static VesselUseFeatures newInstance()
        {
            return new VesselUseFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link VesselUseFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param creationDate Date
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance
         */
        public static VesselUseFeatures newInstance(Date creationDate, Program program, QualityFlag qualityFlag, Vessel vessel)
        {
            final VesselUseFeatures entity = new VesselUseFeaturesImpl();
            entity.setCreationDate(creationDate);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselUseFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param isActive Integer
         * @param dailyActivityCalendar DailyActivityCalendar
         * @param basePortLocation Location
         * @param operation Operation
         * @param fishingTrip FishingTrip
         * @param activityCalendar ActivityCalendar
         * @param economicalSurvey EconomicalSurvey
         * @param fishingEffortCalendar FishingEffortCalendar
         * @param fishingAreas Collection<FishingArea>
         * @param vesselUseFeaturesOrigins Collection<VesselUseFeaturesOrigin>
         * @param vesselUseMeasurements Collection<VesselUseMeasurement>
         * @return newInstance VesselUseFeatures
         */
        public static VesselUseFeatures newInstance(Date startDate, Date endDate, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Program program, QualityFlag qualityFlag, Vessel vessel, Integer isActive, DailyActivityCalendar dailyActivityCalendar, Location basePortLocation, Operation operation, FishingTrip fishingTrip, ActivityCalendar activityCalendar, EconomicalSurvey economicalSurvey, FishingEffortCalendar fishingEffortCalendar, Collection<FishingArea> fishingAreas, Collection<VesselUseFeaturesOrigin> vesselUseFeaturesOrigins, Collection<VesselUseMeasurement> vesselUseMeasurements)
        {
            final VesselUseFeatures entity = new VesselUseFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setIsActive(isActive);
            entity.setDailyActivityCalendar(dailyActivityCalendar);
            entity.setBasePortLocation(basePortLocation);
            entity.setOperation(operation);
            entity.setFishingTrip(fishingTrip);
            entity.setActivityCalendar(activityCalendar);
            entity.setEconomicalSurvey(economicalSurvey);
            entity.setFishingEffortCalendar(fishingEffortCalendar);
            entity.setFishingAreas(fishingAreas);
            entity.setVesselUseFeaturesOrigins(vesselUseFeaturesOrigins);
            entity.setVesselUseMeasurements(vesselUseMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselUseFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getIsActive() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIsActive().compareTo(o.getIsActive()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselUseFeatures.java merge-point
}