package fr.ifremer.adagio.core.dao.data.vessel.feature.use;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: GearPhysicalFeaturesExtendDao.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/vessel/feature/physical/GearPhysicalFeaturesExtendDao.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.GearUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;

public interface GearUseFeaturesExtendDao extends GearUseFeaturesDao {

	/**
	 * @param gearUseFeatures
	 * @param pmfmId
	 * @param numericalValue
	 * @param alphanumericalValue
	 * @param qualitativevalueId
	 * @param recorderDepartment
	 * @return the updated or create GearUseMeasurement
	 * @Deprecated use the second method, with a recorderDepartmentId:Integer instead of recorderDepartment:Department
	 */
	GearUseMeasurement setGearUseMeasurement(GearUseFeatures gearUseFeatures, Integer pmfmId,
			Float numericalValue, String alphanumericalValue, Integer qualitativevalueId, Department recorderDepartment);

	/**
	 * Update or create a GearUseMeasurement, for a PMFM
	 * 
	 * @param gearUseFeatures
	 * @param pmfmId
	 * @param numericalValue
	 * @param alphanumericalValue
	 * @param qualitativevalueId
	 * @param recorderDepartmentId
	 * @return the updated or create GearUseMeasurement
	 */
	GearUseMeasurement setGearUseMeasurement(GearUseFeatures gearUseFeatures, Integer pmfmId,
			Float numericalValue, String alphanumericalValue, Integer qualitativevalueId, Integer recorderDepartmentId);

	void removeGearUseMeasurement(GearUseFeatures gearUseFeatures, Integer pmfmId);

	GearUseMeasurement getGearUseMeasurement(GearUseFeatures gearUseFeatures, Integer pmfmId);

	GearUseFeatures getGearUseFeatures(Operation operation, boolean createIfNotExists);

	/**
	 * Retrieve the fishing area, from a locationId.
	 * 
	 * @param gearUseFeatures
	 *            the parent gear use features
	 * @param locationId
	 *            the location id to use to retrieve the fishing area
	 * @param createIfNotExists
	 *            if true, create the entity if not exists, and link it to the gear use features
	 * @return
	 */
	FishingArea getFishingArea(GearUseFeatures gearUseFeatures, int locationId, boolean createIfNotExists);

	/**
	 * Retrieve the unique fishing area, from a gear use features.
	 * If more than on FA is found, throw a DataRetrievalException
	 * 
	 * @param gearUseFeatures
	 *            the parent gear use features
	 * @param createIfNotExists
	 *            if true, create the entity if not exists, and link it to the gear use features
	 * @throws DataRetrievalException
	 *             if more than once fishing area found
	 * @return
	 */
	FishingArea getFishingAreaAsUnique(GearUseFeatures gearUseFeatures, boolean createIfNotExists);

}
