// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.use;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.GearUseMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.activity.ActivityCalendar;
import fr.ifremer.adagio.core.dao.data.survey.activity.DailyActivityCalendar;
import fr.ifremer.adagio.core.dao.data.survey.economy.EconomicalSurvey;
import fr.ifremer.adagio.core.dao.data.survey.fishingEffort.FishingEffortCalendar;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.metier.Metier;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Paramètre de mise en oeuvre de l'engin durant une opération.
 * Exemple de paramètre de mise en oeuvre:
 * • nombre de boués,
 * • type de panneau,
 * • présence d'un racasseur,
 * • nombre de casier.
 * mais aussi :
 * • profondeur moyenne de l'engin,
 * • vitesse de traine moyenne
 * • ouverture du chalut
 */
// HibernateEntity.vsl annotations merge-point
public abstract class GearUseFeatures
    extends UseFeaturesImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -423706159861491683L;

    // Generate 1 attributes
    private Short rankOrder = Short.valueOf("1");

    /**
     * 
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * 
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    // Generate 11 associations
    private EconomicalSurvey economicalSurvey;

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @return this.economicalSurvey EconomicalSurvey
     */
    public EconomicalSurvey getEconomicalSurvey()
    {
        return this.economicalSurvey;
    }

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @param economicalSurveyIn EconomicalSurvey
     */
    public void setEconomicalSurvey(EconomicalSurvey economicalSurveyIn)
    {
        this.economicalSurvey = economicalSurveyIn;
    }

    private Gear otherGear;

    /**
     * @deprecated utilisation à éviter (utilisé pour les migrations de données essentiellement)
     * @return this.otherGear Gear
     */
    public Gear getOtherGear()
    {
        return this.otherGear;
    }

    /**
     * @deprecated utilisation à éviter (utilisé pour les migrations de données essentiellement)
     * @param otherGearIn Gear
     */
    public void setOtherGear(Gear otherGearIn)
    {
        this.otherGear = otherGearIn;
    }

    private Operation operation;

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operation Operation
     */
    public Operation getOperation()
    {
        return this.operation;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationIn Operation
     */
    public void setOperation(Operation operationIn)
    {
        this.operation = operationIn;
    }

    private DailyActivityCalendar dailyActivityCalendar;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @return this.dailyActivityCalendar DailyActivityCalendar
     */
    public DailyActivityCalendar getDailyActivityCalendar()
    {
        return this.dailyActivityCalendar;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Calendrier d'activit&#233; journalier.
     * <br>
     * <br>Par exemple, donn&#233;es collect&#233;es par l'action d'&#233;chantillonnage au
     * d&#233;barquement (SIH-ObsDeb).
     * <br>
     * <br>Le calendrier concerne une plage de jour cons&#233;cutif (g&#233;n&#233;ralement 7
     * jours), durant laquelle l'activit&#233; est renseign&#233;e pour chaque jour.
     * </body>
     * </html>
     * @param dailyActivityCalendarIn DailyActivityCalendar
     */
    public void setDailyActivityCalendar(DailyActivityCalendar dailyActivityCalendarIn)
    {
        this.dailyActivityCalendar = dailyActivityCalendarIn;
    }

    private ActivityCalendar activityCalendar;

    /**
     * 
     * @return this.activityCalendar ActivityCalendar
     */
    public ActivityCalendar getActivityCalendar()
    {
        return this.activityCalendar;
    }

    /**
     * 
     * @param activityCalendarIn ActivityCalendar
     */
    public void setActivityCalendar(ActivityCalendar activityCalendarIn)
    {
        this.activityCalendar = activityCalendarIn;
    }

    private FishingEffortCalendar fishingEffortCalendar;

    /**
     * Enquete d'effort de peche (Calendrier d'effort de peche) d'un navire.
     * @return this.fishingEffortCalendar FishingEffortCalendar
     */
    public FishingEffortCalendar getFishingEffortCalendar()
    {
        return this.fishingEffortCalendar;
    }

    /**
     * Enquete d'effort de peche (Calendrier d'effort de peche) d'un navire.
     * @param fishingEffortCalendarIn FishingEffortCalendar
     */
    public void setFishingEffortCalendar(FishingEffortCalendar fishingEffortCalendarIn)
    {
        this.fishingEffortCalendar = fishingEffortCalendarIn;
    }

    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @return this.fishingAreas Collection<FishingArea>
     */
    public Collection<FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param fishingAreasIn Collection<FishingArea>
     */
    public void setFishingAreas(Collection<FishingArea> fishingAreasIn)
    {
        this.fishingAreas = fishingAreasIn;
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param elementToAdd FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingAreas(FishingArea elementToAdd)
    {
        return this.fishingAreas.add(elementToAdd);
    }

    /**
     * Zone de peche ou d'activité effective d'un navire.
     * Contient une entrée pour chaque zone de peche d'un navire.
     * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
     * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens
     * de
     * composition (et des contraintes "delete cascade") depuis les autres tables.
     * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
     * @param elementToRemove FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingAreas(FishingArea elementToRemove)
    {
        return this.fishingAreas.remove(elementToRemove);
    }

    private Gear gear;

    /**
     * Par soucis de facilité d'exploitation de la base de données, il faut renseigner l'engin meme
     * si un métier a déjà été renseigné.
     * @return this.gear Gear
     */
    public Gear getGear()
    {
        return this.gear;
    }

    /**
     * Par soucis de facilité d'exploitation de la base de données, il faut renseigner l'engin meme
     * si un métier a déjà été renseigné.
     * @param gearIn Gear
     */
    public void setGear(Gear gearIn)
    {
        this.gear = gearIn;
    }

    private Collection<GearUseFeaturesOrigin> gearUseFeaturesOrigins = new HashSet<GearUseFeaturesOrigin>();

    /**
     * 
     * @return this.gearUseFeaturesOrigins Collection<GearUseFeaturesOrigin>
     */
    public Collection<GearUseFeaturesOrigin> getGearUseFeaturesOrigins()
    {
        return this.gearUseFeaturesOrigins;
    }

    /**
     * 
     * @param gearUseFeaturesOriginsIn Collection<GearUseFeaturesOrigin>
     */
    public void setGearUseFeaturesOrigins(Collection<GearUseFeaturesOrigin> gearUseFeaturesOriginsIn)
    {
        this.gearUseFeaturesOrigins = gearUseFeaturesOriginsIn;
    }

    /**
     * 
     * @param elementToAdd GearUseFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearUseFeaturesOrigins(GearUseFeaturesOrigin elementToAdd)
    {
        return this.gearUseFeaturesOrigins.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove GearUseFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearUseFeaturesOrigins(GearUseFeaturesOrigin elementToRemove)
    {
        return this.gearUseFeaturesOrigins.remove(elementToRemove);
    }

    private Metier metier;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * M&#233;tier, qui peut etre un m&#233;tier de peche ou non.<br><br>Un
     * m&#233;tier de peche a obligatoirement une esp&#232;ce cible (TaxonGroup) de
     * d&#233;fini, et &#233;ventuellement un engin (Gear).
     * </p>
     * <p>
     * Dans ce cas, le nom (name) et le mn&#233;monique (label) pourront etre
     * d&#233;termin&#233; par la concat&#233;nation de l'engin et de l'esp&#232;ce cible.
     * </p>
     * <p>
     * <br>
     * <br>
     * </p>
     * <p>
     * <u>V2.1 </u>: modification de la gestion des m&#233;tiers : suppression des
     * classes FishingMetierGearType et MetierSpecies : un m&#233;tier est
     * maintenant d&#233;fini directement par Gear et TaxonGroup.<br><br>=&gt; Le
     * r&#233;f&#233;rentiel des engin du m&#233;tier (FishingMetierGearType) est maintenent
     * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des engins<br>
     * </p>
     * <p>
     * </p>
     * <p>
     * =&gt; Le r&#233;f&#233;rentiel des esp&#232;ces m&#233;tier (MetierSpecies) est maintenent
     * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des groupes de taxon<br><br>
     * </p>
     * <p>
     * <u>V3 </u>:<br>- Le m&#233;tier de peche n'a pas forc&#233;ment d'engin
     * (optionnel) Ex : AQUNEP
     * </p>
     * <p>
     * (Aquaculture)<br>- le mn&#233;monique et le libell&#233; ne sont plus calcul&#233;s &#224;
     * la vol&#233;e par concat&#233;nation, pour permettre l'utilisation de libell&#233; plus
     * court..
     * </p>
     * </body>
     * </html>
     * @return this.metier Metier
     */
    public Metier getMetier()
    {
        return this.metier;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * M&#233;tier, qui peut etre un m&#233;tier de peche ou non.<br><br>Un
     * m&#233;tier de peche a obligatoirement une esp&#232;ce cible (TaxonGroup) de
     * d&#233;fini, et &#233;ventuellement un engin (Gear).
     * </p>
     * <p>
     * Dans ce cas, le nom (name) et le mn&#233;monique (label) pourront etre
     * d&#233;termin&#233; par la concat&#233;nation de l'engin et de l'esp&#232;ce cible.
     * </p>
     * <p>
     * <br>
     * <br>
     * </p>
     * <p>
     * <u>V2.1 </u>: modification de la gestion des m&#233;tiers : suppression des
     * classes FishingMetierGearType et MetierSpecies : un m&#233;tier est
     * maintenant d&#233;fini directement par Gear et TaxonGroup.<br><br>=&gt; Le
     * r&#233;f&#233;rentiel des engin du m&#233;tier (FishingMetierGearType) est maintenent
     * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des engins<br>
     * </p>
     * <p>
     * </p>
     * <p>
     * =&gt; Le r&#233;f&#233;rentiel des esp&#232;ces m&#233;tier (MetierSpecies) est maintenent
     * int&#233;gr&#233; au r&#233;f&#233;rentiel g&#233;n&#233;rique des groupes de taxon<br><br>
     * </p>
     * <p>
     * <u>V3 </u>:<br>- Le m&#233;tier de peche n'a pas forc&#233;ment d'engin
     * (optionnel) Ex : AQUNEP
     * </p>
     * <p>
     * (Aquaculture)<br>- le mn&#233;monique et le libell&#233; ne sont plus calcul&#233;s &#224;
     * la vol&#233;e par concat&#233;nation, pour permettre l'utilisation de libell&#233; plus
     * court..
     * </p>
     * </body>
     * </html>
     * @param metierIn Metier
     */
    public void setMetier(Metier metierIn)
    {
        this.metier = metierIn;
    }

    private Collection<GearUseMeasurement> gearUseMeasurements = new HashSet<GearUseMeasurement>();

    /**
     * 
     * @return this.gearUseMeasurements Collection<GearUseMeasurement>
     */
    public Collection<GearUseMeasurement> getGearUseMeasurements()
    {
        return this.gearUseMeasurements;
    }

    /**
     * 
     * @param gearUseMeasurementsIn Collection<GearUseMeasurement>
     */
    public void setGearUseMeasurements(Collection<GearUseMeasurement> gearUseMeasurementsIn)
    {
        this.gearUseMeasurements = gearUseMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd GearUseMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearUseMeasurements(GearUseMeasurement elementToAdd)
    {
        return this.gearUseMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove GearUseMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearUseMeasurements(GearUseMeasurement elementToRemove)
    {
        return this.gearUseMeasurements.remove(elementToRemove);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>UseFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.use.UseFeatures#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>UseFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.use.UseFeatures#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link GearUseFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link GearUseFeatures}.
         * @return new GearUseFeaturesImpl()
         */
        public static GearUseFeatures newInstance()
        {
            return new GearUseFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link GearUseFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param creationDate Date
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param rankOrder Short
         * @return newInstance
         */
        public static GearUseFeatures newInstance(Date creationDate, Program program, QualityFlag qualityFlag, Vessel vessel, Short rankOrder)
        {
            final GearUseFeatures entity = new GearUseFeaturesImpl();
            entity.setCreationDate(creationDate);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRankOrder(rankOrder);
            return entity;
        }

        /**
         * Constructs a new instance of {@link GearUseFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param rankOrder Short
         * @param economicalSurvey EconomicalSurvey
         * @param otherGear Gear
         * @param operation Operation
         * @param dailyActivityCalendar DailyActivityCalendar
         * @param activityCalendar ActivityCalendar
         * @param fishingEffortCalendar FishingEffortCalendar
         * @param fishingAreas Collection<FishingArea>
         * @param gear Gear
         * @param gearUseFeaturesOrigins Collection<GearUseFeaturesOrigin>
         * @param metier Metier
         * @param gearUseMeasurements Collection<GearUseMeasurement>
         * @return newInstance GearUseFeatures
         */
        public static GearUseFeatures newInstance(Date startDate, Date endDate, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Program program, QualityFlag qualityFlag, Vessel vessel, Short rankOrder, EconomicalSurvey economicalSurvey, Gear otherGear, Operation operation, DailyActivityCalendar dailyActivityCalendar, ActivityCalendar activityCalendar, FishingEffortCalendar fishingEffortCalendar, Collection<FishingArea> fishingAreas, Gear gear, Collection<GearUseFeaturesOrigin> gearUseFeaturesOrigins, Metier metier, Collection<GearUseMeasurement> gearUseMeasurements)
        {
            final GearUseFeatures entity = new GearUseFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRankOrder(rankOrder);
            entity.setEconomicalSurvey(economicalSurvey);
            entity.setOtherGear(otherGear);
            entity.setOperation(operation);
            entity.setDailyActivityCalendar(dailyActivityCalendar);
            entity.setActivityCalendar(activityCalendar);
            entity.setFishingEffortCalendar(fishingEffortCalendar);
            entity.setFishingAreas(fishingAreas);
            entity.setGear(gear);
            entity.setGearUseFeaturesOrigins(gearUseFeaturesOrigins);
            entity.setMetier(metier);
            entity.setGearUseMeasurements(gearUseMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(GearUseFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// GearUseFeatures.java merge-point
}