// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.physicalGear.PhysicalGearSurvey;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Caractéristiques d'un engin physique d'un navire (navire de peche ou océanographique, ou autres).
 * L'engin lié peut etre un engin de peche (Chalut, Filet, etc.) ou non (Sonde de température,
 * Sonar, etc.)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class GearPhysicalFeatures
    extends PhysicalFeaturesImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 3429047159329994353L;

    // Generate 1 attributes
    private Short rankOrder;

    /**
     * 
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * 
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    // Generate 7 associations
    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private Gear otherGear;

    /**
     * @deprecated utilisation à éviter (utilisé pour les migrations de données essentiellement)
     * @return this.otherGear Gear
     */
    public Gear getOtherGear()
    {
        return this.otherGear;
    }

    /**
     * @deprecated utilisation à éviter (utilisé pour les migrations de données essentiellement)
     * @param otherGearIn Gear
     */
    public void setOtherGear(Gear otherGearIn)
    {
        this.otherGear = otherGearIn;
    }

    private Collection<Operation> operations = new HashSet<Operation>();

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operations Collection<Operation>
     */
    public Collection<Operation> getOperations()
    {
        return this.operations;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationsIn Collection<Operation>
     */
    public void setOperations(Collection<Operation> operationsIn)
    {
        this.operations = operationsIn;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param elementToAdd Operation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addOperations(Operation elementToAdd)
    {
        return this.operations.add(elementToAdd);
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param elementToRemove Operation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeOperations(Operation elementToRemove)
    {
        return this.operations.remove(elementToRemove);
    }

    private PhysicalGearSurvey physicalGearSurvey;

    /**
     * Enquete sur les engins physiques d'un navire et leurs caractéristiques.
     * @return this.physicalGearSurvey PhysicalGearSurvey
     */
    public PhysicalGearSurvey getPhysicalGearSurvey()
    {
        return this.physicalGearSurvey;
    }

    /**
     * Enquete sur les engins physiques d'un navire et leurs caractéristiques.
     * @param physicalGearSurveyIn PhysicalGearSurvey
     */
    public void setPhysicalGearSurvey(PhysicalGearSurvey physicalGearSurveyIn)
    {
        this.physicalGearSurvey = physicalGearSurveyIn;
    }

    private Gear gear;

    /**
     * Engin du référentiel qui correspond à l'engin physique décrit par les caractéristiques.
     * @return this.gear Gear
     */
    public Gear getGear()
    {
        return this.gear;
    }

    /**
     * Engin du référentiel qui correspond à l'engin physique décrit par les caractéristiques.
     * @param gearIn Gear
     */
    public void setGear(Gear gearIn)
    {
        this.gear = gearIn;
    }

    private Collection<GearPhysicalFeaturesOrigin> gearPhysicalFeaturesOrigins = new HashSet<GearPhysicalFeaturesOrigin>();

    /**
     * 
     * @return this.gearPhysicalFeaturesOrigins Collection<GearPhysicalFeaturesOrigin>
     */
    public Collection<GearPhysicalFeaturesOrigin> getGearPhysicalFeaturesOrigins()
    {
        return this.gearPhysicalFeaturesOrigins;
    }

    /**
     * 
     * @param gearPhysicalFeaturesOriginsIn Collection<GearPhysicalFeaturesOrigin>
     */
    public void setGearPhysicalFeaturesOrigins(Collection<GearPhysicalFeaturesOrigin> gearPhysicalFeaturesOriginsIn)
    {
        this.gearPhysicalFeaturesOrigins = gearPhysicalFeaturesOriginsIn;
    }

    /**
     * 
     * @param elementToAdd GearPhysicalFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearPhysicalFeaturesOrigins(GearPhysicalFeaturesOrigin elementToAdd)
    {
        return this.gearPhysicalFeaturesOrigins.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove GearPhysicalFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearPhysicalFeaturesOrigins(GearPhysicalFeaturesOrigin elementToRemove)
    {
        return this.gearPhysicalFeaturesOrigins.remove(elementToRemove);
    }

    private Collection<GearPhysicalMeasurement> gearPhysicalMeasurements = new HashSet<GearPhysicalMeasurement>();

    /**
     * 
     * @return this.gearPhysicalMeasurements Collection<GearPhysicalMeasurement>
     */
    public Collection<GearPhysicalMeasurement> getGearPhysicalMeasurements()
    {
        return this.gearPhysicalMeasurements;
    }

    /**
     * 
     * @param gearPhysicalMeasurementsIn Collection<GearPhysicalMeasurement>
     */
    public void setGearPhysicalMeasurements(Collection<GearPhysicalMeasurement> gearPhysicalMeasurementsIn)
    {
        this.gearPhysicalMeasurements = gearPhysicalMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd GearPhysicalMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearPhysicalMeasurements(GearPhysicalMeasurement elementToAdd)
    {
        return this.gearPhysicalMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove GearPhysicalMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearPhysicalMeasurements(GearPhysicalMeasurement elementToRemove)
    {
        return this.gearPhysicalMeasurements.remove(elementToRemove);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>PhysicalFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.physical.PhysicalFeatures#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>PhysicalFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.physical.PhysicalFeatures#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link GearPhysicalFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link GearPhysicalFeatures}.
         * @return new GearPhysicalFeaturesImpl()
         */
        public static GearPhysicalFeatures newInstance()
        {
            return new GearPhysicalFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link GearPhysicalFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param creationDate Date
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param rankOrder Short
         * @param gear Gear
         * @return newInstance
         */
        public static GearPhysicalFeatures newInstance(Date creationDate, Program program, QualityFlag qualityFlag, Vessel vessel, Short rankOrder, Gear gear)
        {
            final GearPhysicalFeatures entity = new GearPhysicalFeaturesImpl();
            entity.setCreationDate(creationDate);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRankOrder(rankOrder);
            entity.setGear(gear);
            return entity;
        }

        /**
         * Constructs a new instance of {@link GearPhysicalFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param rankOrder Short
         * @param fishingTrip FishingTrip
         * @param otherGear Gear
         * @param operations Collection<Operation>
         * @param physicalGearSurvey PhysicalGearSurvey
         * @param gear Gear
         * @param gearPhysicalFeaturesOrigins Collection<GearPhysicalFeaturesOrigin>
         * @param gearPhysicalMeasurements Collection<GearPhysicalMeasurement>
         * @return newInstance GearPhysicalFeatures
         */
        public static GearPhysicalFeatures newInstance(Date startDate, Date endDate, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Program program, QualityFlag qualityFlag, Vessel vessel, Short rankOrder, FishingTrip fishingTrip, Gear otherGear, Collection<Operation> operations, PhysicalGearSurvey physicalGearSurvey, Gear gear, Collection<GearPhysicalFeaturesOrigin> gearPhysicalFeaturesOrigins, Collection<GearPhysicalMeasurement> gearPhysicalMeasurements)
        {
            final GearPhysicalFeatures entity = new GearPhysicalFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRankOrder(rankOrder);
            entity.setFishingTrip(fishingTrip);
            entity.setOtherGear(otherGear);
            entity.setOperations(operations);
            entity.setPhysicalGearSurvey(physicalGearSurvey);
            entity.setGear(gear);
            entity.setGearPhysicalFeaturesOrigins(gearPhysicalFeaturesOrigins);
            entity.setGearPhysicalMeasurements(gearPhysicalMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(GearPhysicalFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// GearPhysicalFeatures.java merge-point
}