// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.util.Date;

/**
 * Définit le lieu d'immatriculation d'un navire statistique et la période associée.
 * Nombre de lignes : 72700
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselRegistrationPeriod
    implements Serializable, Comparable<VesselRegistrationPeriod>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1400358090358950484L;

    private VesselRegistrationPeriodPK vesselRegistrationPeriodPk;

    /**
     * Get the composite primary key identifier class
     * @return vesselRegistrationPeriodPk
     */
    public VesselRegistrationPeriodPK getVesselRegistrationPeriodPk()
    {
        return this.vesselRegistrationPeriodPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param vesselRegistrationPeriodPkIn
     */
    public void setVesselRegistrationPeriodPk(VesselRegistrationPeriodPK vesselRegistrationPeriodPkIn) {
        this.vesselRegistrationPeriodPk = vesselRegistrationPeriodPkIn;
    }

    // Generate 5 attributes
    /**
     * 
     * @return this.startDateTime Date
     */
    public Date getStartDateTime()
    {
        return this.getVesselRegistrationPeriodPk().getStartDateTime();
    }

    /**
     * 
     * @param startDateTimeIn Date
     */
    public void setStartDateTime(Date startDateTimeIn)
    {
        this.getVesselRegistrationPeriodPk().setStartDateTime(startDateTimeIn);
    }

    private Date endDateTime;

    /**
     * 
     * @return this.endDateTime Date
     */
    public Date getEndDateTime()
    {
        return this.endDateTime;
    }

    /**
     * 
     * @param endDateTimeIn Date
     */
    public void setEndDateTime(Date endDateTimeIn)
    {
        this.endDateTime = endDateTimeIn;
    }

    private String registrationCode;

    /**
     * Code d'immatriculation du navire, dans le lieu dans lequel il est enregistré.
     * Il s'agit dans la plupart des cas de l'immatriculation nationale du navire, qui peut varier
     * en cas de changement de pays.
     * @return this.registrationCode String
     */
    public String getRegistrationCode()
    {
        return this.registrationCode;
    }

    /**
     * Code d'immatriculation du navire, dans le lieu dans lequel il est enregistré.
     * Il s'agit dans la plupart des cas de l'immatriculation nationale du navire, qui peut varier
     * en cas de changement de pays.
     * @param registrationCodeIn String
     */
    public void setRegistrationCode(String registrationCodeIn)
    {
        this.registrationCode = registrationCodeIn;
    }

    private String internationalRegistrationCode;

    /**
     * Code d'immatriculation international.
     * Pour les navires européens, cela correspond au "Community Fishing-Fleet Register" (CFR code).
     * @return this.internationalRegistrationCode String
     */
    public String getInternationalRegistrationCode()
    {
        return this.internationalRegistrationCode;
    }

    /**
     * Code d'immatriculation international.
     * Pour les navires européens, cela correspond au "Community Fishing-Fleet Register" (CFR code).
     * @param internationalRegistrationCodeIn String
     */
    public void setInternationalRegistrationCode(String internationalRegistrationCodeIn)
    {
        this.internationalRegistrationCode = internationalRegistrationCodeIn;
    }

    private Short rankOrder;

    /**
     * 
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * 
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    // Generate 3 associations
    private Location registrationLocation;

    /**
     * Lieu d'immatriculation.
     * Peut etre un pays (=pavillon), un quartier d'immatriculation (QIM, pour la France), ou port
     * d'immatriculation (pour le Maroc).
     * @return this.registrationLocation Location
     */
    public Location getRegistrationLocation()
    {
        return this.registrationLocation;
    }

    /**
     * Lieu d'immatriculation.
     * Peut etre un pays (=pavillon), un quartier d'immatriculation (QIM, pour la France), ou port
     * d'immatriculation (pour le Maroc).
     * @param registrationLocationIn Location
     */
    public void setRegistrationLocation(Location registrationLocationIn)
    {
        this.registrationLocation = registrationLocationIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    /**
     * Returns <code>true</code> if the argument is an VesselRegistrationPeriod instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof VesselRegistrationPeriod))
        {
            return false;
        }
        final VesselRegistrationPeriod that = (VesselRegistrationPeriod)object;
        if (this.vesselRegistrationPeriodPk == null || that.vesselRegistrationPeriodPk == null || !this.vesselRegistrationPeriodPk.equals(that.vesselRegistrationPeriodPk))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.vesselRegistrationPeriodPk == null ? 0 : this.vesselRegistrationPeriodPk.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link VesselRegistrationPeriod}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselRegistrationPeriod}.
         * @return new VesselRegistrationPeriodImpl()
         */
        public static VesselRegistrationPeriod newInstance()
        {
            return new VesselRegistrationPeriodImpl();
        }

        /**
         * Constructs a new instance of {@link VesselRegistrationPeriod}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param rankOrder Short
         * @param registrationLocation Location
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance
         */
        public static VesselRegistrationPeriod newInstance(Short rankOrder, Location registrationLocation, QualityFlag qualityFlag, Vessel vessel)
        {
            final VesselRegistrationPeriod entity = new VesselRegistrationPeriodImpl();
            entity.setRankOrder(rankOrder);
            entity.setRegistrationLocation(registrationLocation);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselRegistrationPeriod}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param endDateTime Date
         * @param registrationCode String
         * @param internationalRegistrationCode String
         * @param rankOrder Short
         * @param registrationLocation Location
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance VesselRegistrationPeriod
         */
        public static VesselRegistrationPeriod newInstance(Date endDateTime, String registrationCode, String internationalRegistrationCode, Short rankOrder, Location registrationLocation, QualityFlag qualityFlag, Vessel vessel)
        {
            final VesselRegistrationPeriod entity = new VesselRegistrationPeriodImpl();
            entity.setEndDateTime(endDateTime);
            entity.setRegistrationCode(registrationCode);
            entity.setInternationalRegistrationCode(internationalRegistrationCode);
            entity.setRankOrder(rankOrder);
            entity.setRegistrationLocation(registrationLocation);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselRegistrationPeriod o)
    {
        int cmp = 0;
        if (this.getVesselRegistrationPeriodPk() != null)
        {
            cmp = this.getVesselRegistrationPeriodPk().compareTo(o.getVesselRegistrationPeriodPk());
        }
        else
        {
            if (this.getEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDateTime().compareTo(o.getEndDateTime()));
            }
            if (this.getRegistrationCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRegistrationCode().compareTo(o.getRegistrationCode()));
            }
            if (this.getInternationalRegistrationCode() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getInternationalRegistrationCode().compareTo(o.getInternationalRegistrationCode()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselRegistrationPeriod.java merge-point
}