// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.sale;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import java.io.Serializable;

/**
 * Définie l'origine d'une vente.
 * Par exemple, une vente recopié depuis une vente déclarée pour identifier le programme de la vente
 * qui à serie à copier les données.
 * il peut éventuellement y avoir plusieurs programme d'origine à la vente. Par exemple, cela
 * pourrait etre le cas de ventes reconstituées à partir de différentes sources de données...
 */
// HibernateEntity.vsl annotations merge-point
public abstract class SaleOrigin
    implements Serializable, Comparable<SaleOrigin>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -9154766544862036230L;

    private SaleOriginPK saleOriginPk;

    /**
     * Get the composite primary key identifier class
     * @return saleOriginPk
     */
    public SaleOriginPK getSaleOriginPk()
    {
        return this.saleOriginPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param saleOriginPkIn
     */
    public void setSaleOriginPk(SaleOriginPK saleOriginPkIn) {
        this.saleOriginPk = saleOriginPkIn;
    }

    // Generate 0 attributes
    // Generate 2 associations
    private Sale sale;

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @return this.sale Sale
     */
    public Sale getSale()
    {
        return this.sale;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param saleIn Sale
     */
    public void setSale(Sale saleIn)
    {
        this.sale = saleIn;
    }

    private Program program;

    /**
     * Identifie le progamme d'origine, ayant servi à constituer la vente (par Copier/coller,
     * consolidation, croisement, etc).
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Identifie le progamme d'origine, ayant servi à constituer la vente (par Copier/coller,
     * consolidation, croisement, etc).
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link SaleOrigin}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link SaleOrigin}.
         * @return new SaleOriginImpl()
         */
        public static SaleOrigin newInstance()
        {
            return new SaleOriginImpl();
        }


        /**
         * Constructs a new instance of {@link SaleOrigin}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param sale Sale
         * @param program Program
         * @return newInstance SaleOrigin
         */
        public static SaleOrigin newInstance(Sale sale, Program program)
        {
            final SaleOrigin entity = new SaleOriginImpl();
            entity.setSale(sale);
            entity.setProgram(program);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(SaleOrigin o)
    {
        int cmp = 0;
        if (this.getSaleOriginPk() != null)
        {
            cmp = this.getSaleOriginPk().compareTo(o.getSaleOriginPk());
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// SaleOrigin.java merge-point
}