// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.landing;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import fr.ifremer.adagio.core.dao.data.produce.Produce;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.landing.Landing
 */
@Repository("landingDao")
@Lazy
public class LandingDaoImpl
		extends LandingDaoBase {

	@Autowired
	private ObservedLandingDao observedLandingDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public LandingDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void remove(Collection<Landing> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"LandingDao.remove - 'entities' can not be null");
		}
		for (Landing landing : entities) {
			remove(landing);
		}
	}

	@Override
	public void remove(Landing landing) {
		if (landing instanceof ObservedLanding) {
			observedLandingDao.remove((ObservedLanding) landing);
			return;
		}

		if (CollectionUtils.isNotEmpty(landing.getProduces())) {
			for (Produce produce : landing.getProduces()) {
				produce.getProduceQuantificationMeasurements().clear();
				produce.getProduceSortingMeasurements().clear();
				getSession().delete(produce);
			}
			landing.getProduces().clear();
			getSession().flush();
		}

		if (CollectionUtils.isNotEmpty(landing.getLandingMeasurements())) {
			landing.getLandingMeasurements().clear();
		}
		super.remove(landing);
	}
}