// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.fishingTrip;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.data.operation.OperationDao;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTripOrigin
 */
@Repository("fishingTripDao")
@Lazy
public class FishingTripDaoImpl
		extends FishingTripDaoBase {

	@Autowired
	private OperationDao operationDao;

	@Autowired
	private FishingOperationDao fishingOperationDao;

	@Autowired
	private ObservedFishingTripDao observedFishingTripDao;

	@Autowired
	private LandingDao landingDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public FishingTripDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void remove(FishingTrip fishingTrip) {

		if (fishingTrip instanceof FishingTripImpl) {
			FishingTripImpl ft = (FishingTripImpl) fishingTrip;

			if (CollectionUtils.isNotEmpty(ft.getFishingOperations())) {
				fishingOperationDao.remove(ft.getFishingOperations());
				ft.getFishingOperations().clear();
				fishingTrip.getOperations().removeAll(ft.getFishingOperations());
			}
		}

		if (CollectionUtils.isNotEmpty(fishingTrip.getOperations())) {
			operationDao.remove(fishingTrip.getOperations());
		}

		if (CollectionUtils.isNotEmpty(fishingTrip.getLandings())) {
			landingDao.remove(fishingTrip.getLandings());
			fishingTrip.getLandings().clear();
		}

		if (CollectionUtils.isNotEmpty(fishingTrip.getVesselUseFeatures())) {
			for (VesselUseFeatures vesselUseFeatures : fishingTrip.getVesselUseFeatures()) {

				vesselUseFeatures.setOperation(null);
				vesselUseFeatures.getVesselUseMeasurements().clear();
			}
			// must remove all features content before removing them (data integrity will then failed otherwise)
			getSession().flush();
			fishingTrip.getVesselUseFeatures().clear();
		}

		super.remove(fishingTrip);
	}
}