// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.fishingTrip;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.declaration.DeclaredDocumentReference;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.transshipment.Transshipment;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique ou
 * une marée d'un navire professionnel, etc.)
 * Un voyage peut représenter type de données :
 * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche professionnelle au
 * cours de laquelle des relevés sont effectués par un observateur.
 * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
 * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
 * peche)
 * - une sortie effectuée lors d"une campagne scientifique
 */
// HibernateEntity.vsl annotations merge-point
public abstract class FishingTrip
    implements Serializable, Comparable<FishingTrip>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4441583382052532446L;

    // Generate 13 attributes
    private Integer id;

    /**
     * Identifiant du voyage. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant du voyage. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private Date departureDateTime;

    /**
     * Date (et heure) de départ du voyage.
     * @return this.departureDateTime Date
     */
    public Date getDepartureDateTime()
    {
        return this.departureDateTime;
    }

    /**
     * Date (et heure) de départ du voyage.
     * @param departureDateTimeIn Date
     */
    public void setDepartureDateTime(Date departureDateTimeIn)
    {
        this.departureDateTime = departureDateTimeIn;
    }

    private Date returnDateTime;

    /**
     * Date (et heure) du retour du voyage
     * @return this.returnDateTime Date
     */
    public Date getReturnDateTime()
    {
        return this.returnDateTime;
    }

    /**
     * Date (et heure) du retour du voyage
     * @param returnDateTimeIn Date
     */
    public void setReturnDateTime(Date returnDateTimeIn)
    {
        this.returnDateTime = returnDateTimeIn;
    }

    private String position;

    /**
     * 
     * @return this.position String
     */
    public String getPosition()
    {
        return this.position;
    }

    /**
     * 
     * @param positionIn String
     */
    public void setPosition(String positionIn)
    {
        this.position = positionIn;
    }

    private String comments;

    /**
     * Commentaire sur le voyage en mer.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur le voyage en mer.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 21 associations
    private Location returnLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.returnLocation Location
     */
    public Location getReturnLocation()
    {
        return this.returnLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param returnLocationIn Location
     */
    public void setReturnLocation(Location returnLocationIn)
    {
        this.returnLocation = returnLocationIn;
    }

    private Location departureLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.departureLocation Location
     */
    public Location getDepartureLocation()
    {
        return this.departureLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param departureLocationIn Location
     */
    public void setDepartureLocation(Location departureLocationIn)
    {
        this.departureLocation = departureLocationIn;
    }

    private Collection<VesselPersonFeatures> vesselPersonFeatures = new HashSet<VesselPersonFeatures>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @return this.vesselPersonFeatures Collection<VesselPersonFeatures>
     */
    public Collection<VesselPersonFeatures> getVesselPersonFeatures()
    {
        return this.vesselPersonFeatures;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param vesselPersonFeaturesIn Collection<VesselPersonFeatures>
     */
    public void setVesselPersonFeatures(Collection<VesselPersonFeatures> vesselPersonFeaturesIn)
    {
        this.vesselPersonFeatures = vesselPersonFeaturesIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd VesselPersonFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPersonFeatures(VesselPersonFeatures elementToAdd)
    {
        return this.vesselPersonFeatures.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove VesselPersonFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPersonFeatures(VesselPersonFeatures elementToRemove)
    {
        return this.vesselPersonFeatures.remove(elementToRemove);
    }

    private Department recorderDepartment;

    /**
     * Service saisisseur
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service saisisseur
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Collection<Operation> operations = new HashSet<Operation>();

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operations Collection<Operation>
     */
    public Collection<Operation> getOperations()
    {
        return this.operations;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationsIn Collection<Operation>
     */
    public void setOperations(Collection<Operation> operationsIn)
    {
        this.operations = operationsIn;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param elementToAdd Operation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addOperations(Operation elementToAdd)
    {
        return this.operations.add(elementToAdd);
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param elementToRemove Operation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeOperations(Operation elementToRemove)
    {
        return this.operations.remove(elementToRemove);
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<FishingTripOrigin> fishingTripOrigins = new HashSet<FishingTripOrigin>();

    /**
     * Définie l'origine d'un marée.
     * Par exemple, Une marée reconstituée peut provenir d'un calcul à partir des données VMS
     * recoupée à
     * partir des données de vente.
     * Il peut y avoir autant de FishingTripOrigin que de marées d'origine (marées sources).
     * @return this.fishingTripOrigins Collection<FishingTripOrigin>
     */
    public Collection<FishingTripOrigin> getFishingTripOrigins()
    {
        return this.fishingTripOrigins;
    }

    /**
     * Définie l'origine d'un marée.
     * Par exemple, Une marée reconstituée peut provenir d'un calcul à partir des données VMS
     * recoupée à
     * partir des données de vente.
     * Il peut y avoir autant de FishingTripOrigin que de marées d'origine (marées sources).
     * @param fishingTripOriginsIn Collection<FishingTripOrigin>
     */
    public void setFishingTripOrigins(Collection<FishingTripOrigin> fishingTripOriginsIn)
    {
        this.fishingTripOrigins = fishingTripOriginsIn;
    }

    /**
     * Définie l'origine d'un marée.
     * Par exemple, Une marée reconstituée peut provenir d'un calcul à partir des données VMS
     * recoupée à
     * partir des données de vente.
     * Il peut y avoir autant de FishingTripOrigin que de marées d'origine (marées sources).
     * @param elementToAdd FishingTripOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingTripOrigins(FishingTripOrigin elementToAdd)
    {
        return this.fishingTripOrigins.add(elementToAdd);
    }

    /**
     * Définie l'origine d'un marée.
     * Par exemple, Une marée reconstituée peut provenir d'un calcul à partir des données VMS
     * recoupée à
     * partir des données de vente.
     * Il peut y avoir autant de FishingTripOrigin que de marées d'origine (marées sources).
     * @param elementToRemove FishingTripOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingTripOrigins(FishingTripOrigin elementToRemove)
    {
        return this.fishingTripOrigins.remove(elementToRemove);
    }

    private Program program;

    /**
     * Origine des données de la marée.
     * Exemple :
     * - marées observée en mer,
     * - marées observée au débarquement,
     * - marées reconstituée
     * - marées déclarées recues par SACAPT
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Origine des données de la marée.
     * Exemple :
     * - marées observée en mer,
     * - marées observée au débarquement,
     * - marées reconstituée
     * - marées déclarées recues par SACAPT
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Collection<Sale> sales = new HashSet<Sale>();

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @return this.sales Collection<Sale>
     */
    public Collection<Sale> getSales()
    {
        return this.sales;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param salesIn Collection<Sale>
     */
    public void setSales(Collection<Sale> salesIn)
    {
        this.sales = salesIn;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param elementToAdd Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSales(Sale elementToAdd)
    {
        return this.sales.add(elementToAdd);
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param elementToRemove Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSales(Sale elementToRemove)
    {
        return this.sales.remove(elementToRemove);
    }

    private ScientificCruise scientificCruise;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Campagne scientifique.
     * </p>
     * <p>
     * <br><u>D&#233;finiition :</u>
     * </p>
     * <p>
     * </p>
     * <p>
     * The period of time during which a scientific research vessel is operated
     * in furtherance of a scientific research project, beginning when the
     * vessel leaves port to undertake the project and ending when the vessel
     * completes the project as provided for in the applicable scientific
     * research plan.
     * </p>
     * <p>
     * </p>
     * <p>
     * <i>US Dept. of Commerce (1996):
     * http://caldera.sero.nmfs.gov/fishery/regs/inter600.htm#B</i>
     * </p>
     * </body>
     * </html>
     * @return this.scientificCruise ScientificCruise
     */
    public ScientificCruise getScientificCruise()
    {
        return this.scientificCruise;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Campagne scientifique.
     * </p>
     * <p>
     * <br><u>D&#233;finiition :</u>
     * </p>
     * <p>
     * </p>
     * <p>
     * The period of time during which a scientific research vessel is operated
     * in furtherance of a scientific research project, beginning when the
     * vessel leaves port to undertake the project and ending when the vessel
     * completes the project as provided for in the applicable scientific
     * research plan.
     * </p>
     * <p>
     * </p>
     * <p>
     * <i>US Dept. of Commerce (1996):
     * http://caldera.sero.nmfs.gov/fishery/regs/inter600.htm#B</i>
     * </p>
     * </body>
     * </html>
     * @param scientificCruiseIn ScientificCruise
     */
    public void setScientificCruise(ScientificCruise scientificCruiseIn)
    {
        this.scientificCruise = scientificCruiseIn;
    }

    private DeclaredDocumentReference declaredDocumentReference;

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @return this.declaredDocumentReference DeclaredDocumentReference
     */
    public DeclaredDocumentReference getDeclaredDocumentReference()
    {
        return this.declaredDocumentReference;
    }

    /**
     * Référence du document déclaratif. Utile pour les données issu du log book électronique (flux
     * SACAPT.)
     * @param declaredDocumentReferenceIn DeclaredDocumentReference
     */
    public void setDeclaredDocumentReference(DeclaredDocumentReference declaredDocumentReferenceIn)
    {
        this.declaredDocumentReference = declaredDocumentReferenceIn;
    }

    private Collection<Landing> landings = new HashSet<Landing>();

    /**
     * Débarquement à la suite d'une marée en mer.
     * @return this.landings Collection<Landing>
     */
    public Collection<Landing> getLandings()
    {
        return this.landings;
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param landingsIn Collection<Landing>
     */
    public void setLandings(Collection<Landing> landingsIn)
    {
        this.landings = landingsIn;
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param elementToAdd Landing
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLandings(Landing elementToAdd)
    {
        return this.landings.add(elementToAdd);
    }

    /**
     * Débarquement à la suite d'une marée en mer.
     * @param elementToRemove Landing
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLandings(Landing elementToRemove)
    {
        return this.landings.remove(elementToRemove);
    }

    private Collection<Transshipment> transshipments = new HashSet<Transshipment>();

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @return this.transshipments Collection<Transshipment>
     */
    public Collection<Transshipment> getTransshipments()
    {
        return this.transshipments;
    }

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @param transshipmentsIn Collection<Transshipment>
     */
    public void setTransshipments(Collection<Transshipment> transshipmentsIn)
    {
        this.transshipments = transshipmentsIn;
    }

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @param elementToAdd Transshipment
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTransshipments(Transshipment elementToAdd)
    {
        return this.transshipments.add(elementToAdd);
    }

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @param elementToRemove Transshipment
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTransshipments(Transshipment elementToRemove)
    {
        return this.transshipments.remove(elementToRemove);
    }

    private Collection<VesselUseFeatures> vesselUseFeatures = new HashSet<VesselUseFeatures>();

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @return this.vesselUseFeatures Collection<VesselUseFeatures>
     */
    public Collection<VesselUseFeatures> getVesselUseFeatures()
    {
        return this.vesselUseFeatures;
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param vesselUseFeaturesIn Collection<VesselUseFeatures>
     */
    public void setVesselUseFeatures(Collection<VesselUseFeatures> vesselUseFeaturesIn)
    {
        this.vesselUseFeatures = vesselUseFeaturesIn;
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param elementToAdd VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselUseFeatures(VesselUseFeatures elementToAdd)
    {
        return this.vesselUseFeatures.add(elementToAdd);
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param elementToRemove VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselUseFeatures(VesselUseFeatures elementToRemove)
    {
        return this.vesselUseFeatures.remove(elementToRemove);
    }

    private Collection<GearPhysicalFeatures> gearPhysicalFeatures = new HashSet<GearPhysicalFeatures>();

    /**
     * Caractéristiques d'un engin physique d'un navire (navire de peche ou océanographique, ou
     * autres).
     * L'engin lié peut etre un engin de peche (Chalut, Filet, etc.) ou non (Sonde de température,
     * Sonar,
     * etc.)
     * @return this.gearPhysicalFeatures Collection<GearPhysicalFeatures>
     */
    public Collection<GearPhysicalFeatures> getGearPhysicalFeatures()
    {
        return this.gearPhysicalFeatures;
    }

    /**
     * Caractéristiques d'un engin physique d'un navire (navire de peche ou océanographique, ou
     * autres).
     * L'engin lié peut etre un engin de peche (Chalut, Filet, etc.) ou non (Sonde de température,
     * Sonar,
     * etc.)
     * @param gearPhysicalFeaturesIn Collection<GearPhysicalFeatures>
     */
    public void setGearPhysicalFeatures(Collection<GearPhysicalFeatures> gearPhysicalFeaturesIn)
    {
        this.gearPhysicalFeatures = gearPhysicalFeaturesIn;
    }

    /**
     * Caractéristiques d'un engin physique d'un navire (navire de peche ou océanographique, ou
     * autres).
     * L'engin lié peut etre un engin de peche (Chalut, Filet, etc.) ou non (Sonde de température,
     * Sonar,
     * etc.)
     * @param elementToAdd GearPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearPhysicalFeatures(GearPhysicalFeatures elementToAdd)
    {
        return this.gearPhysicalFeatures.add(elementToAdd);
    }

    /**
     * Caractéristiques d'un engin physique d'un navire (navire de peche ou océanographique, ou
     * autres).
     * L'engin lié peut etre un engin de peche (Chalut, Filet, etc.) ou non (Sonde de température,
     * Sonar,
     * etc.)
     * @param elementToRemove GearPhysicalFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearPhysicalFeatures(GearPhysicalFeatures elementToRemove)
    {
        return this.gearPhysicalFeatures.remove(elementToRemove);
    }

    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an FishingTrip instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof FishingTrip))
        {
            return false;
        }
        final FishingTrip that = (FishingTrip)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link FishingTrip}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link FishingTrip}.
         * @return new FishingTripImpl()
         */
        public static FishingTrip newInstance()
        {
            return new FishingTripImpl();
        }

        /**
         * Constructs a new instance of {@link FishingTrip}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param qualityFlag QualityFlag
         * @param program Program
         * @param vessel Vessel
         * @return newInstance
         */
        public static FishingTrip newInstance(String synchronizationStatus, Date creationDate, Department recorderDepartment, QualityFlag qualityFlag, Program program, Vessel vessel)
        {
            final FishingTrip entity = new FishingTripImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setQualityFlag(qualityFlag);
            entity.setProgram(program);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link FishingTrip}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param departureDateTime Date
         * @param returnDateTime Date
         * @param position String
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param returnLocation Location
         * @param departureLocation Location
         * @param vesselPersonFeatures Collection<VesselPersonFeatures>
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param operations Collection<Operation>
         * @param qualityFlag QualityFlag
         * @param fishingTripOrigins Collection<FishingTripOrigin>
         * @param program Program
         * @param vessel Vessel
         * @param sales Collection<Sale>
         * @param scientificCruise ScientificCruise
         * @param declaredDocumentReference DeclaredDocumentReference
         * @param landings Collection<Landing>
         * @param transshipments Collection<Transshipment>
         * @param vesselUseFeatures Collection<VesselUseFeatures>
         * @param gearPhysicalFeatures Collection<GearPhysicalFeatures>
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @return newInstance FishingTrip
         */
        public static FishingTrip newInstance(String synchronizationStatus, Date departureDateTime, Date returnDateTime, String position, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Location returnLocation, Location departureLocation, Collection<VesselPersonFeatures> vesselPersonFeatures, Department recorderDepartment, Person recorderPerson, Collection<Operation> operations, QualityFlag qualityFlag, Collection<FishingTripOrigin> fishingTripOrigins, Program program, Vessel vessel, Collection<Sale> sales, ScientificCruise scientificCruise, DeclaredDocumentReference declaredDocumentReference, Collection<Landing> landings, Collection<Transshipment> transshipments, Collection<VesselUseFeatures> vesselUseFeatures, Collection<GearPhysicalFeatures> gearPhysicalFeatures, Collection<SurveyMeasurement> surveyMeasurements)
        {
            final FishingTrip entity = new FishingTripImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setDepartureDateTime(departureDateTime);
            entity.setReturnDateTime(returnDateTime);
            entity.setPosition(position);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setReturnLocation(returnLocation);
            entity.setDepartureLocation(departureLocation);
            entity.setVesselPersonFeatures(vesselPersonFeatures);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setOperations(operations);
            entity.setQualityFlag(qualityFlag);
            entity.setFishingTripOrigins(fishingTripOrigins);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setSales(sales);
            entity.setScientificCruise(scientificCruise);
            entity.setDeclaredDocumentReference(declaredDocumentReference);
            entity.setLandings(landings);
            entity.setTransshipments(transshipments);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            entity.setSurveyMeasurements(surveyMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(FishingTrip o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getDepartureDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDepartureDateTime().compareTo(o.getDepartureDateTime()));
            }
            if (this.getReturnDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReturnDateTime().compareTo(o.getReturnDateTime()));
            }
            if (this.getPosition() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPosition().compareTo(o.getPosition()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
private Collection<fr.ifremer.adagio.core.dao.data.operation.FishingOperation> fishingOperations = new HashSet<fr.ifremer.adagio.core.dao.data.operation.FishingOperation>();

	/**
	 * Usefull getter for fishing operations (cast to FishingOperation not need)
	 * @return this.fishingOperations Collection<fr.ifremer.adagio.core.dao.data.operation.FishingOperation>
	 */
	public Collection<fr.ifremer.adagio.core.dao.data.operation.FishingOperation> getFishingOperations() {
		return this.fishingOperations;
	}

	/**
	 * Usefull setter for fishing operations (cast to FishingOperation not need)
	 * @param fishingOperationsIn Collection<fr.ifremer.adagio.core.dao.data.operation.FishingOperation>
	 */
	public void setFishingOperations(Collection<fr.ifremer.adagio.core.dao.data.operation.FishingOperation> fishingOperationsIn) {
		this.fishingOperations = fishingOperationsIn;
	}
	
	// FishingTrip.java merge-point
}