// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.fishingEffort;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.activity.ActivityCalendar;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Enquete d'effort de peche (Calendrier d'effort de peche) d'un navire.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class FishingEffortCalendar
    implements Serializable, Comparable<FishingEffortCalendar>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -4228448136602896163L;

    // Generate 11 attributes
    private Integer id;

    /**
     * Identifiant interne de l'enquete d'effort de peche. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne de l'enquete d'effort de peche. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Integer year;

    /**
     * Année sur laquelle porte l'enquete
     * @return this.year Integer
     */
    public Integer getYear()
    {
        return this.year;
    }

    /**
     * Année sur laquelle porte l'enquete
     * @param yearIn Integer
     */
    public void setYear(Integer yearIn)
    {
        this.year = yearIn;
    }

    private Boolean directSurveyInvestigation;

    /**
     * Objectif d'enquete directe ?
     * Issu de la feuille de route (pointeur ‘ENQUETE DIRECTE’ de la feuille de route). Indique si
     * le navire était prévu en enquête directe ou non pour l'année de référence : Oui ou Non. Cette
     * information n'est jamais saisie par l'utilisateur, elle est issue d'un flux venant d'Harmonie
     * @return this.directSurveyInvestigation Boolean
     */
    public Boolean isDirectSurveyInvestigation()
    {
        return this.directSurveyInvestigation;
    }

    /**
     * Objectif d'enquete directe ?
     * Issu de la feuille de route (pointeur ‘ENQUETE DIRECTE’ de la feuille de route). Indique si
     * le navire était prévu en enquête directe ou non pour l'année de référence : Oui ou Non. Cette
     * information n'est jamais saisie par l'utilisateur, elle est issue d'un flux venant d'Harmonie
     * @param directSurveyInvestigationIn Boolean
     */
    public void setDirectSurveyInvestigation(Boolean directSurveyInvestigationIn)
    {
        this.directSurveyInvestigation = directSurveyInvestigationIn;
    }

    private String comments;

    /**
     * Commentaire sur l'enquete
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur l'enquete
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création de l'enquete dans le système central.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création de l'enquete dans le système central.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * Date de la dernière mise à jour dans le système central
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de la dernière mise à jour dans le système central
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 9 associations
    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * 
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * 
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    private Department recorderDepartment;

    /**
     * Service saisisseur
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service saisisseur
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private ActivityCalendar activityCalendar;

    /**
     * 
     * @return this.activityCalendar ActivityCalendar
     */
    public ActivityCalendar getActivityCalendar()
    {
        return this.activityCalendar;
    }

    /**
     * 
     * @param activityCalendarIn ActivityCalendar
     */
    public void setActivityCalendar(ActivityCalendar activityCalendarIn)
    {
        this.activityCalendar = activityCalendarIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire concerné par l'enquete
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire concerné par l'enquete
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<VesselUseFeatures> vesselUseFeatures = new HashSet<VesselUseFeatures>();

    /**
     * Liste des blocs d'effort (annuel ou mensuel, sur tous les métiers ou un seul, ou bien sur un
     * engin) receuillies au cours de l'enquete.
     * @return this.vesselUseFeatures Collection<VesselUseFeatures>
     */
    public Collection<VesselUseFeatures> getVesselUseFeatures()
    {
        return this.vesselUseFeatures;
    }

    /**
     * Liste des blocs d'effort (annuel ou mensuel, sur tous les métiers ou un seul, ou bien sur un
     * engin) receuillies au cours de l'enquete.
     * @param vesselUseFeaturesIn Collection<VesselUseFeatures>
     */
    public void setVesselUseFeatures(Collection<VesselUseFeatures> vesselUseFeaturesIn)
    {
        this.vesselUseFeatures = vesselUseFeaturesIn;
    }

    /**
     * Liste des blocs d'effort (annuel ou mensuel, sur tous les métiers ou un seul, ou bien sur un
     * engin) receuillies au cours de l'enquete.
     * @param elementToAdd VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselUseFeatures(VesselUseFeatures elementToAdd)
    {
        return this.vesselUseFeatures.add(elementToAdd);
    }

    /**
     * Liste des blocs d'effort (annuel ou mensuel, sur tous les métiers ou un seul, ou bien sur un
     * engin) receuillies au cours de l'enquete.
     * @param elementToRemove VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselUseFeatures(VesselUseFeatures elementToRemove)
    {
        return this.vesselUseFeatures.remove(elementToRemove);
    }

    private Collection<GearUseFeatures> gearUseFeatures = new HashSet<GearUseFeatures>();

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @return this.gearUseFeatures Collection<GearUseFeatures>
     */
    public Collection<GearUseFeatures> getGearUseFeatures()
    {
        return this.gearUseFeatures;
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param gearUseFeaturesIn Collection<GearUseFeatures>
     */
    public void setGearUseFeatures(Collection<GearUseFeatures> gearUseFeaturesIn)
    {
        this.gearUseFeatures = gearUseFeaturesIn;
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param elementToAdd GearUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearUseFeatures(GearUseFeatures elementToAdd)
    {
        return this.gearUseFeatures.add(elementToAdd);
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param elementToRemove GearUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearUseFeatures(GearUseFeatures elementToRemove)
    {
        return this.gearUseFeatures.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an FishingEffortCalendar instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof FishingEffortCalendar))
        {
            return false;
        }
        final FishingEffortCalendar that = (FishingEffortCalendar)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link FishingEffortCalendar}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link FishingEffortCalendar}.
         * @return new FishingEffortCalendarImpl()
         */
        public static FishingEffortCalendar newInstance()
        {
            return new FishingEffortCalendarImpl();
        }

        /**
         * Constructs a new instance of {@link FishingEffortCalendar}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param year Integer
         * @param directSurveyInvestigation Boolean
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param activityCalendar ActivityCalendar
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static FishingEffortCalendar newInstance(Integer year, Boolean directSurveyInvestigation, Date creationDate, Department recorderDepartment, ActivityCalendar activityCalendar, Program program, Vessel vessel, QualityFlag qualityFlag)
        {
            final FishingEffortCalendar entity = new FishingEffortCalendarImpl();
            entity.setYear(year);
            entity.setDirectSurveyInvestigation(directSurveyInvestigation);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setActivityCalendar(activityCalendar);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link FishingEffortCalendar}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param year Integer
         * @param directSurveyInvestigation Boolean
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param activityCalendar ActivityCalendar
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @param vesselUseFeatures Collection<VesselUseFeatures>
         * @param gearUseFeatures Collection<GearUseFeatures>
         * @return newInstance FishingEffortCalendar
         */
        public static FishingEffortCalendar newInstance(Integer year, Boolean directSurveyInvestigation, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Collection<SurveyMeasurement> surveyMeasurements, Department recorderDepartment, Person recorderPerson, ActivityCalendar activityCalendar, Program program, Vessel vessel, QualityFlag qualityFlag, Collection<VesselUseFeatures> vesselUseFeatures, Collection<GearUseFeatures> gearUseFeatures)
        {
            final FishingEffortCalendar entity = new FishingEffortCalendarImpl();
            entity.setYear(year);
            entity.setDirectSurveyInvestigation(directSurveyInvestigation);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setActivityCalendar(activityCalendar);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(FishingEffortCalendar o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getYear() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getYear().compareTo(o.getYear()));
            }
            if (this.isDirectSurveyInvestigation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isDirectSurveyInvestigation().compareTo(o.isDirectSurveyInvestigation()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// FishingEffortCalendar.java merge-point
}