// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.sample;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.Unit;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
 * d'un échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
 * pour analyse ou dénombrement.
 * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un débarquement
 * ou à une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de
 * provenance).
 * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le support
 * est, par exemple :
 * - crustacé (crevette...)
 * - poisson (merlu, sardine...)
 * - gastéropode (bigorneau, littorine...)
 * - echinoderme (oursin...)
 * - etc.
 * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de plusieurs
 * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
 * pourra identifié l'individu concerné par la mesure, par une numéro din'dividu.
 * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
 * prélèvement, permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour
 * la saisie des lectures d'age, etc..
 * Par exemple de prélèvement :
 * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes afin de
 * réaliser une lecture d'age.
 * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
 * - etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Sample
    implements Serializable, Comparable<Sample>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 6373831743220310610L;

    // Generate 14 attributes
    private Integer id;

    /**
     * Identifiant de l'échantillon. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant de l'échantillon. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * Mnémonique du prélèvement. Par exemple, il peut s'agir d'un code propre à chaque programme :
     * pour les marées observée, par exemple, il s'agira d'une étiquette permettant d'identifier
     * l'échantillon sur le terrain puis en laboratoire.
     * Autant que possible, le mnémonique devra etre unique pour tous le système, ou à défaut unique
     * au sein de la marée, du débarquement, de la vente ou de la campagne.
     * Nomenclature retenue à l'issu des spécifications Allegro V3 :
     * <date>_<initiales>_<lieu>_<G|S>_<numéro>
     * Avec :
     * - <date> : date de l’observation au format AAAMMJJ. La date est issue (suivant la donnée mère
     * rattachée) :
     * * de la date de début de l’opération de pêche ou du groupe d’opérations (si période du groupe
     * d’opération n’a pas été renseigné : prendre la date de début de la marée)
     * * ou de la date de débarquement,
     * * ou de la date de la vente.
     * - <initiales> : il s’agit des initiales déjà saisit par l’utilisateur (cf variante
     * précédente).
     * - <lieu> : mnémonique du lieu d’observation, si présent, ou libellé sinon. Le lieu
     * d’observation est issu (suivant la donnée mère rattachée) :
     * * pour une opération de pêche ou un groupe d’opérations, il s’agit du port de départ de la
     * marée,
     * * pour un débarquement, du lieu de débarquement
     * * pour une vente, du lieu de la vente
     * - <G|S> : suivant la donnée mère rattachée :
     * * ‘G’ (=Ground) si donnée mère rattachée est un débarquement ou une vente ;
     * * ‘S’ (=Sea) si donnée mère rattachée est une opération de pêche ou à une groupe
     * d’opérations.
     * - <numéro> : Il s’agit d’un numéro au format NNN (sur trois caractère. Exemple : « 001 »),
     * auto-incrémentée (valeur maximale connue + 1) de manière à être unique au sein de (suivant la
     * donnée mère rattachée) :
     * * la marée, si la donnée mère rattachée est une opération de pêche ou un groupe d’opérations
     * * ou du débarquement,
     * * ou de la vente
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * Mnémonique du prélèvement. Par exemple, il peut s'agir d'un code propre à chaque programme :
     * pour les marées observée, par exemple, il s'agira d'une étiquette permettant d'identifier
     * l'échantillon sur le terrain puis en laboratoire.
     * Autant que possible, le mnémonique devra etre unique pour tous le système, ou à défaut unique
     * au sein de la marée, du débarquement, de la vente ou de la campagne.
     * Nomenclature retenue à l'issu des spécifications Allegro V3 :
     * <date>_<initiales>_<lieu>_<G|S>_<numéro>
     * Avec :
     * - <date> : date de l’observation au format AAAMMJJ. La date est issue (suivant la donnée mère
     * rattachée) :
     * * de la date de début de l’opération de pêche ou du groupe d’opérations (si période du groupe
     * d’opération n’a pas été renseigné : prendre la date de début de la marée)
     * * ou de la date de débarquement,
     * * ou de la date de la vente.
     * - <initiales> : il s’agit des initiales déjà saisit par l’utilisateur (cf variante
     * précédente).
     * - <lieu> : mnémonique du lieu d’observation, si présent, ou libellé sinon. Le lieu
     * d’observation est issu (suivant la donnée mère rattachée) :
     * * pour une opération de pêche ou un groupe d’opérations, il s’agit du port de départ de la
     * marée,
     * * pour un débarquement, du lieu de débarquement
     * * pour une vente, du lieu de la vente
     * - <G|S> : suivant la donnée mère rattachée :
     * * ‘G’ (=Ground) si donnée mère rattachée est un débarquement ou une vente ;
     * * ‘S’ (=Sea) si donnée mère rattachée est une opération de pêche ou à une groupe
     * d’opérations.
     * - <numéro> : Il s’agit d’un numéro au format NNN (sur trois caractère. Exemple : « 001 »),
     * auto-incrémentée (valeur maximale connue + 1) de manière à être unique au sein de (suivant la
     * donnée mère rattachée) :
     * * la marée, si la donnée mère rattachée est une opération de pêche ou un groupe d’opérations
     * * ou du débarquement,
     * * ou de la vente
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private Date sampleDate;

    /**
     * Jour du prélèvement (heure optionnelle).
     * @return this.sampleDate Date
     */
    public Date getSampleDate()
    {
        return this.sampleDate;
    }

    /**
     * Jour du prélèvement (heure optionnelle).
     * @param sampleDateIn Date
     */
    public void setSampleDate(Date sampleDateIn)
    {
        this.sampleDate = sampleDateIn;
    }

    private Short individualCount;

    /**
     * Nombre d'individus constituant l'échantillon.
     * @return this.individualCount Short
     */
    public Short getIndividualCount()
    {
        return this.individualCount;
    }

    /**
     * Nombre d'individus constituant l'échantillon.
     * @param individualCountIn Short
     */
    public void setIndividualCount(Short individualCountIn)
    {
        this.individualCount = individualCountIn;
    }

    private Float size;

    /**
     * La taille de l'échantillon peut représenter une surface ou un volume suivant les cas. Il peut
     * aussi s'agir du nombre d'individus entrant dans l'homogénat.
     * @return this.size Float
     */
    public Float getSize()
    {
        return this.size;
    }

    /**
     * La taille de l'échantillon peut représenter une surface ou un volume suivant les cas. Il peut
     * aussi s'agir du nombre d'individus entrant dans l'homogénat.
     * @param sizeIn Float
     */
    public void setSize(Float sizeIn)
    {
        this.size = sizeIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private String comments;

    /**
     * Commentaire libre concernant l'échantillon.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire libre concernant l'échantillon.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 14 associations
    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();

    /**
     * Zone de peche du prélèvement (utilisé surtout dans le cas d'un prélèvement hors
     * marée/débarquement ou vente - exemple : prélèvement en poissonnerie)
     * @return this.fishingAreas Collection<FishingArea>
     */
    public Collection<FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    /**
     * Zone de peche du prélèvement (utilisé surtout dans le cas d'un prélèvement hors
     * marée/débarquement ou vente - exemple : prélèvement en poissonnerie)
     * @param fishingAreasIn Collection<FishingArea>
     */
    public void setFishingAreas(Collection<FishingArea> fishingAreasIn)
    {
        this.fishingAreas = fishingAreasIn;
    }

    /**
     * Zone de peche du prélèvement (utilisé surtout dans le cas d'un prélèvement hors
     * marée/débarquement ou vente - exemple : prélèvement en poissonnerie)
     * @param elementToAdd FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingAreas(FishingArea elementToAdd)
    {
        return this.fishingAreas.add(elementToAdd);
    }

    /**
     * Zone de peche du prélèvement (utilisé surtout dans le cas d'un prélèvement hors
     * marée/débarquement ou vente - exemple : prélèvement en poissonnerie)
     * @param elementToRemove FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingAreas(FishingArea elementToRemove)
    {
        return this.fishingAreas.remove(elementToRemove);
    }

    private Unit sizeUnit;

    /**
     * Unité associée à la valeur de la taille du prélèvement.
     * @return this.sizeUnit Unit
     */
    public Unit getSizeUnit()
    {
        return this.sizeUnit;
    }

    /**
     * Unité associée à la valeur de la taille du prélèvement.
     * @param sizeUnitIn Unit
     */
    public void setSizeUnit(Unit sizeUnitIn)
    {
        this.sizeUnit = sizeUnitIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Collection<Sample> childSamples = new HashSet<Sample>();

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @return this.childSamples Collection<Sample>
     */
    public Collection<Sample> getChildSamples()
    {
        return this.childSamples;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param childSamplesIn Collection<Sample>
     */
    public void setChildSamples(Collection<Sample> childSamplesIn)
    {
        this.childSamples = childSamplesIn;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param elementToAdd Sample
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addChildSamples(Sample elementToAdd)
    {
        return this.childSamples.add(elementToAdd);
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param elementToRemove Sample
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeChildSamples(Sample elementToRemove)
    {
        return this.childSamples.remove(elementToRemove);
    }

    private Sample parentSample;

    /**
     * Parent sample. Use in MerluMed.
     * Ex : un poisson peut avoir dans sont estomac plusieurs autres poissons.
     * @return this.parentSample Sample
     */
    public Sample getParentSample()
    {
        return this.parentSample;
    }

    /**
     * Parent sample. Use in MerluMed.
     * Ex : un poisson peut avoir dans sont estomac plusieurs autres poissons.
     * @param parentSampleIn Sample
     */
    public void setParentSample(Sample parentSampleIn)
    {
        this.parentSample = parentSampleIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Matrix matrix;

    /**
     * Support de l'échantillon.
     * @return this.matrix Matrix
     */
    public Matrix getMatrix()
    {
        return this.matrix;
    }

    /**
     * Support de l'échantillon.
     * @param matrixIn Matrix
     */
    public void setMatrix(Matrix matrixIn)
    {
        this.matrix = matrixIn;
    }

    private ReferenceTaxon referenceTaxon;

    /**
     * Taxon (espèce scientifique) caractéristant l'échantillon (optionnel)
     * @return this.referenceTaxon ReferenceTaxon
     */
    public ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    /**
     * Taxon (espèce scientifique) caractéristant l'échantillon (optionnel)
     * @param referenceTaxonIn ReferenceTaxon
     */
    public void setReferenceTaxon(ReferenceTaxon referenceTaxonIn)
    {
        this.referenceTaxon = referenceTaxonIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private TaxonGroup taxonGroup;

    /**
     * Groupe de taxon (généralement espèce commerciale) caractéristant l'échantillon (optionnel)
     * @return this.taxonGroup TaxonGroup
     */
    public TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    /**
     * Groupe de taxon (généralement espèce commerciale) caractéristant l'échantillon (optionnel)
     * @param taxonGroupIn TaxonGroup
     */
    public void setTaxonGroup(TaxonGroup taxonGroupIn)
    {
        this.taxonGroup = taxonGroupIn;
    }

    private Batch batch;

    /**
     * Lot auquel appartient l'échantillon analysé (optionnel).
     * @return this.batch Batch
     */
    public Batch getBatch()
    {
        return this.batch;
    }

    /**
     * Lot auquel appartient l'échantillon analysé (optionnel).
     * @param batchIn Batch
     */
    public void setBatch(Batch batchIn)
    {
        this.batch = batchIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private FishingOperation fishingOperation;

    /**
     * Opération de prélèvement à laquelle est rattaché l'échantillon analysé.
     * @return this.fishingOperation FishingOperation
     */
    public FishingOperation getFishingOperation()
    {
        return this.fishingOperation;
    }

    /**
     * Opération de prélèvement à laquelle est rattaché l'échantillon analysé.
     * @param fishingOperationIn FishingOperation
     */
    public void setFishingOperation(FishingOperation fishingOperationIn)
    {
        this.fishingOperation = fishingOperationIn;
    }

    private Collection<SampleMeasurement> sampleMeasurements = new HashSet<SampleMeasurement>();

    /**
     * Valeur mesurée ou analysée sur un individu (résultats de mesures sur individu) appartenant à
     * un
     * prélèvement effectué lors d'un échantillonnage biologique, lors d'une marée, d'un vente ou
     * d'un
     * débarquement observé. Les observations sur le prélèvement sont souvent menées en laboratoire,
     * à
     * terre.
     * @return this.sampleMeasurements Collection<SampleMeasurement>
     */
    public Collection<SampleMeasurement> getSampleMeasurements()
    {
        return this.sampleMeasurements;
    }

    /**
     * Valeur mesurée ou analysée sur un individu (résultats de mesures sur individu) appartenant à
     * un
     * prélèvement effectué lors d'un échantillonnage biologique, lors d'une marée, d'un vente ou
     * d'un
     * débarquement observé. Les observations sur le prélèvement sont souvent menées en laboratoire,
     * à
     * terre.
     * @param sampleMeasurementsIn Collection<SampleMeasurement>
     */
    public void setSampleMeasurements(Collection<SampleMeasurement> sampleMeasurementsIn)
    {
        this.sampleMeasurements = sampleMeasurementsIn;
    }

    /**
     * Valeur mesurée ou analysée sur un individu (résultats de mesures sur individu) appartenant à
     * un
     * prélèvement effectué lors d'un échantillonnage biologique, lors d'une marée, d'un vente ou
     * d'un
     * débarquement observé. Les observations sur le prélèvement sont souvent menées en laboratoire,
     * à
     * terre.
     * @param elementToAdd SampleMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSampleMeasurements(SampleMeasurement elementToAdd)
    {
        return this.sampleMeasurements.add(elementToAdd);
    }

    /**
     * Valeur mesurée ou analysée sur un individu (résultats de mesures sur individu) appartenant à
     * un
     * prélèvement effectué lors d'un échantillonnage biologique, lors d'une marée, d'un vente ou
     * d'un
     * débarquement observé. Les observations sur le prélèvement sont souvent menées en laboratoire,
     * à
     * terre.
     * @param elementToRemove SampleMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSampleMeasurements(SampleMeasurement elementToRemove)
    {
        return this.sampleMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Sample instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Sample))
        {
            return false;
        }
        final Sample that = (Sample)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Sample}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Sample}.
         * @return new SampleImpl()
         */
        public static Sample newInstance()
        {
            return new SampleImpl();
        }

        /**
         * Constructs a new instance of {@link Sample}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param label String
         * @param synchronizationStatus String
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param matrix Matrix
         * @param program Program
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static Sample newInstance(String label, String synchronizationStatus, Date creationDate, Department recorderDepartment, Matrix matrix, Program program, QualityFlag qualityFlag)
        {
            final Sample entity = new SampleImpl();
            entity.setLabel(label);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setMatrix(matrix);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Sample}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param sampleDate Date
         * @param individualCount Short
         * @param size Float
         * @param synchronizationStatus String
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param fishingAreas Collection<FishingArea>
         * @param sizeUnit Unit
         * @param recorderDepartment Department
         * @param childSamples Collection<Sample>
         * @param parentSample Sample
         * @param recorderPerson Person
         * @param matrix Matrix
         * @param referenceTaxon ReferenceTaxon
         * @param program Program
         * @param taxonGroup TaxonGroup
         * @param batch Batch
         * @param qualityFlag QualityFlag
         * @param fishingOperation FishingOperation
         * @param sampleMeasurements Collection<SampleMeasurement>
         * @return newInstance Sample
         */
        public static Sample newInstance(String label, Date sampleDate, Short individualCount, Float size, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Collection<FishingArea> fishingAreas, Unit sizeUnit, Department recorderDepartment, Collection<Sample> childSamples, Sample parentSample, Person recorderPerson, Matrix matrix, ReferenceTaxon referenceTaxon, Program program, TaxonGroup taxonGroup, Batch batch, QualityFlag qualityFlag, FishingOperation fishingOperation, Collection<SampleMeasurement> sampleMeasurements)
        {
            final Sample entity = new SampleImpl();
            entity.setLabel(label);
            entity.setSampleDate(sampleDate);
            entity.setIndividualCount(individualCount);
            entity.setSize(size);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setFishingAreas(fishingAreas);
            entity.setSizeUnit(sizeUnit);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setChildSamples(childSamples);
            entity.setParentSample(parentSample);
            entity.setRecorderPerson(recorderPerson);
            entity.setMatrix(matrix);
            entity.setReferenceTaxon(referenceTaxon);
            entity.setProgram(program);
            entity.setTaxonGroup(taxonGroup);
            entity.setBatch(batch);
            entity.setQualityFlag(qualityFlag);
            entity.setFishingOperation(fishingOperation);
            entity.setSampleMeasurements(sampleMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Sample o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getSampleDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSampleDate().compareTo(o.getSampleDate()));
            }
            if (this.getIndividualCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIndividualCount().compareTo(o.getIndividualCount()));
            }
            if (this.getSize() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSize().compareTo(o.getSize()));
            }
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Sample.java merge-point
}