// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.operation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
 * campagne en mer,  marée déclarée, etc.).
 * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
 * mer, le navire peut déployer des engins de collecte de données environnementales (température,
 * salinité, etc. ).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Operation
    implements Serializable, Comparable<Operation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 871820309472336247L;

    // Generate 13 attributes
    private Integer id;

    /**
     * Identifiant unique de l'opération.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique de l'opération.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * @deprecated - NE PLUS UTILISER
     * Libellé de l'opération.
     * REMARQUE : attribut absent des IHM. Présent pour les données historiques. Sans doute à
     * supprimer dans l'avenir.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * @deprecated - NE PLUS UTILISER
     * Libellé de l'opération.
     * REMARQUE : attribut absent des IHM. Présent pour les données historiques. Sans doute à
     * supprimer dans l'avenir.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Short rankOrderOnPeriod;

    /**
     * Rang (de présentation) de l'opération, sur la période date début/fin.
     * ATTENTION : Lorsque plusieurs opérations sont présentes sur la meme période, cela permet de
     * les dissocier.
     * C'est par exemple le cas des séquences de peches (opérations agrégées en Jour/Métier/Secteur)
     * : plusieurs opérations peuvent etre sur le meme jour (avec des engin/secteur différents), il
     * faut donc leur attribuer un rang, pour les distinguer. Ce rang peut etre celui de la
     * déclaration du pecheur (ordre de saisie), ou bien un ordre quelconque.
     * Dans Allegro, ce rang sera utilisé pour ordonner ces opérations entre elles, dans les listes
     * qui les représentent. S'il est absent, seule la date de début est utilisée pour cela.
     * @return this.rankOrderOnPeriod Short
     */
    public Short getRankOrderOnPeriod()
    {
        return this.rankOrderOnPeriod;
    }

    /**
     * Rang (de présentation) de l'opération, sur la période date début/fin.
     * ATTENTION : Lorsque plusieurs opérations sont présentes sur la meme période, cela permet de
     * les dissocier.
     * C'est par exemple le cas des séquences de peches (opérations agrégées en Jour/Métier/Secteur)
     * : plusieurs opérations peuvent etre sur le meme jour (avec des engin/secteur différents), il
     * faut donc leur attribuer un rang, pour les distinguer. Ce rang peut etre celui de la
     * déclaration du pecheur (ordre de saisie), ou bien un ordre quelconque.
     * Dans Allegro, ce rang sera utilisé pour ordonner ces opérations entre elles, dans les listes
     * qui les représentent. S'il est absent, seule la date de début est utilisée pour cela.
     * @param rankOrderOnPeriodIn Short
     */
    public void setRankOrderOnPeriod(Short rankOrderOnPeriodIn)
    {
        this.rankOrderOnPeriod = rankOrderOnPeriodIn;
    }

    private Date startDateTime;

    /**
     * Date/heure de début de l'opération
     * @return this.startDateTime Date
     */
    public Date getStartDateTime()
    {
        return this.startDateTime;
    }

    /**
     * Date/heure de début de l'opération
     * @param startDateTimeIn Date
     */
    public void setStartDateTime(Date startDateTimeIn)
    {
        this.startDateTime = startDateTimeIn;
    }

    private Date endDateTime;

    /**
     * Date/heure de fin de l'opération
     * @return this.endDateTime Date
     */
    public Date getEndDateTime()
    {
        return this.endDateTime;
    }

    /**
     * Date/heure de fin de l'opération
     * @param endDateTimeIn Date
     */
    public void setEndDateTime(Date endDateTimeIn)
    {
        this.endDateTime = endDateTimeIn;
    }

    private Boolean isMainOperation;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Indique s'il s'agit d'une op&#233;ration ou d'un groupe d'op&#233;rations
     * &quot;principal&quot;.
     * </p>
     * <p>
     * Cela est utilis&#233; notamment quand on ne connait que l'activit&#233; principale
     * (le m&#233;tier) d'un navire. On parle alors de m&#233;trier principal.
     * <br>    </p>
     * <p>
     * </p>
     * <p>
     * G&#233;n&#233;ralement, cet atrribut est utilis&#233; pour des groupes d'op&#233;rations
     * (<i>rankOrderOnPerod
     * is not null</i>), pou identifier sur la mar&#233;e ou une journ&#233;e de peche,
     * le groupe d'op&#233;ration portant le m&#233;tier principal de la mar&#233;e ou de la
     * journ&#233;e.
     * </p>
     * </body>
     * </html>
     * @return this.isMainOperation Boolean
     */
    public Boolean getIsMainOperation()
    {
        return this.isMainOperation;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Indique s'il s'agit d'une op&#233;ration ou d'un groupe d'op&#233;rations
     * &quot;principal&quot;.
     * </p>
     * <p>
     * Cela est utilis&#233; notamment quand on ne connait que l'activit&#233; principale
     * (le m&#233;tier) d'un navire. On parle alors de m&#233;trier principal.
     * <br>    </p>
     * <p>
     * </p>
     * <p>
     * G&#233;n&#233;ralement, cet atrribut est utilis&#233; pour des groupes d'op&#233;rations
     * (<i>rankOrderOnPerod
     * is not null</i>), pou identifier sur la mar&#233;e ou une journ&#233;e de peche,
     * le groupe d'op&#233;ration portant le m&#233;tier principal de la mar&#233;e ou de la
     * journ&#233;e.
     * </p>
     * </body>
     * </html>
     * @param isMainOperationIn Boolean
     */
    public void setIsMainOperation(Boolean isMainOperationIn)
    {
        this.isMainOperation = isMainOperationIn;
    }

    private String position;

    /**
     * Géométrie de l'opération.
     * Ce champ est optionnel pour etre compatible avec uDIG/geotools.
     * @return this.position String
     */
    public String getPosition()
    {
        return this.position;
    }

    /**
     * Géométrie de l'opération.
     * Ce champ est optionnel pour etre compatible avec uDIG/geotools.
     * @param positionIn String
     */
    public void setPosition(String positionIn)
    {
        this.position = positionIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 10 associations
    private Collection<VesselPersonFeatures> vesselPersonFeatures = new HashSet<VesselPersonFeatures>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @return this.vesselPersonFeatures Collection<VesselPersonFeatures>
     */
    public Collection<VesselPersonFeatures> getVesselPersonFeatures()
    {
        return this.vesselPersonFeatures;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param vesselPersonFeaturesIn Collection<VesselPersonFeatures>
     */
    public void setVesselPersonFeatures(Collection<VesselPersonFeatures> vesselPersonFeaturesIn)
    {
        this.vesselPersonFeatures = vesselPersonFeaturesIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd VesselPersonFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPersonFeatures(VesselPersonFeatures elementToAdd)
    {
        return this.vesselPersonFeatures.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Caractéristiques d'une personne physique en relation avec un Vessel
     * (usager), pour une période.
     * </p>
     * <p>
     * </p>
     * <p>
     * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
     * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
     * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
     * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove VesselPersonFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPersonFeatures(VesselPersonFeatures elementToRemove)
    {
        return this.vesselPersonFeatures.remove(elementToRemove);
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Collection<OperationVesselAssociation> operationVesselAssociations = new HashSet<OperationVesselAssociation>();

    /**
     * Informations permet de décrire, par exemple la stratégie de répartition entre le navire
     * observé et
     * le navire associé pour l'opération.
     * En effet, des navires travaillent en paires (ou en bœufs), par exemple pour tirer à deux un
     * meme
     * chalut.
     * note : Il peut s'agir d'un navire temporaire.
     * @return this.operationVesselAssociations Collection<OperationVesselAssociation>
     */
    public Collection<OperationVesselAssociation> getOperationVesselAssociations()
    {
        return this.operationVesselAssociations;
    }

    /**
     * Informations permet de décrire, par exemple la stratégie de répartition entre le navire
     * observé et
     * le navire associé pour l'opération.
     * En effet, des navires travaillent en paires (ou en bœufs), par exemple pour tirer à deux un
     * meme
     * chalut.
     * note : Il peut s'agir d'un navire temporaire.
     * @param operationVesselAssociationsIn Collection<OperationVesselAssociation>
     */
    public void setOperationVesselAssociations(Collection<OperationVesselAssociation> operationVesselAssociationsIn)
    {
        this.operationVesselAssociations = operationVesselAssociationsIn;
    }

    /**
     * Informations permet de décrire, par exemple la stratégie de répartition entre le navire
     * observé et
     * le navire associé pour l'opération.
     * En effet, des navires travaillent en paires (ou en bœufs), par exemple pour tirer à deux un
     * meme
     * chalut.
     * note : Il peut s'agir d'un navire temporaire.
     * @param elementToAdd OperationVesselAssociation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addOperationVesselAssociations(OperationVesselAssociation elementToAdd)
    {
        return this.operationVesselAssociations.add(elementToAdd);
    }

    /**
     * Informations permet de décrire, par exemple la stratégie de répartition entre le navire
     * observé et
     * le navire associé pour l'opération.
     * En effet, des navires travaillent en paires (ou en bœufs), par exemple pour tirer à deux un
     * meme
     * chalut.
     * note : Il peut s'agir d'un navire temporaire.
     * @param elementToRemove OperationVesselAssociation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeOperationVesselAssociations(OperationVesselAssociation elementToRemove)
    {
        return this.operationVesselAssociations.remove(elementToRemove);
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private Collection<VesselUseFeatures> vesselUseFeatures = new HashSet<VesselUseFeatures>();

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @return this.vesselUseFeatures Collection<VesselUseFeatures>
     */
    public Collection<VesselUseFeatures> getVesselUseFeatures()
    {
        return this.vesselUseFeatures;
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param vesselUseFeaturesIn Collection<VesselUseFeatures>
     */
    public void setVesselUseFeatures(Collection<VesselUseFeatures> vesselUseFeaturesIn)
    {
        this.vesselUseFeatures = vesselUseFeaturesIn;
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param elementToAdd VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselUseFeatures(VesselUseFeatures elementToAdd)
    {
        return this.vesselUseFeatures.add(elementToAdd);
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param elementToRemove VesselUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselUseFeatures(VesselUseFeatures elementToRemove)
    {
        return this.vesselUseFeatures.remove(elementToRemove);
    }

    private Collection<GearUseFeatures> gearUseFeatures = new HashSet<GearUseFeatures>();

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @return this.gearUseFeatures Collection<GearUseFeatures>
     */
    public Collection<GearUseFeatures> getGearUseFeatures()
    {
        return this.gearUseFeatures;
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param gearUseFeaturesIn Collection<GearUseFeatures>
     */
    public void setGearUseFeatures(Collection<GearUseFeatures> gearUseFeaturesIn)
    {
        this.gearUseFeatures = gearUseFeaturesIn;
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param elementToAdd GearUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGearUseFeatures(GearUseFeatures elementToAdd)
    {
        return this.gearUseFeatures.add(elementToAdd);
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param elementToRemove GearUseFeatures
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGearUseFeatures(GearUseFeatures elementToRemove)
    {
        return this.gearUseFeatures.remove(elementToRemove);
    }

    private GearPhysicalFeatures gearPhysicalFeatures;

    /**
     * Caractéristiques physique de l'engin déployé au cours de l'opération.
     * Si l'opération est une opération de prélèvement, l'engin est forcément d'un engin de peche.
     * Exemple de caratéristiques physiques :
     * • engin : OTB (Chalut)
     * • longueur de la corde de dos
     * • largeur du maillage
     * • type de matériaux du fil
     * @return this.gearPhysicalFeatures GearPhysicalFeatures
     */
    public GearPhysicalFeatures getGearPhysicalFeatures()
    {
        return this.gearPhysicalFeatures;
    }

    /**
     * Caractéristiques physique de l'engin déployé au cours de l'opération.
     * Si l'opération est une opération de prélèvement, l'engin est forcément d'un engin de peche.
     * Exemple de caratéristiques physiques :
     * • engin : OTB (Chalut)
     * • longueur de la corde de dos
     * • largeur du maillage
     * • type de matériaux du fil
     * @param gearPhysicalFeaturesIn GearPhysicalFeatures
     */
    public void setGearPhysicalFeatures(GearPhysicalFeatures gearPhysicalFeaturesIn)
    {
        this.gearPhysicalFeatures = gearPhysicalFeaturesIn;
    }

    private Collection<VesselPosition> vesselPositions = new HashSet<VesselPosition>();

    /**
     * Positions du navires durant l'opération (date/heure/latitute/longitude).
     * La première position (en date/heure) correspond au début de l'opération.
     * La dernière position (en date/heure) correspond à la fin de l'opération.
     * @return this.vesselPositions Collection<VesselPosition>
     */
    public Collection<VesselPosition> getVesselPositions()
    {
        return this.vesselPositions;
    }

    /**
     * Positions du navires durant l'opération (date/heure/latitute/longitude).
     * La première position (en date/heure) correspond au début de l'opération.
     * La dernière position (en date/heure) correspond à la fin de l'opération.
     * @param vesselPositionsIn Collection<VesselPosition>
     */
    public void setVesselPositions(Collection<VesselPosition> vesselPositionsIn)
    {
        this.vesselPositions = vesselPositionsIn;
    }

    /**
     * Positions du navires durant l'opération (date/heure/latitute/longitude).
     * La première position (en date/heure) correspond au début de l'opération.
     * La dernière position (en date/heure) correspond à la fin de l'opération.
     * @param elementToAdd VesselPosition
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPositions(VesselPosition elementToAdd)
    {
        return this.vesselPositions.add(elementToAdd);
    }

    /**
     * Positions du navires durant l'opération (date/heure/latitute/longitude).
     * La première position (en date/heure) correspond au début de l'opération.
     * La dernière position (en date/heure) correspond à la fin de l'opération.
     * @param elementToRemove VesselPosition
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPositions(VesselPosition elementToRemove)
    {
        return this.vesselPositions.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Operation instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Operation))
        {
            return false;
        }
        final Operation that = (Operation)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Operation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Operation}.
         * @return new OperationImpl()
         */
        public static Operation newInstance()
        {
            return new OperationImpl();
        }

        /**
         * Constructs a new instance of {@link Operation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance
         */
        public static Operation newInstance(QualityFlag qualityFlag, Vessel vessel)
        {
            final Operation entity = new OperationImpl();
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Operation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param rankOrderOnPeriod Short
         * @param startDateTime Date
         * @param endDateTime Date
         * @param isMainOperation Boolean
         * @param position String
         * @param comments String
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param remoteId Integer
         * @param vesselPersonFeatures Collection<VesselPersonFeatures>
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param operationVesselAssociations Collection<OperationVesselAssociation>
         * @param fishingTrip FishingTrip
         * @param vesselUseFeatures Collection<VesselUseFeatures>
         * @param gearUseFeatures Collection<GearUseFeatures>
         * @param gearPhysicalFeatures GearPhysicalFeatures
         * @param vesselPositions Collection<VesselPosition>
         * @return newInstance Operation
         */
        public static Operation newInstance(String name, Short rankOrderOnPeriod, Date startDateTime, Date endDateTime, Boolean isMainOperation, String position, String comments, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Integer remoteId, Collection<VesselPersonFeatures> vesselPersonFeatures, QualityFlag qualityFlag, Vessel vessel, Collection<OperationVesselAssociation> operationVesselAssociations, FishingTrip fishingTrip, Collection<VesselUseFeatures> vesselUseFeatures, Collection<GearUseFeatures> gearUseFeatures, GearPhysicalFeatures gearPhysicalFeatures, Collection<VesselPosition> vesselPositions)
        {
            final Operation entity = new OperationImpl();
            entity.setName(name);
            entity.setRankOrderOnPeriod(rankOrderOnPeriod);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setIsMainOperation(isMainOperation);
            entity.setPosition(position);
            entity.setComments(comments);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setRemoteId(remoteId);
            entity.setVesselPersonFeatures(vesselPersonFeatures);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setOperationVesselAssociations(operationVesselAssociations);
            entity.setFishingTrip(fishingTrip);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            entity.setVesselPositions(vesselPositions);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Operation o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getRankOrderOnPeriod() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrderOnPeriod().compareTo(o.getRankOrderOnPeriod()));
            }
            if (this.getStartDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDateTime().compareTo(o.getStartDateTime()));
            }
            if (this.getEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDateTime().compareTo(o.getEndDateTime()));
            }
            if (this.getIsMainOperation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIsMainOperation().compareTo(o.getIsMainOperation()));
            }
            if (this.getPosition() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPosition().compareTo(o.getPosition()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Operation.java merge-point
}