// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.operation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Opération de peche durant laquelle un prélèvement peut etre effectué, au cours d'une sortie en
 * mer (marée observée en mer, marée enquetée au débarquement, sortie lors d'une campagne à la mer,
 * etc.).
 * Il peut également s'agir d'une séquence de peche, lorsque les dates début/fin ne sont pas connus,
 * et si la zone de peche est unique.
 * Les dates/heures et lat/long de début/fin caractérisent le début/fin de la capture réalisée (hors
 * temps d'établissement de l'engin).
 * REMARQUE : les caractéristiques "indicateur jour/nuit" et "Trajectoire rectiligne ou non" sont
 * présent à ce niveau dans Harmonie, mais gérés dans Allegro via les "cracatéristique d'utilisation
 * du navire" (VesselUseFeatures) rattachée à l'opération parente.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class FishingOperation
    extends OperationImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5247889332101799215L;

    // Generate 3 attributes
    private Date fishingStartDateTime;

    /**
     * Date/heure au début du prélèvement.
     * Par exemple, pour le cas d'une opération avec un chalut, il s'agit la date/heure à
     * l'établissement du chalut (le temps de descente n'est pas pris en compte).
     * @return this.fishingStartDateTime Date
     */
    public Date getFishingStartDateTime()
    {
        return this.fishingStartDateTime;
    }

    /**
     * Date/heure au début du prélèvement.
     * Par exemple, pour le cas d'une opération avec un chalut, il s'agit la date/heure à
     * l'établissement du chalut (le temps de descente n'est pas pris en compte).
     * @param fishingStartDateTimeIn Date
     */
    public void setFishingStartDateTime(Date fishingStartDateTimeIn)
    {
        this.fishingStartDateTime = fishingStartDateTimeIn;
    }

    private Date fishingEndDateTime;

    /**
     * Date/heure à la fin du prélèvement.
     * Par exemple, pour le cas d'une opération avec un chalut, le temps de remontée n'est pas
     * comptabilisé.
     * @return this.fishingEndDateTime Date
     */
    public Date getFishingEndDateTime()
    {
        return this.fishingEndDateTime;
    }

    /**
     * Date/heure à la fin du prélèvement.
     * Par exemple, pour le cas d'une opération avec un chalut, le temps de remontée n'est pas
     * comptabilisé.
     * @param fishingEndDateTimeIn Date
     */
    public void setFishingEndDateTime(Date fishingEndDateTimeIn)
    {
        this.fishingEndDateTime = fishingEndDateTimeIn;
    }

    private Boolean hasCatch;

    /**
     * Une capture a t elle été prélevée ?
     * Si non, il s'agit d'une opération de peche infructueuse.
     * A priori, si une capture avec quantification différente de 0 est saisie, ou bien si des
     * produits sont rattachés à l'opération, alors hasCapture=true (HAS_CAPTURE=1).
     * Si on ne sait pas si une capture a été réalisée ou non, le champ est laissé vide.
     * Champ utile pour les marées observées au débarquement, pour lesquelles on ne peut pas saisir
     * systématiquement de lot capture ou bien des produits.
     * @return this.hasCatch Boolean
     */
    public Boolean getHasCatch()
    {
        return this.hasCatch;
    }

    /**
     * Une capture a t elle été prélevée ?
     * Si non, il s'agit d'une opération de peche infructueuse.
     * A priori, si une capture avec quantification différente de 0 est saisie, ou bien si des
     * produits sont rattachés à l'opération, alors hasCapture=true (HAS_CAPTURE=1).
     * Si on ne sait pas si une capture a été réalisée ou non, le champ est laissé vide.
     * Champ utile pour les marées observées au débarquement, pour lesquelles on ne peut pas saisir
     * systématiquement de lot capture ou bien des produits.
     * @param hasCatchIn Boolean
     */
    public void setHasCatch(Boolean hasCatchIn)
    {
        this.hasCatch = hasCatchIn;
    }

    // Generate 3 associations
    private Collection<Produce> produces = new HashSet<Produce>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @return this.produces Collection<Produce>
     */
    public Collection<Produce> getProduces()
    {
        return this.produces;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param producesIn Collection<Produce>
     */
    public void setProduces(Collection<Produce> producesIn)
    {
        this.produces = producesIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduces(Produce elementToAdd)
    {
        return this.produces.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduces(Produce elementToRemove)
    {
        return this.produces.remove(elementToRemove);
    }

    private Collection<Sample> samples = new HashSet<Sample>();

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @return this.samples Collection<Sample>
     */
    public Collection<Sample> getSamples()
    {
        return this.samples;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param samplesIn Collection<Sample>
     */
    public void setSamples(Collection<Sample> samplesIn)
    {
        this.samples = samplesIn;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param elementToAdd Sample
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSamples(Sample elementToAdd)
    {
        return this.samples.add(elementToAdd);
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param elementToRemove Sample
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSamples(Sample elementToRemove)
    {
        return this.samples.remove(elementToRemove);
    }

    private CatchBatch catchBatch;

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @return this.catchBatch CatchBatch
     */
    public CatchBatch getCatchBatch()
    {
        return this.catchBatch;
    }

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @param catchBatchIn CatchBatch
     */
    public void setCatchBatch(CatchBatch catchBatchIn)
    {
        this.catchBatch = catchBatchIn;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>OperationImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.operation.Operation#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>OperationImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.operation.Operation#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link FishingOperation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link FishingOperation}.
         * @return new FishingOperationImpl()
         */
        public static FishingOperation newInstance()
        {
            return new FishingOperationImpl();
        }

        /**
         * Constructs a new instance of {@link FishingOperation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @return newInstance
         */
        public static FishingOperation newInstance(QualityFlag qualityFlag, Vessel vessel)
        {
            final FishingOperation entity = new FishingOperationImpl();
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link FishingOperation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param rankOrderOnPeriod Short
         * @param startDateTime Date
         * @param endDateTime Date
         * @param isMainOperation Boolean
         * @param position String
         * @param comments String
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param remoteId Integer
         * @param vesselPersonFeatures Collection<VesselPersonFeatures>
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param operationVesselAssociations Collection<OperationVesselAssociation>
         * @param fishingTrip FishingTrip
         * @param vesselUseFeatures Collection<VesselUseFeatures>
         * @param gearUseFeatures Collection<GearUseFeatures>
         * @param gearPhysicalFeatures GearPhysicalFeatures
         * @param vesselPositions Collection<VesselPosition>
         * @param fishingStartDateTime Date
         * @param fishingEndDateTime Date
         * @param hasCatch Boolean
         * @param produces Collection<Produce>
         * @param samples Collection<Sample>
         * @param catchBatch CatchBatch
         * @return newInstance FishingOperation
         */
        public static FishingOperation newInstance(String name, Short rankOrderOnPeriod, Date startDateTime, Date endDateTime, Boolean isMainOperation, String position, String comments, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Integer remoteId, Collection<VesselPersonFeatures> vesselPersonFeatures, QualityFlag qualityFlag, Vessel vessel, Collection<OperationVesselAssociation> operationVesselAssociations, FishingTrip fishingTrip, Collection<VesselUseFeatures> vesselUseFeatures, Collection<GearUseFeatures> gearUseFeatures, GearPhysicalFeatures gearPhysicalFeatures, Collection<VesselPosition> vesselPositions, Date fishingStartDateTime, Date fishingEndDateTime, Boolean hasCatch, Collection<Produce> produces, Collection<Sample> samples, CatchBatch catchBatch)
        {
            final FishingOperation entity = new FishingOperationImpl();
            entity.setName(name);
            entity.setRankOrderOnPeriod(rankOrderOnPeriod);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setIsMainOperation(isMainOperation);
            entity.setPosition(position);
            entity.setComments(comments);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setRemoteId(remoteId);
            entity.setVesselPersonFeatures(vesselPersonFeatures);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setOperationVesselAssociations(operationVesselAssociations);
            entity.setFishingTrip(fishingTrip);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            entity.setVesselPositions(vesselPositions);
            entity.setFishingStartDateTime(fishingStartDateTime);
            entity.setFishingEndDateTime(fishingEndDateTime);
            entity.setHasCatch(hasCatch);
            entity.setProduces(produces);
            entity.setSamples(samples);
            entity.setCatchBatch(catchBatch);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(FishingOperation o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getFishingStartDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFishingStartDateTime().compareTo(o.getFishingStartDateTime()));
            }
            if (this.getFishingEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getFishingEndDateTime().compareTo(o.getFishingEndDateTime()));
            }
            if (this.getHasCatch() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getHasCatch().compareTo(o.getHasCatch()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// FishingOperation.java merge-point
}