// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.measure.file;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.t;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.stereotype.Repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.measure.file.MeasurementFile
 */
@Repository("measurementFileDao")
@Lazy
public class MeasurementFileDaoImpl
		extends MeasurementFileDaoBase implements MeasurementFileExtendDao, InitializingBean {

	/** Logger. */
	private static final Log log =
			LogFactory.getLog(MeasurementFileDaoImpl.class);

	@Autowired
	protected AdagioConfiguration config;

	protected File dbAttachmentDirectory;

	protected static final String ATTACHMENT_PATH_FORMAT =
			"%1$s/OBJ%2$s/%1$s-OBJ%2$s-%3$s.%4$s";

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public MeasurementFileDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		initConstants();
	}

	// ------------------------------------------------------------------------//
	// -- AttachmentPersistenceService implementation --//
	// ------------------------------------------------------------------------//

	@Override
	public List<Attachment> getAllAttachments(String objectType,
			Integer objectId) {
		Iterator<Object[]> list = queryIterator(
				"allMeasurementFilesFromObject",
				"objectId", IntegerType.INSTANCE, objectId,
				"objectTypeCode", StringType.INSTANCE, objectType
				);

		List<Attachment> result = Lists.newArrayList();
		while (list.hasNext()) {
			Object[] source = list.next();
			Attachment target = new AttachmentVO();
			loadAttachment(source, target);
			result.add(target);
		}
		return Collections.unmodifiableList(result);
	}

	@Override
	public File getAttachmentFile(Integer attachmentId) {
		Object[] source = queryUnique(
				"measurementFile",
				"measurementFileId", IntegerType.INSTANCE, attachmentId);

		if (source == null) {
			throw new DataRetrievalFailureException(
					"Could not retrieve Attachment with id=" + attachmentId);
		}
		Attachment target = new AttachmentVO();
		loadAttachment(source, target);

		File result = getFile(target);
		return result;
	}

	@Override
	public Attachment createAttachment(Attachment attachment, File file) {
		Preconditions.checkNotNull(attachment);
		Preconditions.checkNotNull(attachment.getObjectType());
		Preconditions.checkNotNull(attachment.getObjectId());
		Preconditions.checkArgument(
				attachment.getId() == null,
				"Attachment 'id' must be null to call createAttachment().");
		Preconditions.checkNotNull(file);

		// Create measurement file
		MeasurementFile measurementFile = MeasurementFile.Factory.newInstance();

		// no usage of pmfm (since version 1.5)
		measurementFile.setPmfm(null);

		// set not qualifed flag
		measurementFile.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));

		// set objectType
		measurementFile.setObjectType(load(ObjectTypeImpl.class, attachment.getObjectType()));

		// set objectId
		measurementFile.setObjectId(attachment.getObjectId());

		// Use first a fake filePath (we don't know the id of attachment entity)
		measurementFile.setPath("FAKE-" + System.nanoTime());

		// copy our property
		attachmentToEntity(attachment, measurementFile);
		create(measurementFile);

		// get created id
		attachment.setId(measurementFile.getId());

		// Build now the real path
		String filePath = String.format(ATTACHMENT_PATH_FORMAT,
				measurementFile.getObjectType().getCode(),
				measurementFile.getObjectId(),
				measurementFile.getId(),
				FilenameUtils.getExtension(file.getName()));

		// store the path
		attachment.setPath(filePath);
		measurementFile.setPath(filePath);

		if (log.isDebugEnabled()) {
			log.debug("Created attachment: " + attachment.getId() +
					", path: " + filePath);
		}

		// update measurementFile with correct path
		update(measurementFile);

		// copy file to disk local storage
		File targetFile = getFile(attachment);

		try {
			FileUtils.copyFile(file, targetFile);
		} catch (IOException e) {
			throw new AdagioTechnicalException(t("adagio.persistence.attachment.copyFile.error", file, targetFile), e);
		}

		return attachment;
	}

	@Override
	public Attachment saveAttachment(Attachment attachment) {
		Preconditions.checkNotNull(attachment);
		Preconditions.checkNotNull(attachment.getObjectType());
		Preconditions.checkNotNull(attachment.getObjectId());
		Preconditions.checkNotNull(
				attachment.getId(),
				"Attachment 'id' must not be null or empty to be saved.");

		MeasurementFile measurementFile = load(attachment.getId());
		if (measurementFile == null) {
			throw new DataRetrievalFailureException("Could not retrieve Attachment with id=" + attachment.getId());
		}

		// can't change the objectType
		String oldObjectTypeCode = measurementFile.getObjectType().getCode();
		if (ObjectUtils.notEqual(attachment.getObjectType(),
				oldObjectTypeCode)) {
			throw new InvalidDataAccessResourceUsageException(
					"Can't change objectType, was before " + oldObjectTypeCode);
		}

		// can't change either objectId
		Integer oldObjectId = measurementFile.getObjectId();
		if (ObjectUtils.notEqual(attachment.getObjectId(),
				oldObjectId)) {
			throw new InvalidDataAccessResourceUsageException(
					"Can't change objectId, was before " + oldObjectId);
		}

		attachmentToEntity(attachment, measurementFile);
		update(measurementFile);
		return attachment;
	}

	@Override
	public void deleteAttachment(Integer attachmentId) {
		Object[] source = queryUnique(
				"measurementFile",
				"measurementFileId", IntegerType.INSTANCE, attachmentId);

		if (source == null) {
			throw new DataRetrievalFailureException(
					"Could not retrieve Attachment with id=" + attachmentId);
		}
		Attachment target = new AttachmentVO();
		loadAttachment(source, target);

		delete(target);

		getSession().flush();
	}

	@Override
	public void deleteAllAttachment(String objectType,
			Integer... objectIds) {
		for (Integer objectId : objectIds) {
			List<Attachment> attachments = getAllAttachments(objectType, objectId);
			for (Attachment attachment : attachments) {
				delete(attachment);
			}
		}
	}

	// ------------------------------------------------------------------------//
	// -- Internal methods --//
	// ------------------------------------------------------------------------//

	protected void initConstants() {
		dbAttachmentDirectory = config.getDbAttachmentDirectory();

		if (log.isDebugEnabled()) {
			log.debug("Db Attachment storage: " + dbAttachmentDirectory);
		}
	}

	protected void loadAttachment(Object[] source,
			Attachment target) {

		target.setObjectType(String.valueOf((String) source[0]));
		target.setObjectId((Integer) source[1]);
		target.setId((Integer) source[2]);
		target.setPath((String) source[3]);
		target.setName((String) source[4]);
		target.setComment((String) source[5]);
	}

	protected void attachmentToEntity(Attachment attachment,
			MeasurementFile measurementFile) {
		measurementFile.setName(attachment.getName());
		measurementFile.setComments(attachment.getComment());
	}

	protected File getFile(Attachment attachment) {
		File result = new File(dbAttachmentDirectory, attachment.getPath());
		return result;
	}

	protected void delete(Attachment target) {

		remove(target.getId());

		File file = getFile(target);
		try {
			FileUtils.forceDelete(file);
		} catch (IOException e) {
			throw new AdagioTechnicalException(t("adagio.persistence.attachment.deleteFile.error", file), e);
		}
	}
}