// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.measure;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrument;
import fr.ifremer.adagio.core.dao.referential.NumericalPrecision;
import fr.ifremer.adagio.core.dao.referential.PrecisionType;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.AggregationLevel;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import java.util.Date;

/**
 * Résultat de mesure de quantification d'un lot ou d'un produit.
 * Les mesures de quantification portent sur le paramètre "Poids". Elle peuvent être obtenue par
 * différentes méthodes :
 * - mesuré (ex : par une règle ou Ichtyomètre),
 * - estimé (ex : jugement par un expert),
 * - calculé par une relation taille/poids
 * - calculé à partir de volumes (nombre d'unité de volume x Poids d'une unité de volume). Il s'agit
 * donc d'un poids estimé, mais par le volume.
 * - déclaré (cf SACROIS/RIC2)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class QuantificationMeasurement
    extends MeasurementImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -9133401313776729152L;

    // Generate 2 attributes
    private Short subgroupNumber;

    /**
     * Numéro du sous ensemble sur lequel porte la mesure de quantification. Si non renseigné, le
     * mesure porte sur tout le lot rattaché.Une quantification d'un lot peut faire intervenir
     * plusieurs sous-ensemble sur lequel des mesures sont éffectuées. Par exemple, plusieurs
     * sous-ensembles peuvent être quantifié par pesée, chaque mesure est donc rattaché à un
     * sous-ensemmble, via le numéro de sous ensemble.
     * @return this.subgroupNumber Short
     */
    public Short getSubgroupNumber()
    {
        return this.subgroupNumber;
    }

    /**
     * Numéro du sous ensemble sur lequel porte la mesure de quantification. Si non renseigné, le
     * mesure porte sur tout le lot rattaché.Une quantification d'un lot peut faire intervenir
     * plusieurs sous-ensemble sur lequel des mesures sont éffectuées. Par exemple, plusieurs
     * sous-ensembles peuvent être quantifié par pesée, chaque mesure est donc rattaché à un
     * sous-ensemmble, via le numéro de sous ensemble.
     * @param subgroupNumberIn Short
     */
    public void setSubgroupNumber(Short subgroupNumberIn)
    {
        this.subgroupNumber = subgroupNumberIn;
    }

    private Boolean isReferenceQuantification;

    /**
     * S'agit t il de la mesure de référence pour la quantification du lot ? Par défaut, le poids
     * calculé (par relation taille/poids) est le poids de référence.
     * Doit etre NULL si subgroupNumber est NULL (un poids de référence ne peut pas porter sur une
     * sous-ensemble du lot , mais sur tout le lot)
     * @return this.isReferenceQuantification Boolean
     */
    public Boolean getIsReferenceQuantification()
    {
        return this.isReferenceQuantification;
    }

    /**
     * S'agit t il de la mesure de référence pour la quantification du lot ? Par défaut, le poids
     * calculé (par relation taille/poids) est le poids de référence.
     * Doit etre NULL si subgroupNumber est NULL (un poids de référence ne peut pas porter sur une
     * sous-ensemble du lot , mais sur tout le lot)
     * @param isReferenceQuantificationIn Boolean
     */
    public void setIsReferenceQuantification(Boolean isReferenceQuantificationIn)
    {
        this.isReferenceQuantification = isReferenceQuantificationIn;
    }

    // Generate 1 associations
    private Batch batch;

    /**
     * Lot auquel est rattaché la mesure de quantification (optionnel).
     * @return this.batch Batch
     */
    public Batch getBatch()
    {
        return this.batch;
    }

    /**
     * Lot auquel est rattaché la mesure de quantification (optionnel).
     * @param batchIn Batch
     */
    public void setBatch(Batch batchIn)
    {
        this.batch = batchIn;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link QuantificationMeasurement}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link QuantificationMeasurement}.
         * @return new QuantificationMeasurementImpl()
         */
        public static QuantificationMeasurement newInstance()
        {
            return new QuantificationMeasurementImpl();
        }

        /**
         * Constructs a new instance of {@link QuantificationMeasurement}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param qualityFlag QualityFlag
         * @param pmfm Pmfm
         * @param batch Batch
         * @return newInstance
         */
        public static QuantificationMeasurement newInstance(QualityFlag qualityFlag, Pmfm pmfm, Batch batch)
        {
            final QuantificationMeasurement entity = new QuantificationMeasurementImpl();
            entity.setQualityFlag(qualityFlag);
            entity.setPmfm(pmfm);
            entity.setBatch(batch);
            return entity;
        }

        /**
         * Constructs a new instance of {@link QuantificationMeasurement}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param numericalValue Float
         * @param alphanumericalValue String
         * @param digitCount Integer
         * @param precisionValue Float
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param remoteId Integer
         * @param aggregationLevel AggregationLevel
         * @param qualityFlag QualityFlag
         * @param precisionType PrecisionType
         * @param analysisInstrument AnalysisInstrument
         * @param numericalPrecision NumericalPrecision
         * @param department Department
         * @param pmfm Pmfm
         * @param qualitativeValue QualitativeValue
         * @param subgroupNumber Short
         * @param isReferenceQuantification Boolean
         * @param batch Batch
         * @return newInstance QuantificationMeasurement
         */
        public static QuantificationMeasurement newInstance(Float numericalValue, String alphanumericalValue, Integer digitCount, Float precisionValue, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Integer remoteId, AggregationLevel aggregationLevel, QualityFlag qualityFlag, PrecisionType precisionType, AnalysisInstrument analysisInstrument, NumericalPrecision numericalPrecision, Department department, Pmfm pmfm, QualitativeValue qualitativeValue, Short subgroupNumber, Boolean isReferenceQuantification, Batch batch)
        {
            final QuantificationMeasurement entity = new QuantificationMeasurementImpl();
            entity.setNumericalValue(numericalValue);
            entity.setAlphanumericalValue(alphanumericalValue);
            entity.setDigitCount(digitCount);
            entity.setPrecisionValue(precisionValue);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setRemoteId(remoteId);
            entity.setAggregationLevel(aggregationLevel);
            entity.setQualityFlag(qualityFlag);
            entity.setPrecisionType(precisionType);
            entity.setAnalysisInstrument(analysisInstrument);
            entity.setNumericalPrecision(numericalPrecision);
            entity.setDepartment(department);
            entity.setPmfm(pmfm);
            entity.setQualitativeValue(qualitativeValue);
            entity.setSubgroupNumber(subgroupNumber);
            entity.setIsReferenceQuantification(isReferenceQuantification);
            entity.setBatch(batch);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(QuantificationMeasurement o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSubgroupNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSubgroupNumber().compareTo(o.getSubgroupNumber()));
            }
            if (this.getIsReferenceQuantification() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIsReferenceQuantification().compareTo(o.getIsReferenceQuantification()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// QuantificationMeasurement.java merge-point
}