package fr.ifremer.adagio.core.dao.data.batch.validator;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: CatchBatchValidationException.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/validator/CatchBatchValidationException.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Iterator;
import java.util.List;

/**
 * Exception that occur when validation failed on a catch batch
 * 
 * @author blavenie
 * 
 */
public class CatchBatchValidationException extends Exception {

	private static final long serialVersionUID = -4175974402677470233L;

	protected List<CatchBatchValidationError> errors;

	public CatchBatchValidationException(List<CatchBatchValidationError> errors) {
		super(asString(errors));
		this.errors = errors;
	}

	public CatchBatchValidationException(String message, List<CatchBatchValidationError> errors) {
		super(message);
		this.errors = errors;
	}

	public List<CatchBatchValidationError> getErrors() {
		return errors;
	}

	public void setErrors(List<CatchBatchValidationError> errors) {
		this.errors = errors;
	}

	public static String asString(List<CatchBatchValidationError> errors) {
		if (errors == null || errors.size() == 0) {
			return null;
		}
		StringBuffer sb = new StringBuffer();
		sb.append("Batch tree validation errors :");
		int count = 1;
		for (Iterator<CatchBatchValidationError> iterator = errors.iterator(); iterator.hasNext();) {
			CatchBatchValidationError catchBatchValidationError = iterator.next();
			if (catchBatchValidationError.getGravity() == CatchBatchValidationError.GRAVITY_ERROR) {
				sb.append("\n").append(count++).append(" - ");
				sb.append(catchBatchValidationError.getMessage());
			}
		}
		return sb.toString();
	}
}
