package fr.ifremer.adagio.core.dao.data.batch.validator;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: CatchBatchValidationError.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/validator/CatchBatchValidationError.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;

import com.google.common.base.Preconditions;

public class CatchBatchValidationError {

	public static final int GRAVITY_INFO = 0;
	public static final int GRAVITY_WARNING = 1;
	public static final int GRAVITY_ERROR = 2;

	protected List<CatchBatchQuickFix> quickFixes = null;

	protected String errorCode = null;

	protected String message = null;

	protected int gravity = 0;

	public CatchBatchValidationError() {
	}

	public CatchBatchValidationError(String errorCode, String message, int gravity) {
		this.errorCode = errorCode;
		this.message = message;
		setGravity(gravity);
	}

	public CatchBatchValidationError(String errorCode, String message, int gravity, List<CatchBatchQuickFix> quickFixes) {
		this.errorCode = errorCode;
		this.message = message;
		setGravity(gravity);
		this.quickFixes = quickFixes;
	}

	public List<CatchBatchQuickFix> getQuickFixes() {
		return quickFixes;
	}

	public void setQuickFixes(List<CatchBatchQuickFix> quickFixes) {
		this.quickFixes = quickFixes;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public int getGravity() {
		return gravity;
	}

	public void setGravity(int gravity) {
		Preconditions.checkArgument(gravity >= GRAVITY_INFO && gravity <= GRAVITY_ERROR);
		this.gravity = gravity;
	}
}
