// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.util.Collection;
import java.util.HashSet;

/**
 * Lot avec critères de classement.
 * Exemple de critères : 'Débarquement', 'Rejet', 'Vrac', 'Hors Vrac', 'Vidé/Eteté...',
 * 'Gros/Moyen/Petit'
 */
// HibernateEntity.vsl annotations merge-point
public abstract class SortingBatch
    extends BatchImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -2214534944239123388L;

    // Generate 2 attributes
    private Float samplingRatio;

    /**
     * 
     * @return this.samplingRatio Float
     */
    public Float getSamplingRatio()
    {
        return this.samplingRatio;
    }

    /**
     * 
     * @param samplingRatioIn Float
     */
    public void setSamplingRatio(Float samplingRatioIn)
    {
        this.samplingRatio = samplingRatioIn;
    }

    private String samplingRatioText;

    /**
     * 
     * @return this.samplingRatioText String
     */
    public String getSamplingRatioText()
    {
        return this.samplingRatioText;
    }

    /**
     * 
     * @param samplingRatioTextIn String
     */
    public void setSamplingRatioText(String samplingRatioTextIn)
    {
        this.samplingRatioText = samplingRatioTextIn;
    }

    // Generate 4 associations
    private ReferenceTaxon referenceTaxon;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Esp&#232;ce scientifique identifiant le lot (optionnel).
     * </p>
     * <p>
     * </p>
     * <p>
     * Ne peut etre renseign&#233; si une esp&#232;ce commerciale (TaxonGroup) est d&#233;j&#224;
     * renseign&#233;e sur le lot.
     * </p>
     * </body>
     * </html>
     * @return this.referenceTaxon ReferenceTaxon
     */
    public ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Esp&#232;ce scientifique identifiant le lot (optionnel).
     * </p>
     * <p>
     * </p>
     * <p>
     * Ne peut etre renseign&#233; si une esp&#232;ce commerciale (TaxonGroup) est d&#233;j&#224;
     * renseign&#233;e sur le lot.
     * </p>
     * </body>
     * </html>
     * @param referenceTaxonIn ReferenceTaxon
     */
    public void setReferenceTaxon(ReferenceTaxon referenceTaxonIn)
    {
        this.referenceTaxon = referenceTaxonIn;
    }

    private CatchBatch rootBatch;

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @return this.rootBatch CatchBatch
     */
    public CatchBatch getRootBatch()
    {
        return this.rootBatch;
    }

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @param rootBatchIn CatchBatch
     */
    public void setRootBatch(CatchBatch rootBatchIn)
    {
        this.rootBatch = rootBatchIn;
    }

    private TaxonGroup taxonGroup;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Esp&#232;ce commerciale (ou groupe d'esp&#232;ces) identifiant le lot (optionnel).<br><br>Ne
     * peut etre renseign&#233; si une esp&#232;ce scientifique (ReferenceTaxon) est d&#233;j&#224;
     * renseign&#233; sur le lot.
     * </p>
     * </body>
     * </html>
     * @return this.taxonGroup TaxonGroup
     */
    public TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Esp&#232;ce commerciale (ou groupe d'esp&#232;ces) identifiant le lot (optionnel).<br><br>Ne
     * peut etre renseign&#233; si une esp&#232;ce scientifique (ReferenceTaxon) est d&#233;j&#224;
     * renseign&#233; sur le lot.
     * </p>
     * </body>
     * </html>
     * @param taxonGroupIn TaxonGroup
     */
    public void setTaxonGroup(TaxonGroup taxonGroupIn)
    {
        this.taxonGroup = taxonGroupIn;
    }

    private Collection<SortingMeasurement> sortingMeasurements = new HashSet<SortingMeasurement>();

    /**
     * Liste des critères de classement du lot.
     * @return this.sortingMeasurements Collection<SortingMeasurement>
     */
    public Collection<SortingMeasurement> getSortingMeasurements()
    {
        return this.sortingMeasurements;
    }

    /**
     * Liste des critères de classement du lot.
     * @param sortingMeasurementsIn Collection<SortingMeasurement>
     */
    public void setSortingMeasurements(Collection<SortingMeasurement> sortingMeasurementsIn)
    {
        this.sortingMeasurements = sortingMeasurementsIn;
    }

    /**
     * Liste des critères de classement du lot.
     * @param elementToAdd SortingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSortingMeasurements(SortingMeasurement elementToAdd)
    {
        return this.sortingMeasurements.add(elementToAdd);
    }

    /**
     * Liste des critères de classement du lot.
     * @param elementToRemove SortingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSortingMeasurements(SortingMeasurement elementToRemove)
    {
        return this.sortingMeasurements.remove(elementToRemove);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>BatchImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see Batch#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>BatchImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see Batch#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link SortingBatch}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link SortingBatch}.
         * @return new SortingBatchImpl()
         */
        public static SortingBatch newInstance()
        {
            return new SortingBatchImpl();
        }

        /**
         * Constructs a new instance of {@link SortingBatch}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param rankOrder Short
         * @param childBatchsReplication Boolean
         * @param exhaustiveInventory Boolean
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static SortingBatch newInstance(Short rankOrder, Boolean childBatchsReplication, Boolean exhaustiveInventory, QualityFlag qualityFlag)
        {
            final SortingBatch entity = new SortingBatchImpl();
            entity.setRankOrder(rankOrder);
            entity.setChildBatchsReplication(childBatchsReplication);
            entity.setExhaustiveInventory(exhaustiveInventory);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link SortingBatch}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param rankOrder Short
         * @param subgroupCount Float
         * @param individualCount Integer
         * @param childBatchsReplication Boolean
         * @param exhaustiveInventory Boolean
         * @param comments String
         * @param label String
         * @param remoteId Integer
         * @param location Location
         * @param parentBatch Batch
         * @param childBatchs Collection<Batch>
         * @param batchExhaustiveInventories Collection<BatchExhaustiveInventory>
         * @param qualityFlag QualityFlag
         * @param produces Collection<Produce>
         * @param quantificationMeasurements Collection<QuantificationMeasurement>
         * @param samplingRatio Float
         * @param samplingRatioText String
         * @param referenceTaxon ReferenceTaxon
         * @param rootBatch CatchBatch
         * @param taxonGroup TaxonGroup
         * @param sortingMeasurements Collection<SortingMeasurement>
         * @return newInstance SortingBatch
         */
        public static SortingBatch newInstance(Short rankOrder, Float subgroupCount, Integer individualCount, Boolean childBatchsReplication, Boolean exhaustiveInventory, String comments, String label, Integer remoteId, Location location, Batch parentBatch, Collection<Batch> childBatchs, Collection<BatchExhaustiveInventory> batchExhaustiveInventories, QualityFlag qualityFlag, Collection<Produce> produces, Collection<QuantificationMeasurement> quantificationMeasurements, Float samplingRatio, String samplingRatioText, ReferenceTaxon referenceTaxon, CatchBatch rootBatch, TaxonGroup taxonGroup, Collection<SortingMeasurement> sortingMeasurements)
        {
            final SortingBatch entity = new SortingBatchImpl();
            entity.setRankOrder(rankOrder);
            entity.setSubgroupCount(subgroupCount);
            entity.setIndividualCount(individualCount);
            entity.setChildBatchsReplication(childBatchsReplication);
            entity.setExhaustiveInventory(exhaustiveInventory);
            entity.setComments(comments);
            entity.setLabel(label);
            entity.setRemoteId(remoteId);
            entity.setLocation(location);
            entity.setParentBatch(parentBatch);
            entity.setChildBatchs(childBatchs);
            entity.setBatchExhaustiveInventories(batchExhaustiveInventories);
            entity.setQualityFlag(qualityFlag);
            entity.setProduces(produces);
            entity.setQuantificationMeasurements(quantificationMeasurements);
            entity.setSamplingRatio(samplingRatio);
            entity.setSamplingRatioText(samplingRatioText);
            entity.setReferenceTaxon(referenceTaxon);
            entity.setRootBatch(rootBatch);
            entity.setTaxonGroup(taxonGroup);
            entity.setSortingMeasurements(sortingMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(SortingBatch o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSamplingRatio() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingRatio().compareTo(o.getSamplingRatio()));
            }
            if (this.getSamplingRatioText() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSamplingRatioText().compareTo(o.getSamplingRatioText()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// SortingBatch.java merge-point
    private java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement> inheritedSortingMeasurements = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement>();
    private Integer inheritedReferenceTaxonId = null;
    private Integer inheritedTaxonGroupId = null;
    private Short flatRankOrder = null;
    private Float indirectIndividualCount = null;
    private Float elevateIndividualCount = null;
    private Short treeLevel = null;
    private String treeIndent = null;
    private String sortingValuesText = null;
    private Boolean isLanding = null;
    private Boolean isDiscard = null;

    public java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement> getInheritedSortingMeasurements() {
        return this.inheritedSortingMeasurements;
    }
    public void setInheritedSortingMeasurements(java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement> inheritedSortingMeasurements){
        this.inheritedSortingMeasurements = inheritedSortingMeasurements;
    }

  public Integer getInheritedReferenceTaxonId() {
    return inheritedReferenceTaxonId;
  }

  public void setInheritedReferenceTaxonId(Integer inheritedReferenceTaxonId) {
    this.inheritedReferenceTaxonId = inheritedReferenceTaxonId;
  }

  public Integer getInheritedTaxonGroupId() {
    return inheritedTaxonGroupId;
  }

  public void setInheritedTaxonGroupId(Integer inheritedTaxonGroupId) {
    this.inheritedTaxonGroupId = inheritedTaxonGroupId;
  }

  public Short getFlatRankOrder() {
    return flatRankOrder;
  }

  public void setFlatRankOrder(Short flatRankOrder) {
    this.flatRankOrder = flatRankOrder;
  }

  public Float getIndirectIndividualCount() {
    return indirectIndividualCount;
  }

  public void setIndirectIndividualCount(Float indirectIndividualCount) {
    this.indirectIndividualCount = indirectIndividualCount;
  }

  public Float getElevateIndividualCount() {
    return elevateIndividualCount;
  }

  public void setElevateIndividualCount(Float elevateIndividualCount) {
    this.elevateIndividualCount = elevateIndividualCount;
  }

  public Short getTreeLevel() {
    return treeLevel;
  }

  public void setTreeLevel(Short treeLevel) {
    this.treeLevel = treeLevel;
  }

  public String getTreeIndent() {
    return treeIndent;
  }

  public void setTreeIndent(String treeIndent) {
    this.treeIndent = treeIndent;
  }

  public String getSortingValuesText() {
    return sortingValuesText;
  }

  public void setSortingValuesText(String sortingValuesText) {
    this.sortingValuesText = sortingValuesText;
  }

  public Boolean getIsLanding() {
    return isLanding;
  }

  public void setIsLanding(Boolean isLanding) {
    this.isLanding = isLanding;
  }

  public Boolean getIsDiscard() {
    return isDiscard;
  }

  public void setIsDiscard(Boolean isDiscard) {
    this.isDiscard = isDiscard;
  }
}