// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: CatchBatchDaoImpl.java 12057 2014-04-22 12:43:03Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.5.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/CatchBatchDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

import javax.annotation.Resource;

import org.hibernate.Session;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataRetrievalFailureException;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchQuickFix;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.batch.CatchBatch
 */
@org.springframework.stereotype.Repository("catchBatchDao")
@org.springframework.context.annotation.Lazy
public class CatchBatchDaoImpl
		extends fr.ifremer.adagio.core.dao.data.batch.CatchBatchDaoBase
		implements CatchBatchExtendDao {

	protected List<CatchBatchValidator> validators = Lists.newArrayList();

	@Resource(name = "sortingBatchDao")
	protected SortingBatchDao sortingBatchDao;

	@Resource(name = "catchBatchDao")
	protected CatchBatchExtendDao catchBatchDao;

	/**
	 * Constructor used by Spring
	 */
	@org.springframework.beans.factory.annotation.Autowired
	public CatchBatchDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public CatchBatch loadFullTree(Integer catchBatchId) {
		// Call method throw the interface, to enable cache use
		return catchBatchDao.loadFullTreeWithCache(catchBatchId, AdagioConfiguration.getInstance().useBacthTreeCache(), false);
	}

	@Override
	public CatchBatch loadFullTree(Integer catchBatchId, boolean validate, boolean quickFix) throws CatchBatchValidationException {
		// Call method throw the interface, to enable cache use
		CatchBatch catchBatch = catchBatchDao.loadFullTreeWithCache(catchBatchId, AdagioConfiguration.getInstance().useBacthTreeCache(), false);

		// Catch batch validation
		if (validate) {
			boolean retryValidation = true;
			int quickFixCounter = 0;
			while (retryValidation) {
				// Applied validation
				List<CatchBatchValidationError> errors = validate(catchBatch);
				retryValidation = false;

				// Check if validation results has error with gravity ERROR
				if (errors != null && errors.size() > 0) {
					List<CatchBatchQuickFix> quickFixes = Lists.newArrayList();
					boolean hasGravityError = false;

					for (CatchBatchValidationError error : errors) {
						if (error.getGravity() == CatchBatchValidationError.GRAVITY_ERROR) {
							hasGravityError = true;
							// Store quick fixes if any
							if (quickFix && error.getQuickFixes() != null) {
								quickFixes.addAll(error.getQuickFixes());
							}
						}
					}

					// If errors found but one quick fix could be apply
					if (hasGravityError && quickFix && quickFixes.size() == 1 && quickFixCounter < 2) {
						// applied the quick fix :
						catchBatch = quickFixes.get(0).repair(catchBatch);
						retryValidation = true;
						quickFixCounter++;
					}
					// Error found, and could not be repaired
					else if (hasGravityError) {
						throw new CatchBatchValidationException(errors);
					}
				}

			}
		}
		return catchBatch;
	}

	@Override
	public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
		List<CatchBatchValidationError> errors = Lists.newArrayList();
		for (CatchBatchValidator validator : validators) {
			if (validator.isEnable(catchBatch)) {
				List<CatchBatchValidationError> result = validator.validate(catchBatch);
				if (result != null && result.size() > 0) {
					errors.addAll(result);
				}
			}
		}
		if (errors.size() == 0) {
			return null;
		}
		return errors;
	}

	@Override
	public SortingBatch getSortingBatch(Collection<Batch> batchs,
			Object... params) {

		if (batchs == null || batchs.size() == 0
				|| params == null || params.length == 0) {
			return null;
		}

		String propertyName = (String) params[0];
		Integer expectedPmfmId = null;
		Integer qualitativeValueId = null;
		Integer referenceTaxonId = null;
		Object[] newParams = null;
		if (PMFM_ID.equals(propertyName)) {
			Preconditions.checkArgument(
					params.length >= 3,
					"Params must be tuple (propertyName, [pmfmId,] value)");
			expectedPmfmId = (Integer) params[1];
			qualitativeValueId = (Integer) params[2];
			newParams = Arrays.copyOfRange(params, 3, params.length);
		} else if (REFERENCE_TAXON_ID.equals(propertyName)) {
			Preconditions.checkArgument(
					params.length >= 2,
					"Params must be tuple (propertyName, [referenceTaxonId,] value)");
			referenceTaxonId = (Integer) params[1];
			newParams = Arrays.copyOfRange(params, 2, params.length);
		} else {
			Preconditions.checkArgument(
					false,
					"Params must be tuple (propertyName, [id,] value), and propertyName must be 'pmfmId' or 'referenceTaxonId'.");
		}

		for (Batch batch : batchs) {
			SortingBatch sortingBatch = (SortingBatch) batch;
			boolean found = false;

			if (expectedPmfmId != null) {
				for (SortingMeasurement sm : sortingBatch.getSortingMeasurements()) {
					Integer pmfmId = sm.getPmfm().getId();
					if (expectedPmfmId.equals(pmfmId)
							&& sm.getQualitativeValue() != null
							&& qualitativeValueId.equals(sm.getQualitativeValue().getId())) {
						found = true;
						break;
					}
				}
			} else if (referenceTaxonId != null
					&& sortingBatch.getReferenceTaxon() != null
					&& referenceTaxonId.equals(sortingBatch.getReferenceTaxon().getId())) {
				found = true;
			}

			if (found) {
				if (newParams != null && newParams.length > 0) {
					return getSortingBatch(sortingBatch.getChildBatchs(), newParams);
				}
				return sortingBatch;
			}
		}
		return null;
	}

	@Override
	public void registerCatchBatchValidator(CatchBatchValidator validator) {
		if (!validators.contains(validator)) {
			validators.add(validator);
		}
	}

	@Override
	public void unregisterCatchBatchValidator(CatchBatchValidator validator) {
		validators.remove(validator);
	}

	@Override
	public void update(CatchBatch catchBatch) {
		super.update(catchBatch);
	}

	@Override
	public void removeWithChildren(Integer batchId) {
		removeWithChildren(batchId, null);
	}

	@Override
	public List<Integer> getAllChildrenIds(Integer batchId) {
		List<Integer> result = Lists.newArrayList();
		getAllChildrenIds(batchId, result);
		// don't keep the top node id
		result.remove(batchId);
		return result;
	}

	@Override
	public void remove(Integer id) {

		Preconditions.checkNotNull(id);

		List<Integer> childrenIds = getAllChildrenIds(id);

		for (Integer childrenId : childrenIds) {
			SortingBatch sortingBatch = load(SortingBatchImpl.class, childrenId);
			sortingBatch.getSortingMeasurements().clear();
			sortingBatch.getQuantificationMeasurements().clear();
			getSession().delete(sortingBatch);
		}
		CatchBatch catchBatch = load(CatchBatchImpl.class, id);
		catchBatch.getQuantificationMeasurements().clear();
		catchBatch.getFishingOperation().setCatchBatch(null);
		super.remove(catchBatch);
	}

	@Override
	public void removeWithChildren(Integer batchId, CatchBatch parentCatchBatch) {
		Iterator<Object[]> childRows = queryIteratorTyped("childBatchIds",
				"parentBatchId", IntegerType.INSTANCE, batchId);

		boolean isCatchBatch = false;

		// First remove all children
		while (childRows.hasNext()) {
			Object[] childRow = childRows.next();
			Integer childBatchId = (Integer) childRow[0];
			Integer rootBatchId = (Integer) childRow[1];
			if (batchId.equals(rootBatchId)) {
				isCatchBatch = true;
			}

			// Recursive call
			removeWithChildren(childBatchId, parentCatchBatch);
		}

		// Then remove the current batch
		if (isCatchBatch) {
			CatchBatch catchBatch = load(CatchBatchImpl.class, batchId);

			catchBatch.getQuantificationMeasurements().clear();
			getSession().delete(catchBatch);
		} else {
			SortingBatch sortingBatch = load(SortingBatchImpl.class, batchId);
			sortingBatch.getSortingMeasurements().clear();
			sortingBatch.getQuantificationMeasurements().clear();
			getSession().delete(sortingBatch);

			// If possible, update the batch tree :
			if (parentCatchBatch != null) {
				SortingBatch existingSortingBatch = parentCatchBatch.getSortingBatchById().get(batchId);
				if (existingSortingBatch != null) {
					Batch parentBatch = existingSortingBatch.getParentBatch();
					parentCatchBatch.getSortingBatchById().remove(batchId);
					if (parentBatch != null) {
						parentBatch.getChildBatchs().remove(existingSortingBatch);
					}
				}
			}
		}
	}

	@Override
	public CatchBatch loadFullTreeWithCache(Integer catchBatchId, boolean useCache, boolean forceReload) {
		long time1 = 0;
		if (logger.isDebugEnabled()) {
			logger.debug("call loadFullTreeWithCache()");
			time1 = System.currentTimeMillis();
		}
		Session session = getSession();

		CatchBatch catchBatch = queryUniqueTyped("catchBatchOnly",
				"catchBatchId", IntegerType.INSTANCE, catchBatchId);

		if (catchBatch == null) {
			return null;
		}

		Map<Integer, SortingBatch> sortingBatchById = catchBatch.getSortingBatchById();

		session.evict(catchBatch);
		catchBatch.setChildBatchs(new HashSet<Batch>());
		// error de all-delete-orphan ?? catchBatch.getChildBatchs().clear();
		computeTechnicalWeights(catchBatch);

		Map<Integer, Integer> parentBatchMapById = new HashMap<Integer, Integer>();

		List<SortingBatch> list = queryListTyped("allBatch",
				"rootBatchId", IntegerType.INSTANCE, catchBatch.getId());
		Comparator<Batch> batchComparator = Batchs.newRankOrderComparator();

		for (SortingBatch source : list) {
			session.evict(source);

			// compute weights
			computeTechnicalWeights(source);

			// source.setChildBatchs(new TreeSet<Batch>(batchComparator));
			source.setChildBatchs(new TreeSet<Batch>(batchComparator));
			// error de all-delete-orphan ?? source.getChildBatchs().clear();
			Integer parentBatchId = source.getParentBatch().getId();
			// Add result into a maps
			sortingBatchById.put(source.getId(), source);
			if (parentBatchId != null) {
				parentBatchMapById.put(source.getId(), parentBatchId);
			}
		}

		// Retrieve the parent links for all batchs
		for (SortingBatch batch : sortingBatchById.values()) {
			// If retrieve the parent from the parent map
			Integer parentbatchId = parentBatchMapById.get(batch.getId());
			if (parentbatchId != null) {
				SortingBatch parentBatch = sortingBatchById.get(parentbatchId);

				// If found, link the batch with its parent :
				if (parentBatch != null) {
					batch.setParentBatch(parentBatch);
					parentBatch.getChildBatchs().add(batch);
				}

				// If no parent found, the batch should be a direct child of the catch batch
				else if (parentbatchId.equals(catchBatch.getId())) {
					catchBatch.getChildBatchs().add(batch);
				}
			}
		}

		// Apply inheritance, starting with the catch batch children
		applyInheritance(catchBatch.getChildBatchs(), null, null, null, false, 1);

		if (logger.isDebugEnabled()) {
			logger.debug("end of loadFullTreeWithCache() - loading in "
					+ (System.currentTimeMillis() - time1)
					+ " ms.");
		}

		return catchBatch;
	}

	@Override
	public boolean isCatchBatchExistsForFishingOperation(Integer fishingOperationId) {
		Preconditions.checkNotNull(fishingOperationId);

		Integer catchBatchId = queryUniqueTyped("fishingOperationCatchBatchId",
				"fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
		return catchBatchId != null;
	}

	@Override
	public Integer getIdByFishingOperationId(Integer fishingOperationId) {
		Preconditions.checkNotNull(fishingOperationId);

		Integer catchBatchId = queryUniqueTyped("fishingOperationCatchBatchId",
				"fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
		if (catchBatchId == null) {
			throw new DataRetrievalFailureException("Unable to retrieve catch batch for fishing operation id=" + fishingOperationId);
		}
		return catchBatchId;
	}

	@Override
	public Integer getIdBySortingBatchId(Integer batchId) {
		Preconditions.checkNotNull(batchId);

		Integer catchBatchId = queryUniqueTyped("rootBatchId",
				"sortingBatchId", IntegerType.INSTANCE, batchId);
		if (catchBatchId == null) {
			throw new DataRetrievalFailureException("Unable to retrieve root catch batch for batch id=" + batchId);
		}
		return catchBatchId;
	}

	@Override
	public SortingBatch getSortingBatchById(CatchBatch catchBatch, Integer sortingBatchId) {
		Preconditions.checkNotNull(catchBatch);
		Preconditions.checkNotNull(sortingBatchId);
		Preconditions.checkNotNull(catchBatch.getSortingBatchById());

		SortingBatch sortingBatch = catchBatch.getSortingBatchById().get(sortingBatchId);
		if (sortingBatch == null) {
			throw new DataRetrievalFailureException(
					"Could not found batch with id="
							+ sortingBatchId
							+ " in the batch tree elements. Make sure the cache has been cleaned, since the last update of the tree.");
		}
		return sortingBatch;
	}

	@Override
	public QuantificationMeasurement setQuantificationMeasurement(
			Batch batch, Integer pmfmId, Integer recorderDepartmentId,
			Float weightValue, boolean isReferenceQuantitification) {
		QuantificationMeasurement quantificationMeasurement = getQuantificationMeasurement(
				batch, pmfmId, recorderDepartmentId, true);

		quantificationMeasurement.setNumericalValue(weightValue);
		quantificationMeasurement
				.setIsReferenceQuantification(isReferenceQuantitification);
		return quantificationMeasurement;
	}

	@Override
	public QuantificationMeasurement getQuantificationMeasurement(
			Batch batch, Integer pmfmId, Integer recorderDepartmentId,
			boolean createIfNotExists) {
		QuantificationMeasurement quantificationMeasurement = null;
		if (batch.getQuantificationMeasurements() != null) {
			for (QuantificationMeasurement qm : batch
					.getQuantificationMeasurements()) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					quantificationMeasurement = qm;
					break;
				}
			}
		}
		if (quantificationMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			quantificationMeasurement = QuantificationMeasurement.Factory
					.newInstance();
			quantificationMeasurement.setBatch(batch);
			if (batch.getQuantificationMeasurements() == null) {
				batch.setQuantificationMeasurements(Sets
						.newHashSet(quantificationMeasurement));
			} else {
				batch.getQuantificationMeasurements().add(
						quantificationMeasurement);
			}
			quantificationMeasurement.setQualityFlag(load(
					QualityFlagImpl.class,
					QualityFlagCode.NOTQUALIFIED.getValue()));
			quantificationMeasurement.setDepartment(load(DepartmentImpl.class,
					recorderDepartmentId));
			quantificationMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		return quantificationMeasurement;
	}

	@Override
	public SortingMeasurement getSortingMeasurement(
			SortingBatch sortingBatch, Integer pmfmId, Integer recorderDepartmentId,
			boolean createIfNotExists) {
		SortingMeasurement sortingMeasurement = null;
		if (sortingBatch.getSortingMeasurements() != null) {
			for (SortingMeasurement qm : sortingBatch
					.getSortingMeasurements()) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					sortingMeasurement = qm;
					break;
				}
			}
		}
		if (sortingMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			sortingMeasurement = SortingMeasurement.Factory
					.newInstance();
			sortingMeasurement.setSortingBatch(sortingBatch);
			if (sortingBatch.getSortingMeasurements() == null) {
				sortingBatch.setSortingMeasurements(Sets
						.newHashSet(sortingMeasurement));
				sortingMeasurement.setRankOrder(1);
			} else {
				sortingBatch.getSortingMeasurements().add(
						sortingMeasurement);
				sortingMeasurement.setRankOrder(sortingBatch.getSortingMeasurements().size());
			}
			sortingMeasurement.setQualityFlag(load(
					QualityFlagImpl.class,
					QualityFlagCode.NOTQUALIFIED.getValue()));
			sortingMeasurement.setDepartment(load(DepartmentImpl.class,
					recorderDepartmentId));
			sortingMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		return sortingMeasurement;
	}

	@Override
	public SortingMeasurement getInheritedSortingMeasurement(
			SortingBatch sortingBatch, Integer pmfmId) {
		if (sortingBatch.getInheritedSortingMeasurements() != null) {
			for (SortingMeasurement qm : sortingBatch
					.getInheritedSortingMeasurements()) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					return qm;
				}
			}
		}
		return null;
	}

	@Override
	public SortingBatch createSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
		SortingBatch result = sortingBatchDao.create(sortingBatch);

		// Refresh batch tree
		// refreshSortingBatchInBatchTree(result, parentCatchBatch);

		return result;
	}

	@Override
	public SortingBatch loadSortingBatch(Integer sortingBatchId, CatchBatch parentCatchBatch) {
		SortingBatch result = parentCatchBatch.getSortingBatchById().get(sortingBatchId);
		if (result == null) {
			result = sortingBatchDao.load(sortingBatchId);
			// refreshSortingBatchInBatchTree(result, parentCatchBatch);
		}
		return result;
	}

	@Override
	public void updateSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
		sortingBatchDao.update(sortingBatch);
		// refreshSortingBatchInBatchTree(sortingBatch, parentCatchBatch);
	}

	@Override
	public void updateSortingBatch(List<SortingBatch> sortingBatchs, CatchBatch parentCatchBatch) {
		sortingBatchDao.update(sortingBatchs);
		// for (SortingBatch sortingBatch : sortingBatchs) {
		// refreshSortingBatchInBatchTree(sortingBatch, parentCatchBatch);
		// }
	}

	// ------------------------------------------------------------------------//
	// -- Internal methods --//
	// ------------------------------------------------------------------------//

	protected void applyInheritance(Collection<Batch> batchs,
			List<SortingMeasurement> inheritedSortingMeasurements,
			Integer inheritedTaxonGroupId,
			Integer inheritedReferenceTaxonId,
			boolean inheritedExhaustiveInventory,
			int treeLevel) {
		if (batchs == null || batchs.size() == 0) {
			return;
		}
		for (Batch notCastedBatch : batchs) {
			SortingBatch batch = (SortingBatch) notCastedBatch;
			// Apply sorting measurements inheritance, if need
			if (inheritedSortingMeasurements != null && inheritedSortingMeasurements.size() > 0) {
				batch.getInheritedSortingMeasurements().clear();
				batch.getInheritedSortingMeasurements().addAll(inheritedSortingMeasurements);
			}

			// Apply taxon group and reference taxon inheritance, if need
			if (batch.getReferenceTaxon() == null && inheritedReferenceTaxonId != null) {
				batch.setInheritedReferenceTaxonId(inheritedReferenceTaxonId);
			}
			if (batch.getTaxonGroup() == null && inheritedTaxonGroupId != null) {
				batch.setInheritedTaxonGroupId(inheritedTaxonGroupId);
			}

			// Exhaustive inventory inheritance, if need
			if (inheritedExhaustiveInventory) {
				batch.setExhaustiveInventory(inheritedExhaustiveInventory);
			} else {
				batch.setExhaustiveInventory(false);
			}

			batch.setTreeLevel((short) treeLevel);

			if (batch.getChildBatchs() != null && batch.getChildBatchs().size() > 0) {
				List<SortingMeasurement> newInheritedSortingMeasurement = Lists.newArrayList();
				if (inheritedSortingMeasurements != null) {
					newInheritedSortingMeasurement.addAll(inheritedSortingMeasurements);
				}
				newInheritedSortingMeasurement.addAll(batch.getSortingMeasurements());

				// Recursive call : propagate species and sorted/unsorted value
				applyInheritance(batch.getChildBatchs(),
						newInheritedSortingMeasurement,
						batch.getTaxonGroup() == null ? null : batch.getTaxonGroup().getId(),
						batch.getReferenceTaxon() == null ? null : batch.getReferenceTaxon().getId(),
						batch.isExhaustiveInventory(),
						treeLevel + 1);
			}

		}
	}

	protected void applyInheritanceOnOneChild(SortingBatch parentBatch, SortingBatch batchToUpdate) {
		int treeLevel = parentBatch.getTreeLevel();

		if (parentBatch.getChildBatchs() != null && parentBatch.getChildBatchs().size() > 0) {
			List<SortingMeasurement> newInheritedSortingMeasurement = Lists.newArrayList();

			if (parentBatch.getInheritedSortingMeasurements() != null) {
				newInheritedSortingMeasurement.addAll(parentBatch.getInheritedSortingMeasurements());
			}
			newInheritedSortingMeasurement.addAll(parentBatch.getSortingMeasurements());

			// Recursive call : propagate species and sorted/unsorted value
			applyInheritance(Lists.newArrayList((Batch) batchToUpdate),
					newInheritedSortingMeasurement,
					parentBatch.getTaxonGroup() == null ? null : parentBatch.getTaxonGroup().getId(),
					parentBatch.getReferenceTaxon() == null ? null : parentBatch.getReferenceTaxon().getId(),
					parentBatch.isExhaustiveInventory(),
					treeLevel + 1);
		}
	}

	protected void computeTechnicalWeights(Batch batch) {
		Float weight = null;
		for (QuantificationMeasurement qm : batch.getQuantificationMeasurements()) {
			if (qm.getIsReferenceQuantification()) {
				weight = qm.getNumericalValue();
				batch.setWeightMethodId(qm.getPmfm().getMethod().getId());
			}
		}

		if (weight == null) {
			return;
		}
		if (batch instanceof SortingBatch) {
			SortingBatch sortingBatch = (SortingBatch) batch;
			String samplingRatioText = sortingBatch.getSamplingRatioText();
			Float samplingRatio = sortingBatch.getSamplingRatio();
			String startStr = weight.toString().replace(',', '.') + "/";
			if (samplingRatioText != null && samplingRatioText.startsWith(startStr)) {
				String weightStr = samplingRatioText.substring(startStr.length());
				if (weightStr != null && !weightStr.isEmpty()) {
					batch.setWeightBeforeSampling(Float.parseFloat(weightStr));
				}
			} else if (samplingRatio != null) {
				batch.setWeightBeforeSampling(weight / samplingRatio);
			}
			batch.setWeight(weight);
		} else if (batch instanceof fr.ifremer.adagio.core.dao.data.batch.CatchBatch) {
			fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = (fr.ifremer.adagio.core.dao.data.batch.CatchBatch) batch;
			catchBatch.setWeight(weight);
		}

	}

	protected Integer getCatchBatchIdByBatchId(String batchId) {
		Preconditions.checkNotNull(batchId);

		Integer catchBatchId = queryUniqueTyped("rootBatchId",
				"batchId", IntegerType.INSTANCE, Integer.valueOf(batchId));
		if (catchBatchId == null) {
			throw new DataRetrievalFailureException("Unable to retrieve root catch batch for batch id=" + batchId);
		}
		return catchBatchId;
	}

	protected void refreshSortingBatchInBatchTree(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
		Preconditions.checkNotNull(sortingBatch);
		Preconditions.checkNotNull(sortingBatch.getId());
		Preconditions.checkNotNull(sortingBatch.getParentBatch());
		Preconditions.checkNotNull(sortingBatch.getParentBatch().getId());
		Preconditions.checkNotNull(parentCatchBatch);
		Preconditions.checkNotNull(parentCatchBatch.getId());

		// Retrieve parent batch
		Integer parentBatchId = sortingBatch.getParentBatch().getId();
		Batch parentBatch;
		if (parentBatchId.equals(parentCatchBatch.getId()))
			parentBatch = parentCatchBatch;
		else {
			parentBatch = parentCatchBatch.getSortingBatchById().get(parentBatchId);
		}

		// Update sortingBatch parent if need
		if (parentBatch == null) {
			refreshSortingBatchInBatchTree((SortingBatch) sortingBatch.getParentBatch(), parentCatchBatch);
			parentBatch = sortingBatch.getParentBatch();
		} else if (sortingBatch.getParentBatch() != parentBatch) {
			sortingBatch.setParentBatch(parentBatch);
		}

		// Update child into the parent batch
		if (!parentBatch.getChildBatchs().contains(sortingBatch)) {
			parentBatch.getChildBatchs().add(sortingBatch);
		}
		if (parentBatch instanceof SortingBatch) {
			applyInheritanceOnOneChild((SortingBatch) parentBatch, sortingBatch);
		}

		// Update the batch in the usefull map, stored in catchBatch
		SortingBatch existingSortingbatch = parentCatchBatch.getSortingBatchById().get(sortingBatch.getId());
		if (existingSortingbatch == null || existingSortingbatch != sortingBatch) {
			parentCatchBatch.getSortingBatchById().put(sortingBatch.getId(), existingSortingbatch);
		}

		// update computed weight
		computeTechnicalWeights(sortingBatch);
	}

	@Override
	public void setSortingBatchReferenceTaxon(String batchId, Integer referenceTaxonId) {
		Preconditions.checkNotNull(batchId);
		Preconditions.checkNotNull(referenceTaxonId);

		if (logger.isDebugEnabled()) {
			logger.debug("Changing reference taxon for batch id=" + batchId);
		}

		int rowUpdated = queryUpdate("updateSortingBatchReferenceTaxon",
				"sortingBatchId", IntegerType.INSTANCE, Integer.valueOf(batchId),
				"referenceTaxonId", IntegerType.INSTANCE, referenceTaxonId);
		Preconditions.checkArgument(rowUpdated == 1, "Unable to update batch reference taxon.");
	}

	protected void getAllChildrenIds(Integer batchId, List<Integer> result) {
		Iterator<Object[]> childRows = queryIteratorTyped("childBatchIds",
				"parentBatchId", IntegerType.INSTANCE, batchId);
		while (childRows.hasNext()) {
			Object[] childRow = childRows.next();
			Integer childBatchId = (Integer) childRow[0];

			getAllChildrenIds(childBatchId, result);
		}
		result.add(batchId);
	}
}