// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.user.ageReader;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Un lecteur d’âge (Person) peut avoir différents niveaux de qualification
 * (AgeReaderQualification). Un niveau de qualification est limité dans le temps, par une période
 * début/fin (la date de fin peut être vide si la qualification est toujours d’actualité).
 * Un niveau de qualification est constitué par une valeur entière positive (qualificationLevel) qui
 * représente le pourcentage de réussite de lecture reconnu du lecteur.
 * Un niveau de qualification s’applique à une espèce scientifique (ReferenceTaxon, de niveau espèce
 * ou sous-espèce seulement, ou bien genre, famille,  etc .) et une ou plusieurs zones en mer
 * (Location). Les zones en mer peuvent être des zones FAO, sous zones FAO, divisions, sous
 * divisions, rectangles, etc.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class AgeReaderQualification
    implements Serializable, Comparable<AgeReaderQualification>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -167617262123227208L;

    // Generate 4 attributes
    private Integer id;

    /**
     * Identifiant interne. généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne. généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDate;

    /**
     * 
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * 
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * 
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * 
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private Integer qualificationLevel;

    /**
     * 
     * @return this.qualificationLevel Integer
     */
    public Integer getQualificationLevel()
    {
        return this.qualificationLevel;
    }

    /**
     * 
     * @param qualificationLevelIn Integer
     */
    public void setQualificationLevel(Integer qualificationLevelIn)
    {
        this.qualificationLevel = qualificationLevelIn;
    }

    // Generate 3 associations
    private Collection<Person> people = new HashSet<Person>();

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.people Collection<Person>
     */
    public Collection<Person> getPeople()
    {
        return this.people;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param peopleIn Collection<Person>
     */
    public void setPeople(Collection<Person> peopleIn)
    {
        this.people = peopleIn;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToAdd Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addPeople(Person elementToAdd)
    {
        return this.people.add(elementToAdd);
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToRemove Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removePeople(Person elementToRemove)
    {
        return this.people.remove(elementToRemove);
    }

    private Collection<Location> locations = new HashSet<Location>();

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.locations Collection<Location>
     */
    public Collection<Location> getLocations()
    {
        return this.locations;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param locationsIn Collection<Location>
     */
    public void setLocations(Collection<Location> locationsIn)
    {
        this.locations = locationsIn;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param elementToAdd Location
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLocations(Location elementToAdd)
    {
        return this.locations.add(elementToAdd);
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param elementToRemove Location
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLocations(Location elementToRemove)
    {
        return this.locations.remove(elementToRemove);
    }

    private ReferenceTaxon referenceTaxon;

    /**
     * 
     * @return this.referenceTaxon ReferenceTaxon
     */
    public ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    /**
     * 
     * @param referenceTaxonIn ReferenceTaxon
     */
    public void setReferenceTaxon(ReferenceTaxon referenceTaxonIn)
    {
        this.referenceTaxon = referenceTaxonIn;
    }

    /**
     * Returns <code>true</code> if the argument is an AgeReaderQualification instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof AgeReaderQualification))
        {
            return false;
        }
        final AgeReaderQualification that = (AgeReaderQualification)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link AgeReaderQualification}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link AgeReaderQualification}.
         * @return new AgeReaderQualificationImpl()
         */
        public static AgeReaderQualification newInstance()
        {
            return new AgeReaderQualificationImpl();
        }

        /**
         * Constructs a new instance of {@link AgeReaderQualification}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDate Date
         * @param qualificationLevel Integer
         * @param locations Collection<Location>
         * @param referenceTaxon ReferenceTaxon
         * @return newInstance
         */
        public static AgeReaderQualification newInstance(Date startDate, Integer qualificationLevel, Collection<Location> locations, ReferenceTaxon referenceTaxon)
        {
            final AgeReaderQualification entity = new AgeReaderQualificationImpl();
            entity.setStartDate(startDate);
            entity.setQualificationLevel(qualificationLevel);
            entity.setLocations(locations);
            entity.setReferenceTaxon(referenceTaxon);
            return entity;
        }

        /**
         * Constructs a new instance of {@link AgeReaderQualification}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param qualificationLevel Integer
         * @param people Collection<Person>
         * @param locations Collection<Location>
         * @param referenceTaxon ReferenceTaxon
         * @return newInstance AgeReaderQualification
         */
        public static AgeReaderQualification newInstance(Date startDate, Date endDate, Integer qualificationLevel, Collection<Person> people, Collection<Location> locations, ReferenceTaxon referenceTaxon)
        {
            final AgeReaderQualification entity = new AgeReaderQualificationImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setQualificationLevel(qualificationLevel);
            entity.setPeople(people);
            entity.setLocations(locations);
            entity.setReferenceTaxon(referenceTaxon);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(AgeReaderQualification o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getQualificationLevel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationLevel().compareTo(o.getQualificationLevel()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// AgeReaderQualification.java merge-point
}