// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.programStrategy;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import java.io.Serializable;

/**
 * Définit les Taxons relatifs à une stratégie de collecte, éventuellement le niveau de priorité de
 * la collecte sur le Taxon.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class ReferenceTaxonStrategy
    implements Serializable, Comparable<ReferenceTaxonStrategy>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 2855010865998655924L;

    private ReferenceTaxonStrategyPK referenceTaxonStrategyPk;

    /**
     * Get the composite primary key identifier class
     * @return referenceTaxonStrategyPk
     */
    public ReferenceTaxonStrategyPK getReferenceTaxonStrategyPk()
    {
        return this.referenceTaxonStrategyPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param referenceTaxonStrategyPkIn
     */
    public void setReferenceTaxonStrategyPk(ReferenceTaxonStrategyPK referenceTaxonStrategyPkIn) {
        this.referenceTaxonStrategyPk = referenceTaxonStrategyPkIn;
    }

    // Generate 1 attributes
    private Short priorityLevel;

    /**
     * Niveau de priorité de collecte de données sur un taxon. Si non renseigné, il faut alors
     * considérer qu'aucun niveau de priorité n'est utilisé dans la stratégie.
     * Exemple :
     * Dans l'échantillonnage à terre, il existe trois niveaux de priorité de collecte d'espèces :
     * - priorité 1 : Anguille (Anguilla anguilla), crevettes rouges (Aristeomorpha foliacea,
     * Aristeus antennatus), anchois (Engraulis encrasilosus), merlu (Merluccius merluccius),
     * rougets (Mullus barbatus, Mullus surmuletus), langoustine (Nephrops norvegicus), crevette
     * blanche (Parapenaeus longirostris), sole (solea vulgaris), sardine (Sardina pilchardus),
     * auxquels s’ajoutent toutes les espèces de thonidés et les elasmobranches (raies et requins).
     * - priorité 2 : On citera pour le golfe du Lion les baudroies (Lophius spp.), le bar
     * (Dicentrarchus labrax), le poulpe (eledone spp., Octopus vulgaris), les encornets (Illex
     * spp., Todadores spp.), les grondins (Eutrigla gurnardus, Trigla lucerna), le maquereau
     * (Scomber spp.), la dorade royale (Sparus aurata) et le chinchard (Trachurus trachurus).
     * @return this.priorityLevel Short
     */
    public Short getPriorityLevel()
    {
        return this.priorityLevel;
    }

    /**
     * Niveau de priorité de collecte de données sur un taxon. Si non renseigné, il faut alors
     * considérer qu'aucun niveau de priorité n'est utilisé dans la stratégie.
     * Exemple :
     * Dans l'échantillonnage à terre, il existe trois niveaux de priorité de collecte d'espèces :
     * - priorité 1 : Anguille (Anguilla anguilla), crevettes rouges (Aristeomorpha foliacea,
     * Aristeus antennatus), anchois (Engraulis encrasilosus), merlu (Merluccius merluccius),
     * rougets (Mullus barbatus, Mullus surmuletus), langoustine (Nephrops norvegicus), crevette
     * blanche (Parapenaeus longirostris), sole (solea vulgaris), sardine (Sardina pilchardus),
     * auxquels s’ajoutent toutes les espèces de thonidés et les elasmobranches (raies et requins).
     * - priorité 2 : On citera pour le golfe du Lion les baudroies (Lophius spp.), le bar
     * (Dicentrarchus labrax), le poulpe (eledone spp., Octopus vulgaris), les encornets (Illex
     * spp., Todadores spp.), les grondins (Eutrigla gurnardus, Trigla lucerna), le maquereau
     * (Scomber spp.), la dorade royale (Sparus aurata) et le chinchard (Trachurus trachurus).
     * @param priorityLevelIn Short
     */
    public void setPriorityLevel(Short priorityLevelIn)
    {
        this.priorityLevel = priorityLevelIn;
    }

    // Generate 2 associations
    private ReferenceTaxon referenceTaxon;

    /**
     * 
     * @return this.referenceTaxon ReferenceTaxon
     */
    public ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    /**
     * 
     * @param referenceTaxonIn ReferenceTaxon
     */
    public void setReferenceTaxon(ReferenceTaxon referenceTaxonIn)
    {
        this.referenceTaxon = referenceTaxonIn;
    }

    private Strategy strategy;

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @return this.strategy Strategy
     */
    public Strategy getStrategy()
    {
        return this.strategy;
    }

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @param strategyIn Strategy
     */
    public void setStrategy(Strategy strategyIn)
    {
        this.strategy = strategyIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link ReferenceTaxonStrategy}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link ReferenceTaxonStrategy}.
         * @return new ReferenceTaxonStrategyImpl()
         */
        public static ReferenceTaxonStrategy newInstance()
        {
            return new ReferenceTaxonStrategyImpl();
        }

        /**
         * Constructs a new instance of {@link ReferenceTaxonStrategy}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param referenceTaxon ReferenceTaxon
         * @param strategy Strategy
         * @return newInstance
         */
        public static ReferenceTaxonStrategy newInstance(ReferenceTaxon referenceTaxon, Strategy strategy)
        {
            final ReferenceTaxonStrategy entity = new ReferenceTaxonStrategyImpl();
            entity.setReferenceTaxon(referenceTaxon);
            entity.setStrategy(strategy);
            return entity;
        }

        /**
         * Constructs a new instance of {@link ReferenceTaxonStrategy}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param priorityLevel Short
         * @param referenceTaxon ReferenceTaxon
         * @param strategy Strategy
         * @return newInstance ReferenceTaxonStrategy
         */
        public static ReferenceTaxonStrategy newInstance(Short priorityLevel, ReferenceTaxon referenceTaxon, Strategy strategy)
        {
            final ReferenceTaxonStrategy entity = new ReferenceTaxonStrategyImpl();
            entity.setPriorityLevel(priorityLevel);
            entity.setReferenceTaxon(referenceTaxon);
            entity.setStrategy(strategy);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(ReferenceTaxonStrategy o)
    {
        int cmp = 0;
        if (this.getReferenceTaxonStrategyPk() != null)
        {
            cmp = this.getReferenceTaxonStrategyPk().compareTo(o.getReferenceTaxonStrategyPk());
        }
            if (this.getPriorityLevel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getPriorityLevel().compareTo(o.getPriorityLevel()));
            }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// ReferenceTaxonStrategy.java merge-point
}