// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.programStrategy;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;

/**
 * Niveau de saisie sur lequel un quadruplet PSFM peut avoir des résultats. Ce niveau de saisie est
 * défini via les stratégies.
 * Exemple :
 * • Opération
 * • Opération de prélèvement
 * • Lot (Quantification de lot ou Classement de lot)
 * • Echantillon
 * Typiquement, le PSFM "mesure par Ichtyomètre de la taille d'un poisson entier" pourra être saisit
 * sur un lot (comme critère de classement) et sur les résultats de mesure sur un échantillon
 * (effectuée en laboratoire). Ce PSFM pourra donc avoir les deux niveaus de saisie suivants : "Lot"
 * et "Echantillon"
 */
// HibernateEntity.vsl annotations merge-point
public abstract class AcquisitionLevel
    implements Serializable, Comparable<AcquisitionLevel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4776989455107956156L;

    // Generate 2 attributes
    private String code;

    /**
     * 
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * 
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    // Generate 6 associations
    /**
     * Returns <code>true</code> if the argument is an AcquisitionLevel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof AcquisitionLevel))
        {
            return false;
        }
        final AcquisitionLevel that = (AcquisitionLevel)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link AcquisitionLevel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link AcquisitionLevel}.
         * @return new AcquisitionLevelImpl()
         */
        public static AcquisitionLevel newInstance()
        {
            return new AcquisitionLevelImpl();
        }


        /**
         * Constructs a new instance of {@link AcquisitionLevel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @return newInstance AcquisitionLevel
         */
        public static AcquisitionLevel newInstance(String name)
        {
            final AcquisitionLevel entity = new AcquisitionLevelImpl();
            entity.setName(name);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(AcquisitionLevel o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// AcquisitionLevel.java merge-point
}