/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="feature-deploy", aggregator=true)
public class FeatureDeployMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="featureName", defaultValue="")
    private String featureName = "";
    @Parameter(property="goals", defaultValue="")
    private String goals = "";
    @Parameter(property="buildNumber", defaultValue="")
    private String buildNumber = "";
    @Component(hint="feature")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setNoDeploy(false).setEnableFeatureVersions(true).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setDefaultOriginUrl(this.defaultOriginUrl).setAllowRemote(this.isRemoteAllowed()).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.deploy(ctx, this.getReactorProjects(), this.session, this.buildNumber, this.goals);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error finishing feature: " + e.getMessage(), (Exception)e);
        }
    }
}

