/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.manager.tasks.CheckoutAndGetProjects;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.VersionCacheProvider;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdateDevelopWithPreviousVersionsCommand.class)
public class UpdateDevelopWithPreviousVersionsCommand
implements ExtensionCommand {
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private VersionCacheProvider versionCacheProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private BranchHelper branchHelper;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private CheckoutAndGetProjects checkoutAndGetProjects;
    @Requirement
    private ContextProvider contextProvider;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand, JGitFlowReporter reporter) throws JGitFlowExtensionException {
        try {
            ReleaseContext ctx = this.contextProvider.getContext();
            JGitFlow flow = this.jGitFlowProvider.gitFlow();
            String originalBranchName = this.branchHelper.getCurrentBranchName();
            List<MavenProject> developProjects = this.checkoutAndGetProjects.run(flow.getDevelopBranchName()).getProjects();
            this.pomUpdater.copyPomVersionsFromMap(this.versionCacheProvider.getCachedVersions(), developProjects);
            this.projectHelper.commitAllPoms(git, developProjects, ctx.getScmCommentPrefix() + "Updating develop poms back to pre merge state" + ctx.getScmCommentSuffix());
            flow.git().checkout().setName(originalBranchName).call();
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating develop poms to previously cached versions", (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return null;
    }
}

