/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class Cache
implements TreeCache {
    private final ConcurrentMap<String, Tree> map;
    private final ConcurrentLinkedQueue<String> queue;
    private final AtomicInteger size;
    private final int capacity;

    public Cache(int capacity) {
        this(capacity, 16);
    }

    public Cache(int capacity, int concurrencyLevel) {
        this.map = new ConcurrentHashMap<String, Tree>(16, 0.75f, concurrencyLevel);
        this.queue = new ConcurrentLinkedQueue();
        this.size = new AtomicInteger();
        this.capacity = capacity;
    }

    public int size() {
        return this.size.get();
    }

    public Tree get(String expression) {
        return (Tree)this.map.get(expression);
    }

    public void put(String expression, Tree tree) {
        if (this.map.putIfAbsent(expression, tree) == null) {
            this.queue.offer(expression);
            if (this.size.incrementAndGet() > this.capacity) {
                this.size.decrementAndGet();
                this.map.remove(this.queue.poll());
            }
        }
    }
}

