/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.AnnotationFlags;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAnyAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDBorderStyle;
import de.intarsys.pdf.pd.PDCircleAnnotation;
import de.intarsys.pdf.pd.PDFileAttachmentAnnotation;
import de.intarsys.pdf.pd.PDHighlightAnnotation;
import de.intarsys.pdf.pd.PDInkAnnotation;
import de.intarsys.pdf.pd.PDLineAnnotation;
import de.intarsys.pdf.pd.PDLinkAnnotation;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPolygonAnnotation;
import de.intarsys.pdf.pd.PDPolylineAnnotation;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.pd.PDSquareAnnotation;
import de.intarsys.pdf.pd.PDSquigglyAnnotation;
import de.intarsys.pdf.pd.PDStampAnnotation;
import de.intarsys.pdf.pd.PDStrikeOutAnnotation;
import de.intarsys.pdf.pd.PDTextAnnotation;
import de.intarsys.pdf.pd.PDTextMarkupAnnotation;
import de.intarsys.pdf.pd.PDUnderlineAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PDAnnotation
extends PDObject
implements IAdditionalActionSupport {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_Rect = COSName.constant("Rect");
    public static final COSName DK_NM = COSName.constant("NM");
    public static final COSName DK_M = COSName.constant("M");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_BS = COSName.constant("BS");
    public static final COSName DK_Border = COSName.constant("Border");
    public static final COSName DK_AP = COSName.constant("AP");
    public static final COSName DK_AS = COSName.constant("AS");
    public static final COSName DK_C = COSName.constant("C");
    public static final COSName DK_CA = COSName.constant("CA");
    public static final COSName DK_IC = COSName.constant("IC");
    public static final COSName DK_A = COSName.constant("A");
    public static final COSName DK_StructParent = COSName.constant("StructParent");
    public static final COSName DK_OC = COSName.constant("OC");
    public static final COSName CN_Type_Annot = COSName.constant("Annot");
    public static final Set ANNOTATION_ACTION_TRIGGERS = new HashSet(11);
    private AnnotationFlags flags;
    private PDBorderStyle cachedBorderStyle;
    private CDSRectangle cachedRectangle;

    static {
        ANNOTATION_ACTION_TRIGGERS.add("E");
        ANNOTATION_ACTION_TRIGGERS.add("X");
        ANNOTATION_ACTION_TRIGGERS.add("D");
        ANNOTATION_ACTION_TRIGGERS.add("U");
        ANNOTATION_ACTION_TRIGGERS.add("Fo");
        ANNOTATION_ACTION_TRIGGERS.add("BI");
        ANNOTATION_ACTION_TRIGGERS.add("PO");
        ANNOTATION_ACTION_TRIGGERS.add("PC");
        ANNOTATION_ACTION_TRIGGERS.add("PV");
        ANNOTATION_ACTION_TRIGGERS.add("PI");
    }

    protected static COSDictionary copyAppearanceDict(COSDictionary cOSDictionary) {
        if (cOSDictionary == null) {
            return null;
        }
        COSDictionary cOSDictionary2 = COSDictionary.create();
        Iterator iterator = cOSDictionary.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSName cOSName = (COSName)entry.getKey();
            COSObject cOSObject = (COSObject)entry.getValue();
            if (cOSObject instanceof COSDictionary) {
                COSDictionary cOSDictionary3 = (COSDictionary)cOSObject;
                cOSObject = PDAnnotation.copyAppearanceDictInner(cOSDictionary3);
            } else if (cOSObject instanceof COSStream) {
                cOSObject = cOSObject.copyShallow();
            }
            cOSDictionary2.put(cOSName, cOSObject);
        }
        return cOSDictionary2;
    }

    protected static COSDictionary copyAppearanceDictInner(COSDictionary cOSDictionary) {
        COSDictionary cOSDictionary2 = COSDictionary.create();
        Iterator iterator = cOSDictionary.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSName cOSName = (COSName)entry.getKey();
            COSObject cOSObject = (COSObject)entry.getValue();
            if (cOSObject instanceof COSStream) {
                cOSObject = cOSObject.copyShallow();
            }
            cOSDictionary2.put(cOSName, cOSObject);
        }
        return cOSDictionary2;
    }

    protected PDAnnotation(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addAction(PDAction pDAction) {
        if (pDAction != null) {
            if (this.getAction() == null) {
                this.setAction(pDAction);
            } else {
                this.getAction().addNext(pDAction);
            }
        }
    }

    public int basicGetFlags() {
        return this.getFieldInt(DK_F, 0);
    }

    public void basicSetFlags(int n) {
        if (n != 0) {
            this.cosSetField(DK_F, COSInteger.create(n));
        } else {
            this.cosRemoveField(DK_F);
        }
    }

    public boolean canReceiveFocus() {
        return !this.isReadOnly() && !this.isHidden() && !this.isNoView() && !this.isInvisible() && !this.isLocked();
    }

    protected void checkRectangle(CDSRectangle cDSRectangle) {
        float f = cDSRectangle.getWidth();
        float f2 = cDSRectangle.getHeight();
        if (f <= 0.0f && f2 <= 0.0f) {
            f = this.getDefaultWidth();
            f2 = this.getDefaultHeight();
        }
        if (f < this.getMinWidth()) {
            f = this.getMinWidth();
        }
        if (f2 < this.getMinHeight()) {
            f2 = this.getMinHeight();
        }
        cDSRectangle.resizeTo(f, f2);
    }

    public PDAnnotation copy() {
        COSDictionary cOSDictionary = (COSDictionary)this.cosGetDict().copyShallow();
        PDAnnotation pDAnnotation = (PDAnnotation)META.createFromCos(cOSDictionary);
        pDAnnotation.cosRemoveField(DK_P);
        pDAnnotation.cosRemoveField(PDAcroFormField.DK_Parent);
        pDAnnotation.cosRemoveField(PDAcroFormField.DK_T);
        pDAnnotation.cosRemoveField(PDAcroFormField.DK_TU);
        pDAnnotation.cosRemoveField(DK_M);
        pDAnnotation.cosRemoveField(PDAcroFormField.DK_V);
        COSDictionary cOSDictionary2 = PDAnnotation.copyAppearanceDict(this.cosGetField(DK_AP).asDictionary());
        pDAnnotation.cosSetField(DK_AP, cOSDictionary2);
        return pDAnnotation;
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Annot;
    }

    @Deprecated
    public void dispose() {
        PDPage pDPage = PDAnnotationTools.getPage(this);
        if (pDPage != null) {
            pDPage.removeAnnotation(this);
        }
    }

    public PDAction getAction() {
        COSObject cOSObject = this.cosGetField(DK_A);
        if (cOSObject.isNull()) {
            return null;
        }
        return (PDAction)PDAction.META.createFromCos(cOSObject);
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary cOSDictionary = this.cosGetField(DK_AA).asDictionary();
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(cOSDictionary);
    }

    public PDAppearance getAppearance() {
        COSObject cOSObject = this.cosGetField(DK_AP);
        if (cOSObject.isNull()) {
            return null;
        }
        return (PDAppearance)PDAppearance.META.createFromCos(cOSObject);
    }

    public COSName getAppearanceState() {
        return this.cosGetField(DK_AS).asName();
    }

    public Set getAppearanceStates() {
        HashSet hashSet = new HashSet();
        COSDictionary cOSDictionary = this.cosGetField(DK_AP).asDictionary();
        if (cOSDictionary != null) {
            COSDictionary cOSDictionary2 = cOSDictionary.get(PDAppearance.DK_N).asDictionary();
            if (cOSDictionary2 != null) {
                hashSet.addAll(cOSDictionary2.keySet());
            }
            if ((cOSDictionary2 = cOSDictionary.get(PDAppearance.DK_D).asDictionary()) != null) {
                hashSet.addAll(cOSDictionary2.keySet());
            }
            if ((cOSDictionary2 = cOSDictionary.get(PDAppearance.DK_N).asDictionary()) != null) {
                hashSet.addAll(cOSDictionary2.keySet());
            }
        }
        return hashSet;
    }

    public PDBorderStyle getBorderStyle() {
        COSObject cOSObject;
        if (this.cachedBorderStyle == null && !(cOSObject = this.cosGetField(DK_BS)).isNull()) {
            this.cachedBorderStyle = (PDBorderStyle)PDBorderStyle.META.createFromCos(cOSObject);
        }
        return this.cachedBorderStyle;
    }

    public COSName getBorderStyleName() {
        PDBorderStyle pDBorderStyle = this.getBorderStyle();
        if (pDBorderStyle == null) {
            return PDBorderStyle.DK_S;
        }
        return pDBorderStyle.getStyle();
    }

    public float getBorderStyleWidth() {
        PDBorderStyle pDBorderStyle = this.getBorderStyle();
        if (pDBorderStyle == null) {
            return 1.0f;
        }
        return pDBorderStyle.getWidth();
    }

    public float[] getColor() {
        return this.getFieldFixedArray(DK_C, null);
    }

    public String getContents() {
        return this.getFieldMLString(DK_Contents, "");
    }

    public float getDefaultHeight() {
        return 1.0f;
    }

    public float getDefaultWidth() {
        return 1.0f;
    }

    public AnnotationFlags getFlags() {
        if (this.flags == null) {
            this.flags = new AnnotationFlags(this);
        }
        return this.flags;
    }

    public float getMinHeight() {
        float f = this.getBorderStyleWidth();
        return 2.0f * f;
    }

    public float getMinWidth() {
        float f = this.getBorderStyleWidth();
        return 2.0f * f;
    }

    public CDSDate getModified() {
        return CDSDate.createFromCOS(this.cosGetField(DK_M).asString());
    }

    public String getName() {
        return this.getFieldString(DK_NM, null);
    }

    public CDSRectangle getNormalizedRectangle() {
        CDSRectangle cDSRectangle = this.getRectangle();
        if (cDSRectangle == null) {
            return null;
        }
        return cDSRectangle.copy().normalize();
    }

    public PDPage getPage() {
        COSObject cOSObject = this.cosGetField(DK_P);
        return (PDPage)PDPageNode.META.createFromCos(cOSObject);
    }

    public CDSRectangle getRectangle() {
        if (this.cachedRectangle == null) {
            COSArray cOSArray = this.cosGetField(DK_Rect).asArray();
            if (cOSArray == null) {
                return null;
            }
            this.cachedRectangle = CDSRectangle.createFromCOS(cOSArray);
        }
        return this.cachedRectangle;
    }

    protected Integer getStructParent() {
        COSInteger cOSInteger = this.cosGetField(DK_StructParent).asInteger();
        if (cOSInteger != null) {
            new Integer(cOSInteger.intValue());
        }
        return null;
    }

    public abstract String getSubtypeLabel();

    @Override
    public Set getSupportedTriggerEvents() {
        return ANNOTATION_ACTION_TRIGGERS;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        CDSRectangle cDSRectangle = new CDSRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        this.setRectangle(cDSRectangle);
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedBorderStyle = null;
        this.cachedRectangle = null;
    }

    public boolean isHidden() {
        return this.getFlags().isHidden();
    }

    public boolean isInvisible() {
        return this.getFlags().isInvisible();
    }

    public boolean isLocked() {
        return this.getFlags().isLocked();
    }

    public boolean isMarkupAnnotation() {
        return false;
    }

    public boolean isNoRotate() {
        return this.getFlags().isNoRotate();
    }

    public boolean isNoView() {
        return this.getFlags().isNoView();
    }

    public boolean isNoZoom() {
        return this.getFlags().isNoZoom();
    }

    public boolean isPrint() {
        return this.getFlags().isPrint();
    }

    public boolean isReadOnly() {
        return this.getFlags().isReadOnly();
    }

    public boolean isToggleNoView() {
        return this.getFlags().isToggleNoView();
    }

    public boolean isWidgetAnnotation() {
        return false;
    }

    public void setAction(PDAction pDAction) {
        this.setFieldObject(DK_A, pDAction);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions pDAdditionalActions) {
        this.setFieldObject(DK_AA, pDAdditionalActions);
    }

    public void setAppearance(PDAppearance pDAppearance) {
        this.setFieldObject(DK_AP, pDAppearance);
    }

    public void setAppearanceState(COSName cOSName) {
        this.cosSetField(DK_AS, cOSName);
    }

    public void setBorderStyle(PDBorderStyle pDBorderStyle) {
        this.setFieldObject(DK_BS, pDBorderStyle);
    }

    public void setBorderStyleName(COSName cOSName) {
        PDBorderStyle pDBorderStyle = this.getBorderStyle();
        if (pDBorderStyle == null) {
            pDBorderStyle = (PDBorderStyle)PDBorderStyle.META.createNew();
            this.setBorderStyle(pDBorderStyle);
        }
        pDBorderStyle.setStyle(cOSName);
    }

    public void setBorderStyleWidth(float f) {
        PDBorderStyle pDBorderStyle = this.getBorderStyle();
        if (pDBorderStyle == null) {
            pDBorderStyle = (PDBorderStyle)PDBorderStyle.META.createNew();
            this.setBorderStyle(pDBorderStyle);
        }
        pDBorderStyle.setWidth(f);
    }

    public void setColor(float[] fArray) {
        this.setFieldFixedArray(DK_C, fArray);
    }

    public void setContents(String string) {
        this.setFieldString(DK_Contents, string);
    }

    public void setHidden(boolean bl) {
        this.getFlags().setHidden(bl);
    }

    public void setInvisible(boolean bl) {
        this.getFlags().setInvisible(bl);
    }

    public void setLocked(boolean bl) {
        this.getFlags().setLocked(bl);
    }

    protected void setModified(String string) {
        this.setFieldString(DK_M, string);
    }

    public void setName(String string) {
        this.setFieldString(DK_NM, string);
    }

    public void setNoRotate(boolean bl) {
        this.getFlags().setNoRotate(bl);
    }

    public void setNoView(boolean bl) {
        this.getFlags().setNoView(bl);
    }

    public void setNoZoom(boolean bl) {
        this.getFlags().setNoZoom(bl);
    }

    protected void setPage(PDPage pDPage) {
        this.setFieldObject(DK_P, pDPage);
    }

    public void setPrint(boolean bl) {
        this.getFlags().setPrint(bl);
    }

    public void setReadOnly(boolean bl) {
        this.getFlags().setReadOnly(bl);
    }

    public void setRectangle(CDSRectangle cDSRectangle) {
        this.checkRectangle(cDSRectangle);
        COSObject cOSObject = this.setFieldObject(DK_Rect, cDSRectangle);
        CDSRectangle cDSRectangle2 = CDSRectangle.createFromCOS(cOSObject.asArray());
        if (cDSRectangle2 != null) {
            this.updateStateRectangle(cDSRectangle2, cDSRectangle);
        }
    }

    protected void setStructParent(Integer n) {
        if (n != null) {
            this.setFieldInt(DK_StructParent, n);
        } else {
            this.cosRemoveField(DK_StructParent);
        }
    }

    public void setToggleNoView(boolean bl) {
        this.getFlags().setToggleNoView(bl);
    }

    public boolean supportsPrint() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Annotation: ");
        stringBuilder.append(this.cosGetSubtype());
        stringBuilder.append(" ");
        if (this.isWidgetAnnotation()) {
            PDAcroFormField pDAcroFormField = (PDAcroFormField)PDAcroFormField.META.createFromCos(this.cosGetDict());
            stringBuilder.append(pDAcroFormField.getQualifiedName());
            stringBuilder.append(" ");
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    public void touch() {
        this.setFieldObject(DK_M, new CDSDate());
    }

    protected void updateStateRectangle(CDSRectangle cDSRectangle, CDSRectangle cDSRectangle2) {
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            if (!(cOSObject instanceof COSDictionary)) {
                return null;
            }
            COSName cOSName = ((COSDictionary)cOSObject).get(DK_Subtype).asName();
            if (PDWidgetAnnotation.CN_Subtype_Widget.equals(cOSName)) {
                return PDWidgetAnnotation.META;
            }
            if (PDLinkAnnotation.CN_Subtype_Link.equals(cOSName)) {
                return PDLinkAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Ink.equals(cOSName)) {
                return PDInkAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Square.equals(cOSName)) {
                return PDSquareAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Circle.equals(cOSName)) {
                return PDCircleAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Line.equals(cOSName)) {
                return PDLineAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Polygon.equals(cOSName)) {
                return PDPolygonAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_PolyLine.equals(cOSName)) {
                return PDPolylineAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Highlight.equals(cOSName)) {
                return PDHighlightAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Underline.equals(cOSName)) {
                return PDUnderlineAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Squiggly.equals(cOSName)) {
                return PDSquigglyAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_StrikeOut.equals(cOSName)) {
                return PDStrikeOutAnnotation.META;
            }
            if (PDPopupAnnotation.CN_Subtype_Popup.equals(cOSName)) {
                return PDPopupAnnotation.META;
            }
            if (PDTextAnnotation.CN_Subtype_Text.equals(cOSName)) {
                return PDTextAnnotation.META;
            }
            if (PDFileAttachmentAnnotation.CN_Subtype_FileAttachment.equals(cOSName)) {
                return PDFileAttachmentAnnotation.META;
            }
            if (PDStampAnnotation.CN_Subtype_Stamp.equals(cOSName)) {
                return PDStampAnnotation.META;
            }
            return PDAnyAnnotation.META;
        }

        @Override
        public Class getRootClass() {
            return PDAnnotation.class;
        }
    }
}

