/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Windows {
    private Windows() {
    }

    public static void setIconImage(Window window, Image image) {
        Logger logger = LoggerFactory.getLogger(Windows.class);
        ReflectiveOperationException error = null;
        try {
            Method setIconMethod = Window.class.getMethod("setIconImage", Image.class);
            setIconMethod.invoke((Object)window, image);
        }
        catch (NoSuchMethodException e) {
            if (logger.isInfoEnabled()) {
                logger.info("No setIconImage-method found...");
            }
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (InvocationTargetException e) {
            error = e;
        }
        if (error != null && logger.isWarnEnabled()) {
            logger.warn("Exception while executing setIconImage-method!", (Throwable)error);
        }
    }

    public static void showWindow(Window window, Window centerParent, boolean pack) {
        Logger logger = LoggerFactory.getLogger(Windows.class);
        if (pack) {
            window.pack();
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        if (logger.isDebugEnabled()) {
            logger.debug("MaximumWindowBounds: {}", (Object)maxBounds);
        }
        Rectangle windowBounds = window.getBounds();
        if (logger.isDebugEnabled()) {
            logger.debug("Original windowBounds: {}", (Object)windowBounds);
        }
        if (windowBounds.width > maxBounds.width) {
            windowBounds.width = maxBounds.width;
        }
        if (windowBounds.height > maxBounds.height) {
            windowBounds.height = maxBounds.height;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Corrected windowBounds: {}", (Object)windowBounds);
        }
        Rectangle centerBounds = maxBounds;
        if (centerParent != null && centerParent.isVisible()) {
            centerBounds = centerParent.getBounds();
            if (logger.isDebugEnabled()) {
                logger.debug("Retrieved parent container bounds...");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("centerBounds: {}", (Object)centerBounds);
        }
        windowBounds.x = centerBounds.x + (centerBounds.width - windowBounds.width) / 2;
        windowBounds.y = centerBounds.y + (centerBounds.height - windowBounds.height) / 2;
        if (logger.isDebugEnabled()) {
            logger.debug("centered bounds: {}", (Object)windowBounds);
        }
        if (windowBounds.x < maxBounds.x) {
            windowBounds.x = maxBounds.x;
        }
        if (windowBounds.y < maxBounds.y) {
            windowBounds.y = maxBounds.y;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("corrected1: {}", (Object)windowBounds);
        }
        if (windowBounds.x + windowBounds.width > maxBounds.x + maxBounds.width) {
            windowBounds.x = maxBounds.width - windowBounds.width;
        }
        if (windowBounds.y + windowBounds.height > maxBounds.y + maxBounds.height) {
            windowBounds.y = maxBounds.height - windowBounds.height;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("corrected1: {}", (Object)windowBounds);
        }
        if (windowBounds.x < maxBounds.x) {
            windowBounds.x = maxBounds.x;
        }
        if (windowBounds.y < maxBounds.y) {
            windowBounds.y = maxBounds.y;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("changed bounds: {}", (Object)windowBounds);
        }
        window.setBounds(windowBounds);
        window.setVisible(true);
    }
}

