/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.docs;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.api.datatype.DataType;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.api.datatype.Value;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceApi;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedPackageElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.javadoc.JavaDocLink;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.PackageElement;

public class ApiDocsJavaDocTagHandler
implements JavaDocTagHandler {
    static final Pattern RAW_LINK_PATTERN = Pattern.compile("(?:^|[^>=\"'])(http.[^\"'<\\s]+)(?![^<>]*>|[^\"]*?<\\/a)");
    private final ApiRegistry registry;
    private final ApiRegistrationContext context;

    public ApiDocsJavaDocTagHandler(ApiRegistry registry, ApiRegistrationContext context) {
        this.registry = registry;
        this.context = context;
    }

    public String getTypeId() {
        return "api-docs";
    }

    public String onInlineTag(String tagName, String tagText, DecoratedElement context) {
        if ("link".equals(tagName)) {
            JavaDocLink link = JavaDocLink.parse((String)tagText);
            String classRef = link.getClassName();
            String subelementRef = link.getMemberName();
            String value = link.getLabel();
            if ("".equals(classRef)) {
                DecoratedElement type = context;
                while (!(type instanceof DecoratedTypeElement) && (type = (DecoratedElement)type.getEnclosingElement()) != null && !(type instanceof PackageElement)) {
                }
                if (type instanceof DecoratedTypeElement) {
                    classRef = ((DecoratedTypeElement)type).getQualifiedName().toString();
                }
            }
            if (!"".equals(classRef)) {
                if (classRef.indexOf(46) < 0) {
                    DecoratedElement pckg = context;
                    while (!(pckg instanceof DecoratedPackageElement) && (pckg = (DecoratedElement)pckg.getEnclosingElement()) != null) {
                    }
                    if (pckg != null) {
                        classRef = ((DecoratedPackageElement)pckg).getQualifiedName() + "." + classRef;
                    }
                }
                Set syntaxes = this.registry.getSyntaxes(this.context);
                for (Object syntax : syntaxes) {
                    List dataTypes = syntax.findDataTypes(classRef);
                    if (dataTypes == null || dataTypes.isEmpty()) continue;
                    DataType dataType = (DataType)dataTypes.get(0);
                    Value dataTypeValue = dataType.findValue(subelementRef);
                    if (dataTypeValue != null) {
                        return "<a href=\"" + dataType.getSlug() + ".html#" + dataTypeValue.getValue() + "\">" + (value != null ? value : dataTypeValue.getValue()) + "</a>";
                    }
                    Property property = dataType.findProperty(subelementRef);
                    if (property != null) {
                        return "<a href=\"" + dataType.getSlug() + ".html#prop-" + property.getName() + "\">" + (value != null ? value : property.getName()) + "</a>";
                    }
                    return "<a href=\"" + dataType.getSlug() + ".html\">" + (value != null ? value : (subelementRef.isEmpty() ? dataType.getLabel() : subelementRef)) + "</a>";
                }
                List resourceApis = this.registry.getResourceApis(this.context);
                for (ResourceApi resourceApi : resourceApis) {
                    Method method = resourceApi.findMethodFor(classRef, subelementRef);
                    if (method != null) {
                        if (value == null) {
                            value = method.getLabel() + " " + method.getResource().getGroup().getLabel();
                        }
                        return "<a href=\"" + method.getResource().getGroup().getSlug() + ".html#" + method.getSlug() + "\">" + value + "</a>";
                    }
                    ResourceGroup resourceGroup = resourceApi.findResourceGroupFor(classRef);
                    if (resourceGroup == null) continue;
                    if (value == null) {
                        value = resourceGroup.getLabel();
                    }
                    return "<a href=\"" + resourceGroup.getSlug() + ".html\">" + value + "</a>";
                }
                List serviceApis = this.registry.getServiceApis(this.context);
                for (ServiceApi serviceApi : serviceApis) {
                    Operation operation = serviceApi.findOperationFor(classRef, subelementRef);
                    if (operation != null) {
                        if (value == null) {
                            value = operation.getName();
                        }
                        return "<a href=\"" + operation.getService().getSlug() + ".html#" + operation.getSlug() + "\">" + value + "</a>";
                    }
                    Service service = serviceApi.findServiceFor(classRef);
                    if (service == null) continue;
                    if (value == null) {
                        value = service.getLabel();
                    }
                    return "<a href=\"" + service.getSlug() + ".html\">" + value + "</a>";
                }
            }
            return value != null ? value : tagText.trim();
        }
        if ("code".equals(tagName)) {
            return "<code>" + tagText + "</code>";
        }
        return tagText;
    }

    public String onBlockTag(String tagName, String value, DecoratedElement context) {
        if ("see".equals(tagName)) {
            if (value.startsWith("\"")) {
                return value;
            }
            if (value.startsWith("<")) {
                return value;
            }
            if (value.startsWith("http")) {
                return "<a target=\"_blank\" href=\"" + value + "\">" + value + "</a>";
            }
            return this.onInlineTag("link", value, context);
        }
        return RAW_LINK_PATTERN.matcher(value).replaceAll(" <a target=\"_blank\" href=\"$1\">$1</a>");
    }
}

