/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.DashStyle;
import com.vaadin.flow.component.charts.model.DataLabels;
import com.vaadin.flow.component.charts.model.Label;
import com.vaadin.flow.component.charts.model.Level;
import com.vaadin.flow.component.charts.model.Link;
import com.vaadin.flow.component.charts.model.States;
import com.vaadin.flow.component.charts.model.Tooltip;
import com.vaadin.flow.component.charts.model.style.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlotOptionsOrganization
extends AbstractPlotOptions {
    private List<Level> levels;
    private Boolean colorByPoint;
    private Color color;
    private DataLabels dataLabels;
    private Color borderColor;
    private Number nodeWidth;
    private String boostBlending;
    private Number borderRadius;
    private Number borderWidth;
    private Boolean centerInCategory;
    private String className;
    private Boolean clip;
    private Number colorIndex;
    private List<Color> colors;
    private String cursor;
    private DashStyle dashStyle;
    private String description;
    private Boolean enableMouseTracking;
    private Boolean getExtremesFromAll;
    private Number hangingIndent;
    private Label label;
    private Link link;
    private Color linkColor;
    private String linkedTo;
    private Number linkLineWidth;
    private Number linkOpacity;
    private Number linkRadius;
    private Number minLinkWidth;
    private Number nodePadding;
    private Number opacity;
    private Boolean selected;
    private Boolean showCheckbox;
    private Boolean showInLegend;
    private Boolean skipKeyboardNavigation;
    private States states;
    private Boolean stickyTracking;
    private Tooltip tooltip;
    private Number turboThreshold;
    private Boolean visible;

    public String getBoostBlending() {
        return this.boostBlending;
    }

    public void setBoostBlending(String boostBlending) {
        this.boostBlending = boostBlending;
    }

    public Number getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(Number borderRadius) {
        this.borderRadius = borderRadius;
    }

    public Number getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Number borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Boolean getCenterInCategory() {
        return this.centerInCategory;
    }

    public void setCenterInCategory(Boolean centerInCategory) {
        this.centerInCategory = centerInCategory;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Boolean getClip() {
        return this.clip;
    }

    public void setClip(Boolean clip) {
        this.clip = clip;
    }

    public Number getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(Number colorIndex) {
        this.colorIndex = colorIndex;
    }

    public Color[] getColors() {
        return this.toArray(this.colors, Color[]::new);
    }

    public void setColors(Color ... colors) {
        this.colors = this.toList(colors);
    }

    public void addColor(Color color) {
        if (this.colors == null) {
            this.colors = new ArrayList<Color>();
        }
        this.colors.add(color);
    }

    public void removeColor(Color color) {
        this.safeRemove(this.colors, color);
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public DashStyle getDashStyle() {
        return this.dashStyle;
    }

    public void setDashStyle(DashStyle dashStyle) {
        this.dashStyle = dashStyle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnableMouseTracking() {
        return this.enableMouseTracking;
    }

    public void setEnableMouseTracking(Boolean enableMouseTracking) {
        this.enableMouseTracking = enableMouseTracking;
    }

    public Boolean getGetExtremesFromAll() {
        return this.getExtremesFromAll;
    }

    public void setGetExtremesFromAll(Boolean getExtremesFromAll) {
        this.getExtremesFromAll = getExtremesFromAll;
    }

    public Number getHangingIndent() {
        return this.hangingIndent;
    }

    public void setHangingIndent(Number hangingIndent) {
        this.hangingIndent = hangingIndent;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Level[] getLevels() {
        return this.toArray(this.levels, Level[]::new);
    }

    public void setLevels(Level ... levels) {
        this.levels = this.toList(levels);
    }

    private <T> T[] toArray(List<T> list, IntFunction<T[]> generator) {
        return list != null ? list.stream().toArray(generator) : generator.apply(0);
    }

    private <T> List<T> toList(T ... items) {
        return Stream.of(items).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addLevel(Level level) {
        if (this.levels == null) {
            this.levels = new ArrayList<Level>();
        }
        this.levels.add(level);
    }

    public void removeLevel(Level level) {
        this.safeRemove(this.levels, level);
    }

    private <T> void safeRemove(List<T> list, T item) {
        if (list != null) {
            list.remove(item);
        }
    }

    public Link getLink() {
        if (this.link == null) {
            this.link = new Link();
        }
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Color getLinkColor() {
        return this.linkColor;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    public String getLinkedTo() {
        return this.linkedTo;
    }

    public void setLinkedTo(String linkedTo) {
        this.linkedTo = linkedTo;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Number getLinkLineWidth() {
        return this.linkLineWidth;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setLinkLineWidth(Number linkLineWidth) {
        this.linkLineWidth = linkLineWidth;
    }

    public Number getLinkOpacity() {
        return this.linkOpacity;
    }

    public void setLinkOpacity(Number linkOpacity) {
        this.linkOpacity = linkOpacity;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Number getLinkRadius() {
        return this.linkRadius;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setLinkRadius(Number linkRadius) {
        this.linkRadius = linkRadius;
    }

    public Number getMinLinkWidth() {
        return this.minLinkWidth;
    }

    public void setMinLinkWidth(Number minLinkWidth) {
        this.minLinkWidth = minLinkWidth;
    }

    public Number getNodePadding() {
        return this.nodePadding;
    }

    public void setNodePadding(Number nodePadding) {
        this.nodePadding = nodePadding;
    }

    public Number getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Number opacity) {
        this.opacity = opacity;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Boolean getShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(Boolean showCheckbox) {
        this.showCheckbox = showCheckbox;
    }

    public Boolean getShowInLegend() {
        return this.showInLegend;
    }

    public void setShowInLegend(Boolean showInLegend) {
        this.showInLegend = showInLegend;
    }

    public Boolean getSkipKeyboardNavigation() {
        return this.skipKeyboardNavigation;
    }

    public void setSkipKeyboardNavigation(Boolean skipKeyboardNavigation) {
        this.skipKeyboardNavigation = skipKeyboardNavigation;
    }

    public States getStates() {
        return this.states;
    }

    public void setStates(States states) {
        this.states = states;
    }

    public Boolean getStickyTracking() {
        return this.stickyTracking;
    }

    public void setStickyTracking(Boolean stickyTracking) {
        this.stickyTracking = stickyTracking;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public Number getTurboThreshold() {
        return this.turboThreshold;
    }

    public void setTurboThreshold(Number turboThreshold) {
        this.turboThreshold = turboThreshold;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean getColorByPoint() {
        return this.colorByPoint;
    }

    public void setColorByPoint(Boolean colorByPoint) {
        this.colorByPoint = colorByPoint;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public DataLabels getDataLabels() {
        return this.dataLabels;
    }

    public void setDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Number getNodeWidth() {
        return this.nodeWidth;
    }

    public void setNodeWidth(Number nodeWidth) {
        this.nodeWidth = nodeWidth;
    }

    @Override
    public ChartType getChartType() {
        return ChartType.ORGANIZATION;
    }
}

