/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.menu.RouteParamType;
import com.vaadin.hilla.route.RouteUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class ServerAndClientViewsProvider {
    private final NavigationAccessControl accessControl;
    private final DeploymentConfiguration deploymentConfiguration;
    private final boolean exposeServerRoutesToClient;
    private final ObjectMapper mapper = new ObjectMapper();
    private final ViewAccessChecker viewAccessChecker;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAndClientViewsProvider.class);

    public ServerAndClientViewsProvider(DeploymentConfiguration deploymentConfiguration, @Nullable NavigationAccessControl accessControl, @Nullable ViewAccessChecker viewAccessChecker, boolean exposeServerRoutesToClient) {
        this.deploymentConfiguration = deploymentConfiguration;
        this.accessControl = accessControl;
        this.viewAccessChecker = viewAccessChecker;
        this.exposeServerRoutesToClient = exposeServerRoutesToClient;
        this.mapper.addMixIn(AvailableViewInfo.class, IgnoreMixin.class);
    }

    public String createFileRoutesJson(VaadinRequest request) throws JsonProcessingException {
        HashMap<String, AvailableViewInfo> availableViews = new HashMap<String, AvailableViewInfo>(this.collectClientViews(request));
        boolean hasAutoLayout = MenuRegistry.hasHillaMainLayout((AbstractConfiguration)request.getService().getDeploymentConfiguration());
        if (this.exposeServerRoutesToClient) {
            LOGGER.debug("Exposing server-side views to the client based on user configuration");
            availableViews.putAll(this.collectServerViews(hasAutoLayout));
        }
        return this.mapper.writeValueAsString(availableViews);
    }

    protected Map<String, AvailableViewInfo> collectClientViews(VaadinRequest request) {
        Map viewInfoMap = MenuRegistry.collectClientMenuItems((boolean)true, (AbstractConfiguration)this.deploymentConfiguration, (VaadinRequest)request);
        HashSet clientViewEntries = new HashSet(viewInfoMap.keySet());
        for (String path : clientViewEntries) {
            if (!viewInfoMap.containsKey(path)) continue;
            AvailableViewInfo viewInfo = (AvailableViewInfo)viewInfoMap.get(path);
            if (ServerAndClientViewsProvider.hasRequiredParameter(viewInfo)) {
                viewInfoMap.remove(path);
                if (viewInfo.children() == null) continue;
                RouteUtil.removeChildren(viewInfoMap, viewInfo, path);
                continue;
            }
            if (viewInfo.children() == null) continue;
            viewInfoMap.remove(path);
        }
        return viewInfoMap;
    }

    private static boolean hasRequiredParameter(AvailableViewInfo viewInfo) {
        Map routeParameters = viewInfo.routeParameters();
        if (routeParameters != null && !routeParameters.isEmpty() && routeParameters.values().stream().anyMatch(paramType -> paramType == RouteParamType.REQUIRED)) {
            return true;
        }
        AvailableViewInfo parentViewInfo = null;
        if (parentViewInfo != null) {
            return ServerAndClientViewsProvider.hasRequiredParameter(parentViewInfo);
        }
        return false;
    }

    protected Map<String, AvailableViewInfo> collectServerViews(boolean hasMainMenu) {
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService == null) {
            LOGGER.debug("No VaadinService found, skipping server view collection");
            return Collections.emptyMap();
        }
        RouteRegistry serverRouteRegistry = vaadinService.getRouter().getRegistry();
        List<BeforeEnterListener> accessControls = Stream.of(this.accessControl, this.viewAccessChecker).filter(Objects::nonNull).toList();
        HashMap serverRoutes = new HashMap();
        if (vaadinService.getInstantiator().getMenuAccessControl().getPopulateClientSideMenu() == MenuAccessControl.PopulateClientMenu.ALWAYS || hasMainMenu) {
            MenuRegistry.collectAndAddServerMenuItems((RouteConfiguration)RouteConfiguration.forRegistry((RouteRegistry)serverRouteRegistry), accessControls, serverRoutes);
        }
        return serverRoutes.values().stream().filter(view -> view.routeParameters().values().stream().noneMatch(param -> param == RouteParamType.REQUIRED)).collect(Collectors.toMap(this::getMenuLink, Function.identity()));
    }

    private String getMenuLink(AvailableViewInfo info) {
        Set parameterNames = info.routeParameters().keySet();
        return Stream.of(info.route().split("/")).filter(Predicate.not(parameterNames::contains)).collect(Collectors.joining("/"));
    }

    static abstract class IgnoreMixin {
        IgnoreMixin() {
        }

        @JsonIgnore
        abstract List<AvailableViewInfo> children();
    }
}

