/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gentyref;

import com.googlecode.gentyref.GenericArrayTypeImpl;
import com.googlecode.gentyref.ParameterizedTypeImpl;
import com.googlecode.gentyref.UnresolvedTypeVariableException;
import com.googlecode.gentyref.WildcardTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VarMap {
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    VarMap() {
    }

    VarMap(ParameterizedType type) {
        Type owner;
        do {
            TypeVariable<Class<T>>[] typeParameters;
            Class clazz = (Class)type.getRawType();
            Type[] arguments = type.getActualTypeArguments();
            if (arguments.length != (typeParameters = clazz.getTypeParameters()).length) {
                throw new IllegalStateException("The given type [" + type + "] is inconsistent: it has " + arguments.length + " arguments instead of " + typeParameters.length);
            }
            for (int i = 0; i < arguments.length; ++i) {
                this.add(typeParameters[i], arguments[i]);
            }
        } while ((type = (owner = type.getOwnerType()) instanceof ParameterizedType ? (ParameterizedType)owner : null) != null);
    }

    void add(TypeVariable<?> variable, Type value) {
        this.map.put(variable, value);
    }

    void addAll(TypeVariable<?>[] variables, Type[] values) {
        assert (variables.length == values.length);
        for (int i = 0; i < variables.length; ++i) {
            this.map.put(variables[i], values[i]);
        }
    }

    VarMap(TypeVariable<?>[] variables, Type[] values) {
        this.addAll(variables, values);
    }

    Type map(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (!this.map.containsKey(type)) {
                throw new UnresolvedTypeVariableException(tv);
            }
            return this.map.get(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new ParameterizedTypeImpl((Class)pType.getRawType(), this.map(pType.getActualTypeArguments()), pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return new WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayTypeImpl.createArrayType(this.map(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    Type[] map(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.map(types[i]);
        }
        return result;
    }
}

