/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1GeneralizedTime;
import com.unboundid.asn1.ASN1UTCTime;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ASN1Buffer
implements Serializable {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_ONE = new byte[]{-127, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_TWO = new byte[]{-126, 0, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_THREE = new byte[]{-125, 0, 0, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_FOUR = new byte[]{-124, 0, 0, 0, 0};
    private static final long serialVersionUID = -4898230771376551562L;
    private final AtomicBoolean zeroBufferOnClear;
    private final ByteStringBuffer buffer;
    private final int maxBufferSize;

    public ASN1Buffer() {
        this(0x100000);
    }

    public ASN1Buffer(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.buffer = new ByteStringBuffer();
        this.zeroBufferOnClear = new AtomicBoolean(false);
    }

    public boolean zeroBufferOnClear() {
        return this.zeroBufferOnClear.get();
    }

    public void setZeroBufferOnClear() {
        this.zeroBufferOnClear.set(true);
    }

    public void clear() {
        this.buffer.clear(this.zeroBufferOnClear.getAndSet(false));
        if (this.maxBufferSize > 0 && this.buffer.capacity() > this.maxBufferSize) {
            this.buffer.setCapacity(this.maxBufferSize);
        }
    }

    public int length() {
        return this.buffer.length();
    }

    public void addElement(ASN1Element element) {
        element.encodeTo(this.buffer);
    }

    public void addBoolean(boolean booleanValue) {
        this.addBoolean((byte)1, booleanValue);
    }

    public void addBoolean(byte type, boolean booleanValue) {
        this.buffer.append(type);
        this.buffer.append((byte)1);
        if (booleanValue) {
            this.buffer.append((byte)-1);
        } else {
            this.buffer.append((byte)0);
        }
    }

    public void addEnumerated(int intValue) {
        this.addInteger((byte)10, intValue);
    }

    public void addEnumerated(byte type, int intValue) {
        this.addInteger(type, intValue);
    }

    public void addGeneralizedTime(Date date) {
        this.addGeneralizedTime(date.getTime());
    }

    public void addGeneralizedTime(byte type, Date date) {
        this.addGeneralizedTime(type, date.getTime());
    }

    public void addGeneralizedTime(long time) {
        this.addGeneralizedTime((byte)24, time);
    }

    public void addGeneralizedTime(byte type, long time) {
        this.buffer.append(type);
        String timestamp = ASN1GeneralizedTime.encodeTimestamp(time, true);
        ASN1Element.encodeLengthTo(timestamp.length(), this.buffer);
        this.buffer.append(timestamp);
    }

    public void addInteger(int intValue) {
        this.addInteger((byte)2, intValue);
    }

    public void addInteger(byte type, int intValue) {
        this.buffer.append(type);
        if (intValue < 0) {
            if ((intValue & 0xFFFFFF80) == -128) {
                this.buffer.append((byte)1);
                this.buffer.append((byte)(intValue & 0xFF));
            } else if ((intValue & Short.MIN_VALUE) == Short.MIN_VALUE) {
                this.buffer.append((byte)2);
                this.buffer.append((byte)(intValue >> 8 & 0xFF));
                this.buffer.append((byte)(intValue & 0xFF));
            } else if ((intValue & 0xFF800000) == -8388608) {
                this.buffer.append((byte)3);
                this.buffer.append((byte)(intValue >> 16 & 0xFF));
                this.buffer.append((byte)(intValue >> 8 & 0xFF));
                this.buffer.append((byte)(intValue & 0xFF));
            } else {
                this.buffer.append((byte)4);
                this.buffer.append((byte)(intValue >> 24 & 0xFF));
                this.buffer.append((byte)(intValue >> 16 & 0xFF));
                this.buffer.append((byte)(intValue >> 8 & 0xFF));
                this.buffer.append((byte)(intValue & 0xFF));
            }
        } else if ((intValue & 0x7F) == intValue) {
            this.buffer.append((byte)1);
            this.buffer.append((byte)(intValue & 0x7F));
        } else if ((intValue & Short.MAX_VALUE) == intValue) {
            this.buffer.append((byte)2);
            this.buffer.append((byte)(intValue >> 8 & 0x7F));
            this.buffer.append((byte)(intValue & 0xFF));
        } else if ((intValue & 0x7FFFFF) == intValue) {
            this.buffer.append((byte)3);
            this.buffer.append((byte)(intValue >> 16 & 0x7F));
            this.buffer.append((byte)(intValue >> 8 & 0xFF));
            this.buffer.append((byte)(intValue & 0xFF));
        } else {
            this.buffer.append((byte)4);
            this.buffer.append((byte)(intValue >> 24 & 0x7F));
            this.buffer.append((byte)(intValue >> 16 & 0xFF));
            this.buffer.append((byte)(intValue >> 8 & 0xFF));
            this.buffer.append((byte)(intValue & 0xFF));
        }
    }

    public void addInteger(long longValue) {
        this.addInteger((byte)2, longValue);
    }

    public void addInteger(byte type, long longValue) {
        this.buffer.append(type);
        if (longValue < 0L) {
            if ((longValue & 0xFFFFFFFFFFFFFF80L) == -128L) {
                this.buffer.append((byte)1);
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & 0xFFFFFFFFFFFF8000L) == -32768L) {
                this.buffer.append((byte)2);
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & 0xFFFFFFFFFF800000L) == -8388608L) {
                this.buffer.append((byte)3);
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                this.buffer.append((byte)4);
                this.buffer.append((byte)(longValue >> 24 & 0xFFL));
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & 0xFFFFFF8000000000L) == -549755813888L) {
                this.buffer.append((byte)5);
                this.buffer.append((byte)(longValue >> 32 & 0xFFL));
                this.buffer.append((byte)(longValue >> 24 & 0xFFL));
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & 0xFFFF800000000000L) == -140737488355328L) {
                this.buffer.append((byte)6);
                this.buffer.append((byte)(longValue >> 40 & 0xFFL));
                this.buffer.append((byte)(longValue >> 32 & 0xFFL));
                this.buffer.append((byte)(longValue >> 24 & 0xFFL));
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else if ((longValue & 0xFF80000000000000L) == -36028797018963968L) {
                this.buffer.append((byte)7);
                this.buffer.append((byte)(longValue >> 48 & 0xFFL));
                this.buffer.append((byte)(longValue >> 40 & 0xFFL));
                this.buffer.append((byte)(longValue >> 32 & 0xFFL));
                this.buffer.append((byte)(longValue >> 24 & 0xFFL));
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            } else {
                this.buffer.append((byte)8);
                this.buffer.append((byte)(longValue >> 56 & 0xFFL));
                this.buffer.append((byte)(longValue >> 48 & 0xFFL));
                this.buffer.append((byte)(longValue >> 40 & 0xFFL));
                this.buffer.append((byte)(longValue >> 32 & 0xFFL));
                this.buffer.append((byte)(longValue >> 24 & 0xFFL));
                this.buffer.append((byte)(longValue >> 16 & 0xFFL));
                this.buffer.append((byte)(longValue >> 8 & 0xFFL));
                this.buffer.append((byte)(longValue & 0xFFL));
            }
        } else if ((longValue & 0x7FL) == longValue) {
            this.buffer.append((byte)1);
            this.buffer.append((byte)(longValue & 0x7FL));
        } else if ((longValue & 0x7FFFL) == longValue) {
            this.buffer.append((byte)2);
            this.buffer.append((byte)(longValue >> 8 & 0x7FL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else if ((longValue & 0x7FFFFFL) == longValue) {
            this.buffer.append((byte)3);
            this.buffer.append((byte)(longValue >> 16 & 0x7FL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else if ((longValue & Integer.MAX_VALUE) == longValue) {
            this.buffer.append((byte)4);
            this.buffer.append((byte)(longValue >> 24 & 0x7FL));
            this.buffer.append((byte)(longValue >> 16 & 0xFFL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else if ((longValue & 0x7FFFFFFFFFL) == longValue) {
            this.buffer.append((byte)5);
            this.buffer.append((byte)(longValue >> 32 & 0x7FL));
            this.buffer.append((byte)(longValue >> 24 & 0xFFL));
            this.buffer.append((byte)(longValue >> 16 & 0xFFL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else if ((longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.buffer.append((byte)6);
            this.buffer.append((byte)(longValue >> 40 & 0x7FL));
            this.buffer.append((byte)(longValue >> 32 & 0xFFL));
            this.buffer.append((byte)(longValue >> 24 & 0xFFL));
            this.buffer.append((byte)(longValue >> 16 & 0xFFL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else if ((longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.buffer.append((byte)7);
            this.buffer.append((byte)(longValue >> 48 & 0x7FL));
            this.buffer.append((byte)(longValue >> 40 & 0xFFL));
            this.buffer.append((byte)(longValue >> 32 & 0xFFL));
            this.buffer.append((byte)(longValue >> 24 & 0xFFL));
            this.buffer.append((byte)(longValue >> 16 & 0xFFL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        } else {
            this.buffer.append((byte)8);
            this.buffer.append((byte)(longValue >> 56 & 0x7FL));
            this.buffer.append((byte)(longValue >> 48 & 0xFFL));
            this.buffer.append((byte)(longValue >> 40 & 0xFFL));
            this.buffer.append((byte)(longValue >> 32 & 0xFFL));
            this.buffer.append((byte)(longValue >> 24 & 0xFFL));
            this.buffer.append((byte)(longValue >> 16 & 0xFFL));
            this.buffer.append((byte)(longValue >> 8 & 0xFFL));
            this.buffer.append((byte)(longValue & 0xFFL));
        }
    }

    public void addInteger(BigInteger value) {
        this.addInteger((byte)2, value);
    }

    public void addInteger(byte type, BigInteger value) {
        this.buffer.append(type);
        byte[] valueBytes = value.toByteArray();
        ASN1Element.encodeLengthTo(valueBytes.length, this.buffer);
        this.buffer.append(valueBytes);
    }

    public void addNull() {
        this.addNull((byte)5);
    }

    public void addNull(byte type) {
        this.buffer.append(type);
        this.buffer.append((byte)0);
    }

    public void addOctetString() {
        this.addOctetString((byte)4);
    }

    public void addOctetString(byte type) {
        this.buffer.append(type);
        this.buffer.append((byte)0);
    }

    public void addOctetString(byte[] value) {
        this.addOctetString((byte)4, value);
    }

    public void addOctetString(CharSequence value) {
        if (value == null) {
            this.addOctetString((byte)4);
        } else {
            this.addOctetString((byte)4, value.toString());
        }
    }

    public void addOctetString(String value) {
        this.addOctetString((byte)4, value);
    }

    public void addOctetString(byte type, byte[] value) {
        this.buffer.append(type);
        if (value == null) {
            this.buffer.append((byte)0);
        } else {
            ASN1Element.encodeLengthTo(value.length, this.buffer);
            this.buffer.append(value);
        }
    }

    public void addOctetString(byte type, CharSequence value) {
        if (value == null) {
            this.addOctetString(type);
        } else {
            this.addOctetString(type, value.toString());
        }
    }

    public void addOctetString(byte type, String value) {
        this.buffer.append(type);
        if (value == null) {
            this.buffer.append((byte)0);
        } else {
            int lengthStartPos = this.buffer.length();
            ASN1Element.encodeLengthTo(value.length(), this.buffer);
            int valueStartPos = this.buffer.length();
            this.buffer.append(value);
            if (this.buffer.length() != valueStartPos + value.length()) {
                byte[] valueBytes = new byte[this.buffer.length() - valueStartPos];
                System.arraycopy(this.buffer.getBackingArray(), valueStartPos, valueBytes, 0, valueBytes.length);
                this.buffer.setLength(lengthStartPos);
                ASN1Element.encodeLengthTo(valueBytes.length, this.buffer);
                this.buffer.append(valueBytes);
            }
        }
    }

    public void addUTCTime(Date date) {
        this.addUTCTime(date.getTime());
    }

    public void addUTCTime(byte type, Date date) {
        this.addUTCTime(type, date.getTime());
    }

    public void addUTCTime(long time) {
        this.addUTCTime((byte)23, time);
    }

    public void addUTCTime(byte type, long time) {
        this.buffer.append(type);
        String timestamp = ASN1UTCTime.encodeTimestamp(time);
        ASN1Element.encodeLengthTo(timestamp.length(), this.buffer);
        this.buffer.append(timestamp);
    }

    public ASN1BufferSequence beginSequence() {
        return this.beginSequence((byte)48);
    }

    public ASN1BufferSequence beginSequence(byte type) {
        this.buffer.append(type);
        return new ASN1BufferSequence(this);
    }

    public ASN1BufferSet beginSet() {
        return this.beginSet((byte)49);
    }

    public ASN1BufferSet beginSet(byte type) {
        this.buffer.append(type);
        return new ASN1BufferSet(this);
    }

    void endSequenceOrSet(int valueStartPos) {
        int length = this.buffer.length() - valueStartPos;
        if (length == 0) {
            this.buffer.append((byte)0);
            return;
        }
        if ((length & 0x7F) == length) {
            this.buffer.insert(valueStartPos, (byte)length);
        } else if ((length & 0xFF) == length) {
            this.buffer.insert(valueStartPos, MULTIBYTE_LENGTH_HEADER_PLUS_ONE);
            byte[] backingArray = this.buffer.getBackingArray();
            backingArray[valueStartPos + 1] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFF) == length) {
            this.buffer.insert(valueStartPos, MULTIBYTE_LENGTH_HEADER_PLUS_TWO);
            byte[] backingArray = this.buffer.getBackingArray();
            backingArray[valueStartPos + 1] = (byte)(length >> 8 & 0xFF);
            backingArray[valueStartPos + 2] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFFFF) == length) {
            this.buffer.insert(valueStartPos, MULTIBYTE_LENGTH_HEADER_PLUS_THREE);
            byte[] backingArray = this.buffer.getBackingArray();
            backingArray[valueStartPos + 1] = (byte)(length >> 16 & 0xFF);
            backingArray[valueStartPos + 2] = (byte)(length >> 8 & 0xFF);
            backingArray[valueStartPos + 3] = (byte)(length & 0xFF);
        } else {
            this.buffer.insert(valueStartPos, MULTIBYTE_LENGTH_HEADER_PLUS_FOUR);
            byte[] backingArray = this.buffer.getBackingArray();
            backingArray[valueStartPos + 1] = (byte)(length >> 24 & 0xFF);
            backingArray[valueStartPos + 2] = (byte)(length >> 16 & 0xFF);
            backingArray[valueStartPos + 3] = (byte)(length >> 8 & 0xFF);
            backingArray[valueStartPos + 4] = (byte)(length & 0xFF);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (Debug.debugEnabled(DebugType.ASN1)) {
            Debug.debugASN1Write(this);
        }
        this.buffer.write(outputStream);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buffer.getBackingArray(), 0, this.buffer.length());
    }
}

