/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.wrapped;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.WrappedEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.WrappedVertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.util.WrappedEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.util.WrappedVertexSequence;

public class WrappedGraph
implements Graph {
    protected Graph rawGraph;

    public WrappedGraph(Graph rawGraph) {
        this.rawGraph = rawGraph;
    }

    @Override
    public void clear() {
        this.rawGraph.clear();
    }

    @Override
    public void shutdown() {
        this.rawGraph.shutdown();
    }

    @Override
    public Vertex addVertex(Object id) {
        return new WrappedVertex(this.rawGraph.addVertex(id));
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.rawGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new WrappedVertex(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new WrappedVertexSequence(this.rawGraph.getVertices().iterator());
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return new WrappedEdge(this.rawGraph.addEdge(id, ((WrappedVertex)outVertex).getRawVertex(), ((WrappedVertex)inVertex).getRawVertex(), label));
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.rawGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new WrappedEdge(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new WrappedEdgeSequence(this.rawGraph.getEdges().iterator());
    }

    @Override
    public void removeEdge(Edge edge) {
        this.rawGraph.removeEdge(((WrappedEdge)edge).getRawEdge());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.rawGraph.removeVertex(((WrappedVertex)vertex).getRawVertex());
    }

    public Graph getRawGraph() {
        return this.rawGraph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.rawGraph.toString());
    }
}

